/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;

public enum ValidationLevel {
    OFF("off"),
    STRICT("strict"),
    MODERATE("moderate");

    private final String value;

    private ValidationLevel(String value2) {
        this.value = value2;
    }

    public String getValue() {
        return this.value;
    }

    public static ValidationLevel fromString(String validationLevel) {
        Assertions.notNull("ValidationLevel", validationLevel);
        for (ValidationLevel action2 : ValidationLevel.values()) {
            if (!validationLevel.equalsIgnoreCase(action2.value)) continue;
            return action2;
        }
        throw new IllegalArgumentException(String.format("'%s' is not a valid ValidationLevel", validationLevel));
    }
}

