/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.PushOptions;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Updates {
    public static Bson combine(Bson ... updates) {
        return Updates.combine(Arrays.asList(updates));
    }

    public static Bson combine(List<? extends Bson> updates) {
        Assertions.notNull("updates", updates);
        return new CompositeUpdate(updates);
    }

    public static <TItem> Bson set(String fieldName2, @Nullable TItem value2) {
        return new SimpleUpdate<TItem>(fieldName2, value2, "$set");
    }

    public static Bson unset(String fieldName2) {
        return new SimpleUpdate<String>(fieldName2, "", "$unset");
    }

    public static Bson setOnInsert(Bson value2) {
        return new SimpleBsonKeyValue("$setOnInsert", value2);
    }

    public static <TItem> Bson setOnInsert(String fieldName2, @Nullable TItem value2) {
        return new SimpleUpdate<TItem>(fieldName2, value2, "$setOnInsert");
    }

    public static Bson rename(String fieldName2, String newFieldName) {
        Assertions.notNull("newFieldName", newFieldName);
        return new SimpleUpdate<String>(fieldName2, newFieldName, "$rename");
    }

    public static Bson inc(String fieldName2, Number number2) {
        Assertions.notNull("number", number2);
        return new SimpleUpdate<Number>(fieldName2, number2, "$inc");
    }

    public static Bson mul(String fieldName2, Number number2) {
        Assertions.notNull("number", number2);
        return new SimpleUpdate<Number>(fieldName2, number2, "$mul");
    }

    public static <TItem> Bson min(String fieldName2, TItem value2) {
        return new SimpleUpdate<TItem>(fieldName2, value2, "$min");
    }

    public static <TItem> Bson max(String fieldName2, TItem value2) {
        return new SimpleUpdate<TItem>(fieldName2, value2, "$max");
    }

    public static Bson currentDate(String fieldName2) {
        return new SimpleUpdate<Boolean>(fieldName2, true, "$currentDate");
    }

    public static Bson currentTimestamp(String fieldName2) {
        return new SimpleUpdate<BsonDocument>(fieldName2, new BsonDocument("$type", new BsonString("timestamp")), "$currentDate");
    }

    public static <TItem> Bson addToSet(String fieldName2, @Nullable TItem value2) {
        return new SimpleUpdate<TItem>(fieldName2, value2, "$addToSet");
    }

    public static <TItem> Bson addEachToSet(String fieldName2, List<TItem> values2) {
        return new WithEachUpdate<TItem>(fieldName2, values2, "$addToSet");
    }

    public static <TItem> Bson push(String fieldName2, @Nullable TItem value2) {
        return new SimpleUpdate<TItem>(fieldName2, value2, "$push");
    }

    public static <TItem> Bson pushEach(String fieldName2, List<TItem> values2) {
        return new PushUpdate<TItem>(fieldName2, values2, new PushOptions());
    }

    public static <TItem> Bson pushEach(String fieldName2, List<TItem> values2, PushOptions options2) {
        return new PushUpdate<TItem>(fieldName2, values2, options2);
    }

    public static <TItem> Bson pull(String fieldName2, @Nullable TItem value2) {
        return new SimpleUpdate<TItem>(fieldName2, value2, "$pull");
    }

    public static Bson pullByFilter(final Bson filter2) {
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
                BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
                writer2.writeStartDocument();
                writer2.writeName("$pull");
                BuildersHelper.encodeValue(writer2, filter2, codecRegistry);
                writer2.writeEndDocument();
                return writer2.getDocument();
            }
        };
    }

    public static <TItem> Bson pullAll(String fieldName2, List<TItem> values2) {
        return new PullAllUpdate<TItem>(fieldName2, values2);
    }

    public static Bson popFirst(String fieldName2) {
        return new SimpleUpdate<Integer>(fieldName2, -1, "$pop");
    }

    public static Bson popLast(String fieldName2) {
        return new SimpleUpdate<Integer>(fieldName2, 1, "$pop");
    }

    public static Bson bitwiseAnd(String fieldName2, int value2) {
        return Updates.createBitUpdateDocument(fieldName2, "and", value2);
    }

    public static Bson bitwiseAnd(String fieldName2, long value2) {
        return Updates.createBitUpdateDocument(fieldName2, "and", value2);
    }

    public static Bson bitwiseOr(String fieldName2, int value2) {
        return Updates.createBitUpdateDocument(fieldName2, "or", value2);
    }

    public static Bson bitwiseOr(String fieldName2, long value2) {
        return Updates.createBitUpdateDocument(fieldName2, "or", value2);
    }

    public static Bson bitwiseXor(String fieldName2, int value2) {
        return Updates.createBitUpdateDocument(fieldName2, "xor", value2);
    }

    public static Bson bitwiseXor(String fieldName2, long value2) {
        return Updates.createBitUpdateDocument(fieldName2, "xor", value2);
    }

    private static Bson createBitUpdateDocument(String fieldName2, String bitwiseOperator, int value2) {
        return Updates.createBitUpdateDocument(fieldName2, bitwiseOperator, new BsonInt32(value2));
    }

    private static Bson createBitUpdateDocument(String fieldName2, String bitwiseOperator, long value2) {
        return Updates.createBitUpdateDocument(fieldName2, bitwiseOperator, new BsonInt64(value2));
    }

    private static Bson createBitUpdateDocument(String fieldName2, String bitwiseOperator, BsonValue value2) {
        return new BsonDocument("$bit", new BsonDocument(fieldName2, new BsonDocument(bitwiseOperator, value2)));
    }

    private Updates() {
    }

    private static class CompositeUpdate
    implements Bson {
        private final List<? extends Bson> updates;

        CompositeUpdate(List<? extends Bson> updates) {
            this.updates = updates;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocument document2 = new BsonDocument();
            for (Bson bson : this.updates) {
                BsonDocument rendered = bson.toBsonDocument(tDocumentClass, codecRegistry);
                for (Map.Entry<String, BsonValue> element2 : rendered.entrySet()) {
                    if (document2.containsKey(element2.getKey())) {
                        BsonDocument currentOperatorDocument = (BsonDocument)element2.getValue();
                        BsonDocument existingOperatorDocument = document2.getDocument(element2.getKey());
                        for (Map.Entry<String, BsonValue> currentOperationDocumentElements : currentOperatorDocument.entrySet()) {
                            existingOperatorDocument.append(currentOperationDocumentElements.getKey(), currentOperationDocumentElements.getValue());
                        }
                        continue;
                    }
                    document2.append(element2.getKey(), element2.getValue());
                }
            }
            return document2;
        }

        public String toString() {
            return "Updates{updates=" + this.updates + '}';
        }
    }

    private static class PullAllUpdate<TItem>
    implements Bson {
        private final String fieldName;
        private final List<TItem> values;

        PullAllUpdate(String fieldName2, List<TItem> values2) {
            this.fieldName = Assertions.notNull("fieldName", fieldName2);
            this.values = Assertions.notNull("values", values2);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeName("$pullAll");
            writer2.writeStartDocument();
            writer2.writeName(this.fieldName);
            writer2.writeStartArray();
            for (TItem value2 : this.values) {
                BuildersHelper.encodeValue(writer2, value2, codecRegistry);
            }
            writer2.writeEndArray();
            writer2.writeEndDocument();
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Update{fieldName='" + this.fieldName + '\'' + ", operator='$pullAll', value=" + this.values + '}';
        }
    }

    private static class PushUpdate<TItem>
    extends WithEachUpdate<TItem> {
        private final PushOptions options;

        PushUpdate(String fieldName2, List<TItem> values2, PushOptions options2) {
            super(fieldName2, values2, "$push");
            this.options = Assertions.notNull("options", options2);
        }

        @Override
        protected <TDocument> void writeAdditionalFields(BsonDocumentWriter writer2, Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            Integer sort2;
            Integer slice2;
            Integer position2 = this.options.getPosition();
            if (position2 != null) {
                writer2.writeInt32("$position", position2);
            }
            if ((slice2 = this.options.getSlice()) != null) {
                writer2.writeInt32("$slice", slice2);
            }
            if ((sort2 = this.options.getSort()) != null) {
                writer2.writeInt32("$sort", sort2);
            } else {
                Bson sortDocument = this.options.getSortDocument();
                if (sortDocument != null) {
                    writer2.writeName("$sort");
                    BuildersHelper.encodeValue(writer2, sortDocument, codecRegistry);
                }
            }
        }

        @Override
        protected String additionalFieldsToString() {
            return ", options=" + this.options;
        }
    }

    private static class WithEachUpdate<TItem>
    implements Bson {
        private final String fieldName;
        private final List<TItem> values;
        private final String operator;

        WithEachUpdate(String fieldName2, List<TItem> values2, String operator2) {
            this.fieldName = Assertions.notNull("fieldName", fieldName2);
            this.values = Assertions.notNull("values", values2);
            this.operator = operator2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeName(this.operator);
            writer2.writeStartDocument();
            writer2.writeName(this.fieldName);
            writer2.writeStartDocument();
            writer2.writeStartArray("$each");
            for (TItem value2 : this.values) {
                BuildersHelper.encodeValue(writer2, value2, codecRegistry);
            }
            writer2.writeEndArray();
            this.writeAdditionalFields(writer2, tDocumentClass, codecRegistry);
            writer2.writeEndDocument();
            writer2.writeEndDocument();
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        protected <TDocument> void writeAdditionalFields(BsonDocumentWriter writer2, Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
        }

        protected String additionalFieldsToString() {
            return "";
        }

        public String toString() {
            return "Each Update{fieldName='" + this.fieldName + '\'' + ", operator='" + this.operator + '\'' + ", values=" + this.values + this.additionalFieldsToString() + '}';
        }
    }

    private static class SimpleUpdate<TItem>
    implements Bson {
        private final String fieldName;
        private final TItem value;
        private final String operator;

        SimpleUpdate(String fieldName2, TItem value2, String operator2) {
            this.fieldName = Assertions.notNull("fieldName", fieldName2);
            this.value = value2;
            this.operator = operator2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeName(this.operator);
            writer2.writeStartDocument();
            writer2.writeName(this.fieldName);
            BuildersHelper.encodeValue(writer2, this.value, codecRegistry);
            writer2.writeEndDocument();
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Update{fieldName='" + this.fieldName + '\'' + ", operator='" + this.operator + '\'' + ", value=" + this.value + '}';
        }
    }

    private static class SimpleBsonKeyValue
    implements Bson {
        private final String fieldName;
        private final Bson value;

        SimpleBsonKeyValue(String fieldName2, Bson value2) {
            this.fieldName = Assertions.notNull("fieldName", fieldName2);
            this.value = Assertions.notNull("value", value2);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeName(this.fieldName);
            BuildersHelper.encodeValue(writer2, this.value, codecRegistry);
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "SimpleBsonKeyValue{fieldName='" + this.fieldName + '\'' + ", value=" + this.value + '}';
        }
    }
}

