/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Sorts {
    private Sorts() {
    }

    public static Bson ascending(String ... fieldNames2) {
        return Sorts.ascending(Arrays.asList(fieldNames2));
    }

    public static Bson ascending(List<String> fieldNames2) {
        Assertions.notNull("fieldNames", fieldNames2);
        return Sorts.orderBy(fieldNames2, new BsonInt32(1));
    }

    public static Bson descending(String ... fieldNames2) {
        return Sorts.descending(Arrays.asList(fieldNames2));
    }

    public static Bson descending(List<String> fieldNames2) {
        Assertions.notNull("fieldNames", fieldNames2);
        return Sorts.orderBy(fieldNames2, new BsonInt32(-1));
    }

    public static Bson metaTextScore(String fieldName2) {
        return new BsonDocument(fieldName2, new BsonDocument("$meta", new BsonString("textScore")));
    }

    public static Bson orderBy(Bson ... sorts) {
        return Sorts.orderBy(Arrays.asList(sorts));
    }

    public static Bson orderBy(List<? extends Bson> sorts) {
        Assertions.notNull("sorts", sorts);
        return new CompoundSort(sorts);
    }

    private static Bson orderBy(List<String> fieldNames2, BsonValue value2) {
        BsonDocument document2 = new BsonDocument();
        for (String fieldName2 : fieldNames2) {
            document2.append(fieldName2, value2);
        }
        return document2;
    }

    private static final class CompoundSort
    implements Bson {
        private final List<? extends Bson> sorts;

        private CompoundSort(List<? extends Bson> sorts) {
            this.sorts = sorts;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument combinedDocument = new BsonDocument();
            for (Bson bson : this.sorts) {
                BsonDocument sortDocument = bson.toBsonDocument(documentClass, codecRegistry);
                for (String key : sortDocument.keySet()) {
                    combinedDocument.append(key, sortDocument.get(key));
                }
            }
            return combinedDocument;
        }

        public String toString() {
            return "Compound Sort{sorts=" + this.sorts + '}';
        }
    }
}

