/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import org.bson.conversions.Bson;

public final class ReplaceOneModel<T>
extends WriteModel<T> {
    private final Bson filter;
    private final T replacement;
    private final ReplaceOptions options;

    public ReplaceOneModel(Bson filter2, T replacement) {
        this(filter2, replacement, new ReplaceOptions());
    }

    @Deprecated
    public ReplaceOneModel(Bson filter2, T replacement, UpdateOptions options2) {
        this(filter2, replacement, ReplaceOptions.createReplaceOptions(options2));
    }

    public ReplaceOneModel(Bson filter2, T replacement, ReplaceOptions options2) {
        this.filter = Assertions.notNull("filter", filter2);
        this.options = Assertions.notNull("options", options2);
        this.replacement = Assertions.notNull("replacement", replacement);
    }

    public Bson getFilter() {
        return this.filter;
    }

    public T getReplacement() {
        return this.replacement;
    }

    @Deprecated
    public UpdateOptions getOptions() {
        return new UpdateOptions().bypassDocumentValidation(this.options.getBypassDocumentValidation()).collation(this.options.getCollation()).upsert(this.options.isUpsert());
    }

    public ReplaceOptions getReplaceOptions() {
        return this.options;
    }

    public String toString() {
        return "ReplaceOneModel{filter=" + this.filter + ", replacement=" + this.replacement + ", options=" + this.options + '}';
    }
}

