/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.SimpleExpression;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Projections {
    private Projections() {
    }

    public static <TExpression> Bson computed(String fieldName2, TExpression expression2) {
        return new SimpleExpression<TExpression>(fieldName2, expression2);
    }

    public static Bson include(String ... fieldNames2) {
        return Projections.include(Arrays.asList(fieldNames2));
    }

    public static Bson include(List<String> fieldNames2) {
        return Projections.combine(fieldNames2, new BsonInt32(1));
    }

    public static Bson exclude(String ... fieldNames2) {
        return Projections.exclude(Arrays.asList(fieldNames2));
    }

    public static Bson exclude(List<String> fieldNames2) {
        return Projections.combine(fieldNames2, new BsonInt32(0));
    }

    public static Bson excludeId() {
        return new BsonDocument("_id", new BsonInt32(0));
    }

    public static Bson elemMatch(String fieldName2) {
        return new BsonDocument(fieldName2 + ".$", new BsonInt32(1));
    }

    public static Bson elemMatch(String fieldName2, Bson filter2) {
        return new ElemMatchFilterProjection(fieldName2, filter2);
    }

    public static Bson metaTextScore(String fieldName2) {
        return new BsonDocument(fieldName2, new BsonDocument("$meta", new BsonString("textScore")));
    }

    public static Bson slice(String fieldName2, int limit2) {
        return new BsonDocument(fieldName2, new BsonDocument("$slice", new BsonInt32(limit2)));
    }

    public static Bson slice(String fieldName2, int skip, int limit2) {
        return new BsonDocument(fieldName2, new BsonDocument("$slice", new BsonArray(Arrays.asList(new BsonInt32(skip), new BsonInt32(limit2)))));
    }

    public static Bson fields(Bson ... projections2) {
        return Projections.fields(Arrays.asList(projections2));
    }

    public static Bson fields(List<? extends Bson> projections2) {
        Assertions.notNull("projections", projections2);
        return new FieldsProjection(projections2);
    }

    private static Bson combine(List<String> fieldNames2, BsonValue value2) {
        BsonDocument document2 = new BsonDocument();
        for (String fieldName2 : fieldNames2) {
            document2.remove(fieldName2);
            document2.append(fieldName2, value2);
        }
        return document2;
    }

    private static class ElemMatchFilterProjection
    implements Bson {
        private final String fieldName;
        private final Bson filter;

        ElemMatchFilterProjection(String fieldName2, Bson filter2) {
            this.fieldName = fieldName2;
            this.filter = filter2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            return new BsonDocument(this.fieldName, new BsonDocument("$elemMatch", this.filter.toBsonDocument(documentClass, codecRegistry)));
        }

        public String toString() {
            return "ElemMatch Projection{fieldName='" + this.fieldName + '\'' + ", filter=" + this.filter + '}';
        }
    }

    private static class FieldsProjection
    implements Bson {
        private final List<? extends Bson> projections;

        FieldsProjection(List<? extends Bson> projections2) {
            this.projections = projections2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument combinedDocument = new BsonDocument();
            for (Bson bson : this.projections) {
                BsonDocument sortDocument = bson.toBsonDocument(documentClass, codecRegistry);
                for (String key : sortDocument.keySet()) {
                    combinedDocument.remove(key);
                    combinedDocument.append(key, sortDocument.get(key));
                }
            }
            return combinedDocument;
        }

        public String toString() {
            return "Projections{projections=" + this.projections + '}';
        }
    }
}

