/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Indexes {
    private Indexes() {
    }

    public static Bson ascending(String ... fieldNames2) {
        return Indexes.ascending(Arrays.asList(fieldNames2));
    }

    public static Bson ascending(List<String> fieldNames2) {
        Assertions.notNull("fieldNames", fieldNames2);
        return Indexes.compoundIndex(fieldNames2, new BsonInt32(1));
    }

    public static Bson descending(String ... fieldNames2) {
        return Indexes.descending(Arrays.asList(fieldNames2));
    }

    public static Bson descending(List<String> fieldNames2) {
        Assertions.notNull("fieldNames", fieldNames2);
        return Indexes.compoundIndex(fieldNames2, new BsonInt32(-1));
    }

    public static Bson geo2dsphere(String ... fieldNames2) {
        return Indexes.geo2dsphere(Arrays.asList(fieldNames2));
    }

    public static Bson geo2dsphere(List<String> fieldNames2) {
        Assertions.notNull("fieldNames", fieldNames2);
        return Indexes.compoundIndex(fieldNames2, new BsonString("2dsphere"));
    }

    public static Bson geo2d(String fieldName2) {
        Assertions.notNull("fieldName", fieldName2);
        return new BsonDocument(fieldName2, new BsonString("2d"));
    }

    public static Bson geoHaystack(String fieldName2, Bson additional) {
        Assertions.notNull("fieldName", fieldName2);
        return Indexes.compoundIndex(new BsonDocument(fieldName2, new BsonString("geoHaystack")), additional);
    }

    public static Bson text(String fieldName2) {
        Assertions.notNull("fieldName", fieldName2);
        return new BsonDocument(fieldName2, new BsonString("text"));
    }

    public static Bson text() {
        return Indexes.text("$**");
    }

    public static Bson hashed(String fieldName2) {
        Assertions.notNull("fieldName", fieldName2);
        return new BsonDocument(fieldName2, new BsonString("hashed"));
    }

    public static Bson compoundIndex(Bson ... indexes) {
        return Indexes.compoundIndex(Arrays.asList(indexes));
    }

    public static Bson compoundIndex(final List<? extends Bson> indexes) {
        Assertions.notNull("indexes", indexes);
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                BsonDocument compoundIndex = new BsonDocument();
                for (Bson index2 : indexes) {
                    BsonDocument indexDocument = index2.toBsonDocument(documentClass, codecRegistry);
                    for (String key : indexDocument.keySet()) {
                        compoundIndex.append(key, indexDocument.get(key));
                    }
                }
                return compoundIndex;
            }
        };
    }

    private static Bson compoundIndex(List<String> fieldNames2, BsonValue value2) {
        BsonDocument document2 = new BsonDocument();
        for (String fieldName2 : fieldNames2) {
            document2.append(fieldName2, value2);
        }
        return document2;
    }
}

