/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.CursorType;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

@Deprecated
public final class FindOptions {
    private int batchSize;
    private int limit;
    private Bson modifiers;
    private Bson projection;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private int skip;
    private Bson sort;
    private CursorType cursorType = CursorType.NonTailable;
    private boolean noCursorTimeout;
    private boolean oplogReplay;
    private boolean partial;
    private Collation collation;
    private String comment;
    private Bson hint;
    private Bson max;
    private Bson min;
    private long maxScan;
    private boolean returnKey;
    private boolean showRecordId;
    private boolean snapshot;

    public FindOptions() {
    }

    @Deprecated
    public FindOptions(FindOptions from2) {
        this.batchSize = from2.batchSize;
        this.limit = from2.limit;
        this.modifiers = from2.modifiers;
        this.projection = from2.projection;
        this.maxTimeMS = from2.maxTimeMS;
        this.maxAwaitTimeMS = from2.maxAwaitTimeMS;
        this.skip = from2.skip;
        this.sort = from2.sort;
        this.cursorType = from2.cursorType;
        this.noCursorTimeout = from2.noCursorTimeout;
        this.oplogReplay = from2.oplogReplay;
        this.partial = from2.partial;
        this.comment = from2.comment;
        this.hint = from2.hint;
        this.max = from2.max;
        this.min = from2.min;
        this.maxScan = from2.maxScan;
        this.returnKey = from2.returnKey;
        this.showRecordId = from2.showRecordId;
        this.snapshot = from2.snapshot;
    }

    public int getLimit() {
        return this.limit;
    }

    public FindOptions limit(int limit2) {
        this.limit = limit2;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public FindOptions skip(int skip) {
        this.skip = skip;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxTime > = 0", maxTime >= 0L);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindOptions maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxAwaitTime > = 0", maxAwaitTime >= 0L);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public FindOptions batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Deprecated
    @Nullable
    public Bson getModifiers() {
        return this.modifiers;
    }

    @Deprecated
    public FindOptions modifiers(@Nullable Bson modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    @Nullable
    public Bson getProjection() {
        return this.projection;
    }

    public FindOptions projection(@Nullable Bson projection2) {
        this.projection = projection2;
        return this;
    }

    @Nullable
    public Bson getSort() {
        return this.sort;
    }

    public FindOptions sort(@Nullable Bson sort2) {
        this.sort = sort2;
        return this;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public FindOptions noCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public boolean isOplogReplay() {
        return this.oplogReplay;
    }

    public FindOptions oplogReplay(boolean oplogReplay) {
        this.oplogReplay = oplogReplay;
        return this;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public FindOptions partial(boolean partial2) {
        this.partial = partial2;
        return this;
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public FindOptions cursorType(CursorType cursorType) {
        this.cursorType = Assertions.notNull("cursorType", cursorType);
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public FindOptions collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public FindOptions comment(@Nullable String comment2) {
        this.comment = comment2;
        return this;
    }

    @Nullable
    public Bson getHint() {
        return this.hint;
    }

    public FindOptions hint(@Nullable Bson hint) {
        this.hint = hint;
        return this;
    }

    @Nullable
    public Bson getMax() {
        return this.max;
    }

    public FindOptions max(@Nullable Bson max2) {
        this.max = max2;
        return this;
    }

    @Nullable
    public Bson getMin() {
        return this.min;
    }

    public FindOptions min(@Nullable Bson min2) {
        this.min = min2;
        return this;
    }

    @Deprecated
    public long getMaxScan() {
        return this.maxScan;
    }

    @Deprecated
    public FindOptions maxScan(long maxScan) {
        this.maxScan = maxScan;
        return this;
    }

    public boolean isReturnKey() {
        return this.returnKey;
    }

    public FindOptions returnKey(boolean returnKey) {
        this.returnKey = returnKey;
        return this;
    }

    public boolean isShowRecordId() {
        return this.showRecordId;
    }

    public FindOptions showRecordId(boolean showRecordId) {
        this.showRecordId = showRecordId;
        return this;
    }

    @Deprecated
    public boolean isSnapshot() {
        return this.snapshot;
    }

    @Deprecated
    public FindOptions snapshot(boolean snapshot2) {
        this.snapshot = snapshot2;
        return this;
    }

    public String toString() {
        return "FindOptions{batchSize=" + this.batchSize + ", limit=" + this.limit + ", modifiers=" + this.modifiers + ", projection=" + this.projection + ", maxTimeMS=" + this.maxTimeMS + ", maxAwaitTimeMS=" + this.maxAwaitTimeMS + ", skip=" + this.skip + ", sort=" + this.sort + ", cursorType=" + (Object)((Object)this.cursorType) + ", noCursorTimeout=" + this.noCursorTimeout + ", oplogReplay=" + this.oplogReplay + ", partial=" + this.partial + ", collation=" + this.collation + ", comment='" + this.comment + "', hint=" + this.hint + ", max=" + this.max + ", min=" + this.min + ", maxScan=" + this.maxScan + ", returnKey=" + this.returnKey + ", showRecordId=" + this.showRecordId + ", snapshot=" + this.snapshot + "}";
    }
}

