/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.TextSearchOptions;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Filters {
    private Filters() {
    }

    public static <TItem> Bson eq(@Nullable TItem value2) {
        return Filters.eq("_id", value2);
    }

    public static <TItem> Bson eq(String fieldName2, @Nullable TItem value2) {
        return new SimpleEncodingFilter<TItem>(fieldName2, value2);
    }

    public static <TItem> Bson ne(String fieldName2, @Nullable TItem value2) {
        return new OperatorFilter<TItem>("$ne", fieldName2, value2);
    }

    public static <TItem> Bson gt(String fieldName2, TItem value2) {
        return new OperatorFilter<TItem>("$gt", fieldName2, value2);
    }

    public static <TItem> Bson lt(String fieldName2, TItem value2) {
        return new OperatorFilter<TItem>("$lt", fieldName2, value2);
    }

    public static <TItem> Bson gte(String fieldName2, TItem value2) {
        return new OperatorFilter<TItem>("$gte", fieldName2, value2);
    }

    public static <TItem> Bson lte(String fieldName2, TItem value2) {
        return new OperatorFilter<TItem>("$lte", fieldName2, value2);
    }

    public static <TItem> Bson in(String fieldName2, TItem ... values2) {
        return Filters.in(fieldName2, Arrays.asList(values2));
    }

    public static <TItem> Bson in(String fieldName2, Iterable<TItem> values2) {
        return new IterableOperatorFilter<TItem>(fieldName2, "$in", values2);
    }

    public static <TItem> Bson nin(String fieldName2, TItem ... values2) {
        return Filters.nin(fieldName2, Arrays.asList(values2));
    }

    public static <TItem> Bson nin(String fieldName2, Iterable<TItem> values2) {
        return new IterableOperatorFilter<TItem>(fieldName2, "$nin", values2);
    }

    public static Bson and(Iterable<Bson> filters) {
        return new AndFilter(filters);
    }

    public static Bson and(Bson ... filters) {
        return Filters.and(Arrays.asList(filters));
    }

    public static Bson or(Iterable<Bson> filters) {
        return new OrNorFilter(OrNorFilter.Operator.OR, filters);
    }

    public static Bson or(Bson ... filters) {
        return Filters.or(Arrays.asList(filters));
    }

    public static Bson not(Bson filter2) {
        return new NotFilter(filter2);
    }

    public static Bson nor(Bson ... filters) {
        return Filters.nor(Arrays.asList(filters));
    }

    public static Bson nor(Iterable<Bson> filters) {
        return new OrNorFilter(OrNorFilter.Operator.NOR, filters);
    }

    public static Bson exists(String fieldName2) {
        return Filters.exists(fieldName2, true);
    }

    public static Bson exists(String fieldName2, boolean exists2) {
        return new OperatorFilter<BsonBoolean>("$exists", fieldName2, BsonBoolean.valueOf(exists2));
    }

    public static Bson type(String fieldName2, BsonType type) {
        return new OperatorFilter<BsonInt32>("$type", fieldName2, new BsonInt32(type.getValue()));
    }

    public static Bson type(String fieldName2, String type) {
        return new OperatorFilter<BsonString>("$type", fieldName2, new BsonString(type));
    }

    public static Bson mod(String fieldName2, long divisor, long remainder) {
        return new OperatorFilter<BsonArray>("$mod", fieldName2, new BsonArray(Arrays.asList(new BsonInt64(divisor), new BsonInt64(remainder))));
    }

    public static Bson regex(String fieldName2, String pattern) {
        return Filters.regex(fieldName2, pattern, null);
    }

    public static Bson regex(String fieldName2, String pattern, @Nullable String options2) {
        Assertions.notNull("pattern", pattern);
        return new SimpleFilter(fieldName2, new BsonRegularExpression(pattern, options2));
    }

    public static Bson regex(String fieldName2, Pattern pattern) {
        Assertions.notNull("pattern", pattern);
        return new SimpleEncodingFilter<Pattern>(fieldName2, pattern);
    }

    public static Bson text(String search) {
        Assertions.notNull("search", search);
        return Filters.text(search, new TextSearchOptions());
    }

    @Deprecated
    public static Bson text(String search, String language2) {
        Assertions.notNull("search", search);
        return Filters.text(search, new TextSearchOptions().language(language2));
    }

    public static Bson text(String search, TextSearchOptions textSearchOptions) {
        Assertions.notNull("search", search);
        Assertions.notNull("textSearchOptions", textSearchOptions);
        return new TextFilter(search, textSearchOptions);
    }

    public static Bson where(String javaScriptExpression) {
        Assertions.notNull("javaScriptExpression", javaScriptExpression);
        return new BsonDocument("$where", new BsonString(javaScriptExpression));
    }

    public static <TExpression> Bson expr(TExpression expression2) {
        return new SimpleEncodingFilter<TExpression>("$expr", expression2);
    }

    public static <TItem> Bson all(String fieldName2, TItem ... values2) {
        return Filters.all(fieldName2, Arrays.asList(values2));
    }

    public static <TItem> Bson all(String fieldName2, Iterable<TItem> values2) {
        return new IterableOperatorFilter<TItem>(fieldName2, "$all", values2);
    }

    public static Bson elemMatch(final String fieldName2, final Bson filter2) {
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                return new BsonDocument(fieldName2, new BsonDocument("$elemMatch", filter2.toBsonDocument(documentClass, codecRegistry)));
            }
        };
    }

    public static Bson size(String fieldName2, int size2) {
        return new OperatorFilter<Integer>("$size", fieldName2, size2);
    }

    public static Bson bitsAllClear(String fieldName2, long bitmask) {
        return new OperatorFilter<Long>("$bitsAllClear", fieldName2, bitmask);
    }

    public static Bson bitsAllSet(String fieldName2, long bitmask) {
        return new OperatorFilter<Long>("$bitsAllSet", fieldName2, bitmask);
    }

    public static Bson bitsAnyClear(String fieldName2, long bitmask) {
        return new OperatorFilter<Long>("$bitsAnyClear", fieldName2, bitmask);
    }

    public static Bson bitsAnySet(String fieldName2, long bitmask) {
        return new OperatorFilter<Long>("$bitsAnySet", fieldName2, bitmask);
    }

    public static Bson geoWithin(String fieldName2, Geometry geometry) {
        return new GeometryOperatorFilter<Geometry>("$geoWithin", fieldName2, geometry);
    }

    public static Bson geoWithin(String fieldName2, Bson geometry) {
        return new GeometryOperatorFilter<Bson>("$geoWithin", fieldName2, geometry);
    }

    public static Bson geoWithinBox(String fieldName2, double lowerLeftX, double lowerLeftY, double upperRightX, double upperRightY) {
        BsonDocument box2 = new BsonDocument("$box", new BsonArray(Arrays.asList(new BsonArray(Arrays.asList(new BsonDouble(lowerLeftX), new BsonDouble(lowerLeftY))), new BsonArray(Arrays.asList(new BsonDouble(upperRightX), new BsonDouble(upperRightY))))));
        return new OperatorFilter<BsonDocument>("$geoWithin", fieldName2, box2);
    }

    public static Bson geoWithinPolygon(String fieldName2, List<List<Double>> points) {
        BsonArray pointsArray = new BsonArray();
        for (List<Double> point2 : points) {
            pointsArray.add(new BsonArray(Arrays.asList(new BsonDouble(point2.get(0)), new BsonDouble(point2.get(1)))));
        }
        BsonDocument polygon = new BsonDocument("$polygon", pointsArray);
        return new OperatorFilter<BsonDocument>("$geoWithin", fieldName2, polygon);
    }

    public static Bson geoWithinCenter(String fieldName2, double x, double y2, double radius) {
        BsonDocument center = new BsonDocument("$center", new BsonArray(Arrays.asList(new BsonArray(Arrays.asList(new BsonDouble(x), new BsonDouble(y2))), new BsonDouble(radius))));
        return new OperatorFilter<BsonDocument>("$geoWithin", fieldName2, center);
    }

    public static Bson geoWithinCenterSphere(String fieldName2, double x, double y2, double radius) {
        BsonDocument centerSphere = new BsonDocument("$centerSphere", new BsonArray(Arrays.asList(new BsonArray(Arrays.asList(new BsonDouble(x), new BsonDouble(y2))), new BsonDouble(radius))));
        return new OperatorFilter<BsonDocument>("$geoWithin", fieldName2, centerSphere);
    }

    public static Bson geoIntersects(String fieldName2, Bson geometry) {
        return new GeometryOperatorFilter<Bson>("$geoIntersects", fieldName2, geometry);
    }

    public static Bson geoIntersects(String fieldName2, Geometry geometry) {
        return new GeometryOperatorFilter<Geometry>("$geoIntersects", fieldName2, geometry);
    }

    public static Bson near(String fieldName2, Point geometry, Double maxDistance, Double minDistance) {
        return new GeometryOperatorFilter<Point>("$near", fieldName2, geometry, maxDistance, minDistance);
    }

    public static Bson near(String fieldName2, Bson geometry, Double maxDistance, Double minDistance) {
        return new GeometryOperatorFilter<Bson>("$near", fieldName2, geometry, maxDistance, minDistance);
    }

    public static Bson near(String fieldName2, double x, double y2, Double maxDistance, Double minDistance) {
        return Filters.createNearFilterDocument(fieldName2, x, y2, maxDistance, minDistance, "$near");
    }

    public static Bson nearSphere(String fieldName2, Point geometry, Double maxDistance, Double minDistance) {
        return new GeometryOperatorFilter<Point>("$nearSphere", fieldName2, geometry, maxDistance, minDistance);
    }

    public static Bson nearSphere(String fieldName2, Bson geometry, Double maxDistance, Double minDistance) {
        return new GeometryOperatorFilter<Bson>("$nearSphere", fieldName2, geometry, maxDistance, minDistance);
    }

    public static Bson nearSphere(String fieldName2, double x, double y2, Double maxDistance, Double minDistance) {
        return Filters.createNearFilterDocument(fieldName2, x, y2, maxDistance, minDistance, "$nearSphere");
    }

    public static Bson jsonSchema(Bson schema) {
        return new SimpleEncodingFilter<Bson>("$jsonSchema", schema);
    }

    private static Bson createNearFilterDocument(String fieldName2, double x, double y2, @Nullable Double maxDistance, @Nullable Double minDistance, String operator2) {
        BsonDocument nearFilter = new BsonDocument(operator2, new BsonArray(Arrays.asList(new BsonDouble(x), new BsonDouble(y2))));
        if (maxDistance != null) {
            nearFilter.append("$maxDistance", new BsonDouble(maxDistance));
        }
        if (minDistance != null) {
            nearFilter.append("$minDistance", new BsonDouble(minDistance));
        }
        return new BsonDocument(fieldName2, nearFilter);
    }

    private static String operatorFilterToString(String fieldName2, String operator2, Object value2) {
        return "Operator Filter{fieldName='" + fieldName2 + '\'' + ", operator='" + operator2 + '\'' + ", value=" + value2 + '}';
    }

    private static class TextFilter
    implements Bson {
        private final String search;
        private final TextSearchOptions textSearchOptions;

        TextFilter(String search, TextSearchOptions textSearchOptions) {
            this.search = search;
            this.textSearchOptions = textSearchOptions;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            Boolean diacriticSensitive;
            Boolean caseSensitive;
            BsonDocument searchDocument = new BsonDocument("$search", new BsonString(this.search));
            String language2 = this.textSearchOptions.getLanguage();
            if (language2 != null) {
                searchDocument.put("$language", new BsonString(language2));
            }
            if ((caseSensitive = this.textSearchOptions.getCaseSensitive()) != null) {
                searchDocument.put("$caseSensitive", BsonBoolean.valueOf(caseSensitive));
            }
            if ((diacriticSensitive = this.textSearchOptions.getDiacriticSensitive()) != null) {
                searchDocument.put("$diacriticSensitive", BsonBoolean.valueOf(diacriticSensitive));
            }
            return new BsonDocument("$text", searchDocument);
        }

        public String toString() {
            return "Text Filter{search='" + this.search + '\'' + ", textSearchOptions=" + this.textSearchOptions + '}';
        }
    }

    private static class GeometryOperatorFilter<TItem>
    implements Bson {
        private final String operatorName;
        private final String fieldName;
        private final TItem geometry;
        private final Double maxDistance;
        private final Double minDistance;

        GeometryOperatorFilter(String operatorName, String fieldName2, TItem geometry) {
            this(operatorName, fieldName2, geometry, null, null);
        }

        GeometryOperatorFilter(String operatorName, String fieldName2, TItem geometry, @Nullable Double maxDistance, @Nullable Double minDistance) {
            this.operatorName = operatorName;
            this.fieldName = Assertions.notNull("fieldName", fieldName2);
            this.geometry = Assertions.notNull("geometry", geometry);
            this.maxDistance = maxDistance;
            this.minDistance = minDistance;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeName(this.fieldName);
            writer2.writeStartDocument();
            writer2.writeName(this.operatorName);
            writer2.writeStartDocument();
            writer2.writeName("$geometry");
            BuildersHelper.encodeValue(writer2, this.geometry, codecRegistry);
            if (this.maxDistance != null) {
                writer2.writeDouble("$maxDistance", this.maxDistance);
            }
            if (this.minDistance != null) {
                writer2.writeDouble("$minDistance", this.minDistance);
            }
            writer2.writeEndDocument();
            writer2.writeEndDocument();
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Geometry Operator Filter{fieldName='" + this.fieldName + '\'' + ", operator='" + this.operatorName + '\'' + ", geometry=" + this.geometry + ", maxDistance=" + this.maxDistance + ", minDistance=" + this.minDistance + '}';
        }
    }

    private static class NotFilter
    implements Bson {
        private static final Set<String> DBREF_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("$ref", "$id")));
        private static final Set<String> DBREF_KEYS_WITH_DB = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("$ref", "$id", "$db")));
        private final Bson filter;

        NotFilter(Bson filter2) {
            this.filter = Assertions.notNull("filter", filter2);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument filterDocument = this.filter.toBsonDocument(documentClass, codecRegistry);
            if (filterDocument.size() == 1) {
                Map.Entry<String, BsonValue> entry2 = filterDocument.entrySet().iterator().next();
                return this.createFilter(entry2.getKey(), entry2.getValue());
            }
            BsonArray values2 = new BsonArray();
            for (Map.Entry<String, BsonValue> docs : filterDocument.entrySet()) {
                values2.add(new BsonDocument(docs.getKey(), docs.getValue()));
            }
            return this.createFilter("$and", values2);
        }

        private boolean containsOperator(BsonDocument value2) {
            Set<String> keys2 = value2.keySet();
            if (keys2.equals(DBREF_KEYS) || keys2.equals(DBREF_KEYS_WITH_DB)) {
                return false;
            }
            for (String key : keys2) {
                if (!key.startsWith("$")) continue;
                return true;
            }
            return false;
        }

        private BsonDocument createFilter(String fieldName2, BsonValue value2) {
            if (fieldName2.startsWith("$")) {
                return new BsonDocument("$not", new BsonDocument(fieldName2, value2));
            }
            if (value2.isDocument() && this.containsOperator(value2.asDocument()) || value2.isRegularExpression()) {
                return new BsonDocument(fieldName2, new BsonDocument("$not", value2));
            }
            return new BsonDocument(fieldName2, new BsonDocument("$not", new BsonDocument("$eq", value2)));
        }

        public String toString() {
            return "Not Filter{filter=" + this.filter + '}';
        }
    }

    private static class SimpleEncodingFilter<TItem>
    implements Bson {
        private final String fieldName;
        private final TItem value;

        SimpleEncodingFilter(String fieldName2, TItem value2) {
            this.fieldName = Assertions.notNull("fieldName", fieldName2);
            this.value = value2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeName(this.fieldName);
            BuildersHelper.encodeValue(writer2, this.value, codecRegistry);
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Filter{fieldName='" + this.fieldName + '\'' + ", value=" + this.value + '}';
        }
    }

    private static class IterableOperatorFilter<TItem>
    implements Bson {
        private final String fieldName;
        private final String operatorName;
        private final Iterable<TItem> values;

        IterableOperatorFilter(String fieldName2, String operatorName, Iterable<TItem> values2) {
            this.fieldName = Assertions.notNull("fieldName", fieldName2);
            this.operatorName = Assertions.notNull("operatorName", operatorName);
            this.values = Assertions.notNull("values", values2);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeName(this.fieldName);
            writer2.writeStartDocument();
            writer2.writeName(this.operatorName);
            writer2.writeStartArray();
            for (TItem value2 : this.values) {
                BuildersHelper.encodeValue(writer2, value2, codecRegistry);
            }
            writer2.writeEndArray();
            writer2.writeEndDocument();
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return Filters.operatorFilterToString(this.fieldName, this.operatorName, this.values);
        }
    }

    private static class OrNorFilter
    implements Bson {
        private final Operator operator;
        private final Iterable<Bson> filters;

        OrNorFilter(Operator operator2, Iterable<Bson> filters) {
            this.operator = Assertions.notNull("operator", operator2);
            this.filters = Assertions.notNull("filters", filters);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument orRenderable = new BsonDocument();
            BsonArray filtersArray = new BsonArray();
            for (Bson filter2 : this.filters) {
                filtersArray.add(filter2.toBsonDocument(documentClass, codecRegistry));
            }
            orRenderable.put(this.operator.name, filtersArray);
            return orRenderable;
        }

        public String toString() {
            return this.operator.toStringName + " Filter{filters=" + this.filters + '}';
        }

        private static enum Operator {
            OR("$or", "Or"),
            NOR("$nor", "Nor");

            private final String name;
            private final String toStringName;

            private Operator(String name, String toStringName) {
                this.name = name;
                this.toStringName = toStringName;
            }
        }
    }

    private static class AndFilter
    implements Bson {
        private final Iterable<Bson> filters;

        AndFilter(Iterable<Bson> filters) {
            this.filters = Assertions.notNull("filters", filters);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument andRenderable = new BsonDocument();
            for (Bson filter2 : this.filters) {
                BsonDocument renderedRenderable = filter2.toBsonDocument(documentClass, codecRegistry);
                for (Map.Entry<String, BsonValue> element2 : renderedRenderable.entrySet()) {
                    this.addClause(andRenderable, element2);
                }
            }
            if (andRenderable.isEmpty()) {
                andRenderable.append("$and", new BsonArray());
            }
            return andRenderable;
        }

        private void addClause(BsonDocument document2, Map.Entry<String, BsonValue> clause) {
            if (clause.getKey().equals("$and")) {
                for (BsonValue value2 : clause.getValue().asArray()) {
                    for (Map.Entry<String, BsonValue> element2 : value2.asDocument().entrySet()) {
                        this.addClause(document2, element2);
                    }
                }
            } else if (document2.size() == 1 && document2.keySet().iterator().next().equals("$and")) {
                document2.get("$and").asArray().add(new BsonDocument(clause.getKey(), clause.getValue()));
            } else if (document2.containsKey(clause.getKey())) {
                if (document2.get(clause.getKey()).isDocument() && clause.getValue().isDocument()) {
                    BsonDocument existingClauseValue = document2.get(clause.getKey()).asDocument();
                    BsonDocument clauseValue = clause.getValue().asDocument();
                    if (this.keysIntersect(clauseValue, existingClauseValue)) {
                        this.promoteRenderableToDollarForm(document2, clause);
                    } else {
                        existingClauseValue.putAll(clauseValue);
                    }
                } else {
                    this.promoteRenderableToDollarForm(document2, clause);
                }
            } else {
                document2.append(clause.getKey(), clause.getValue());
            }
        }

        private boolean keysIntersect(BsonDocument first2, BsonDocument second2) {
            for (String name : first2.keySet()) {
                if (!second2.containsKey(name)) continue;
                return true;
            }
            return false;
        }

        private void promoteRenderableToDollarForm(BsonDocument document2, Map.Entry<String, BsonValue> clause) {
            BsonArray clauses = new BsonArray();
            for (Map.Entry<String, BsonValue> queryElement : document2.entrySet()) {
                clauses.add(new BsonDocument(queryElement.getKey(), queryElement.getValue()));
            }
            clauses.add(new BsonDocument(clause.getKey(), clause.getValue()));
            document2.clear();
            document2.put("$and", clauses);
        }

        public String toString() {
            return "And Filter{filters=" + this.filters + '}';
        }
    }

    private static final class OperatorFilter<TItem>
    implements Bson {
        private final String operatorName;
        private final String fieldName;
        private final TItem value;

        OperatorFilter(String operatorName, String fieldName2, TItem value2) {
            this.operatorName = Assertions.notNull("operatorName", operatorName);
            this.fieldName = Assertions.notNull("fieldName", fieldName2);
            this.value = value2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeName(this.fieldName);
            writer2.writeStartDocument();
            writer2.writeName(this.operatorName);
            BuildersHelper.encodeValue(writer2, this.value, codecRegistry);
            writer2.writeEndDocument();
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return Filters.operatorFilterToString(this.fieldName, this.operatorName, this.value);
        }
    }

    private static final class SimpleFilter
    implements Bson {
        private final String fieldName;
        private final BsonValue value;

        private SimpleFilter(String fieldName2, BsonValue value2) {
            this.fieldName = Assertions.notNull("fieldName", fieldName2);
            this.value = Assertions.notNull("value", value2);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            return new BsonDocument(this.fieldName, this.value);
        }

        public String toString() {
            return Filters.operatorFilterToString(this.fieldName, "$eq", this.value);
        }
    }
}

