/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.BucketAutoOptions;
import com.mongodb.client.model.BucketGranularity;
import com.mongodb.client.model.BucketOptions;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.Facet;
import com.mongodb.client.model.Field;
import com.mongodb.client.model.GraphLookupOptions;
import com.mongodb.client.model.UnwindOptions;
import com.mongodb.client.model.Variable;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Aggregates {
    public static Bson addFields(Field<?> ... fields) {
        return Aggregates.addFields(Arrays.asList(fields));
    }

    public static Bson addFields(List<Field<?>> fields) {
        return new AddFieldsStage(fields);
    }

    public static <TExpression, Boundary> Bson bucket(TExpression groupBy2, List<Boundary> boundaries) {
        return Aggregates.bucket(groupBy2, boundaries, new BucketOptions());
    }

    public static <TExpression, TBoundary> Bson bucket(TExpression groupBy2, List<TBoundary> boundaries, BucketOptions options2) {
        return new BucketStage<TExpression, TBoundary>(groupBy2, boundaries, options2);
    }

    public static <TExpression> Bson bucketAuto(TExpression groupBy2, int buckets) {
        return Aggregates.bucketAuto(groupBy2, buckets, new BucketAutoOptions());
    }

    public static <TExpression> Bson bucketAuto(TExpression groupBy2, int buckets, BucketAutoOptions options2) {
        return new BucketAutoStage<TExpression>(groupBy2, buckets, options2);
    }

    public static Bson count() {
        return Aggregates.count("count");
    }

    public static Bson count(String field2) {
        return new BsonDocument("$count", new BsonString(field2));
    }

    public static Bson match(Bson filter2) {
        return new SimplePipelineStage("$match", filter2);
    }

    public static Bson project(Bson projection2) {
        return new SimplePipelineStage("$project", projection2);
    }

    public static Bson sort(Bson sort2) {
        return new SimplePipelineStage("$sort", sort2);
    }

    public static <TExpression> Bson sortByCount(TExpression filter2) {
        return new SortByCountStage<TExpression>(filter2);
    }

    public static Bson skip(int skip) {
        return new BsonDocument("$skip", new BsonInt32(skip));
    }

    public static Bson limit(int limit2) {
        return new BsonDocument("$limit", new BsonInt32(limit2));
    }

    public static Bson lookup(String from2, String localField, String foreignField, String as2) {
        return new BsonDocument("$lookup", new BsonDocument("from", new BsonString(from2)).append("localField", new BsonString(localField)).append("foreignField", new BsonString(foreignField)).append("as", new BsonString(as2)));
    }

    public static Bson lookup(String from2, List<? extends Bson> pipeline, String as2) {
        return Aggregates.lookup(from2, null, pipeline, as2);
    }

    public static <TExpression> Bson lookup(String from2, @Nullable List<Variable<TExpression>> let, List<? extends Bson> pipeline, String as2) {
        return new LookupStage(from2, let, pipeline, as2);
    }

    public static Bson facet(List<Facet> facets) {
        return new FacetStage(facets);
    }

    public static Bson facet(Facet ... facets) {
        return new FacetStage(Arrays.asList(facets));
    }

    public static <TExpression> Bson graphLookup(String from2, TExpression startWith, String connectFromField, String connectToField, String as2) {
        return Aggregates.graphLookup(from2, startWith, connectFromField, connectToField, as2, new GraphLookupOptions());
    }

    public static <TExpression> Bson graphLookup(String from2, TExpression startWith, String connectFromField, String connectToField, String as2, GraphLookupOptions options2) {
        Assertions.notNull("options", options2);
        return new GraphLookupStage(from2, startWith, connectFromField, connectToField, as2, options2);
    }

    public static <TExpression> Bson group(@Nullable TExpression id2, BsonField ... fieldAccumulators) {
        return Aggregates.group(id2, Arrays.asList(fieldAccumulators));
    }

    public static <TExpression> Bson group(@Nullable TExpression id2, List<BsonField> fieldAccumulators) {
        return new GroupStage<TExpression>(id2, fieldAccumulators);
    }

    public static Bson unwind(String fieldName2) {
        return new BsonDocument("$unwind", new BsonString(fieldName2));
    }

    public static Bson unwind(String fieldName2, UnwindOptions unwindOptions) {
        String includeArrayIndex;
        Assertions.notNull("unwindOptions", unwindOptions);
        BsonDocument options2 = new BsonDocument("path", new BsonString(fieldName2));
        Boolean preserveNullAndEmptyArrays = unwindOptions.isPreserveNullAndEmptyArrays();
        if (preserveNullAndEmptyArrays != null) {
            options2.append("preserveNullAndEmptyArrays", BsonBoolean.valueOf(preserveNullAndEmptyArrays));
        }
        if ((includeArrayIndex = unwindOptions.getIncludeArrayIndex()) != null) {
            options2.append("includeArrayIndex", new BsonString(includeArrayIndex));
        }
        return new BsonDocument("$unwind", options2);
    }

    public static Bson out(String collectionName) {
        return new BsonDocument("$out", new BsonString(collectionName));
    }

    public static <TExpression> Bson replaceRoot(TExpression value2) {
        return new ReplaceRootStage<TExpression>(value2);
    }

    public static Bson sample(int size2) {
        return new BsonDocument("$sample", new BsonDocument("size", new BsonInt32(size2)));
    }

    static void writeBucketOutput(CodecRegistry codecRegistry, BsonDocumentWriter writer2, @Nullable List<BsonField> output) {
        if (output != null) {
            writer2.writeName("output");
            writer2.writeStartDocument();
            for (BsonField field2 : output) {
                writer2.writeName(field2.getName());
                BuildersHelper.encodeValue(writer2, field2.getValue(), codecRegistry);
            }
            writer2.writeEndDocument();
        }
    }

    private Aggregates() {
    }

    private static class ReplaceRootStage<TExpression>
    implements Bson {
        private final TExpression value;

        ReplaceRootStage(TExpression value2) {
            this.value = value2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeName("$replaceRoot");
            writer2.writeStartDocument();
            writer2.writeName("newRoot");
            BuildersHelper.encodeValue(writer2, this.value, codecRegistry);
            writer2.writeEndDocument();
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Stage{name='$replaceRoot', value=" + this.value + '}';
        }
    }

    private static class AddFieldsStage
    implements Bson {
        private final List<Field<?>> fields;

        AddFieldsStage(List<Field<?>> fields) {
            this.fields = fields;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeName("$addFields");
            writer2.writeStartDocument();
            for (Field<?> field2 : this.fields) {
                writer2.writeName(field2.getName());
                BuildersHelper.encodeValue(writer2, field2.getValue(), codecRegistry);
            }
            writer2.writeEndDocument();
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Stage{name='$addFields', fields=" + this.fields + '}';
        }
    }

    private static class FacetStage
    implements Bson {
        private final List<Facet> facets;

        FacetStage(List<Facet> facets) {
            this.facets = facets;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeName("$facet");
            writer2.writeStartDocument();
            for (Facet facet : this.facets) {
                writer2.writeName(facet.getName());
                writer2.writeStartArray();
                for (Bson bson : facet.getPipeline()) {
                    BuildersHelper.encodeValue(writer2, bson, codecRegistry);
                }
                writer2.writeEndArray();
            }
            writer2.writeEndDocument();
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Stage{name='$facet', facets=" + this.facets + '}';
        }
    }

    private static class SortByCountStage<TExpression>
    implements Bson {
        private final TExpression filter;

        SortByCountStage(TExpression filter2) {
            this.filter = filter2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeName("$sortByCount");
            BuildersHelper.encodeValue(writer2, this.filter, codecRegistry);
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Stage{name='$sortByCount', id=" + this.filter + '}';
        }
    }

    private static class GroupStage<TExpression>
    implements Bson {
        private final TExpression id;
        private final List<BsonField> fieldAccumulators;

        GroupStage(TExpression id2, List<BsonField> fieldAccumulators) {
            this.id = id2;
            this.fieldAccumulators = fieldAccumulators;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeStartDocument("$group");
            writer2.writeName("_id");
            BuildersHelper.encodeValue(writer2, this.id, codecRegistry);
            for (BsonField fieldAccumulator : this.fieldAccumulators) {
                writer2.writeName(fieldAccumulator.getName());
                BuildersHelper.encodeValue(writer2, fieldAccumulator.getValue(), codecRegistry);
            }
            writer2.writeEndDocument();
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Stage{name='$group', id=" + this.id + ", fieldAccumulators=" + this.fieldAccumulators + '}';
        }
    }

    private static final class GraphLookupStage<TExpression>
    implements Bson {
        private final String from;
        private final TExpression startWith;
        private final String connectFromField;
        private final String connectToField;
        private final String as;
        private final GraphLookupOptions options;

        private GraphLookupStage(String from2, TExpression startWith, String connectFromField, String connectToField, String as2, GraphLookupOptions options2) {
            this.from = from2;
            this.startWith = startWith;
            this.connectFromField = connectFromField;
            this.connectToField = connectToField;
            this.as = as2;
            this.options = options2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            Bson restrictSearchWithMatch;
            String depthField;
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeStartDocument("$graphLookup");
            writer2.writeString("from", this.from);
            writer2.writeName("startWith");
            BuildersHelper.encodeValue(writer2, this.startWith, codecRegistry);
            writer2.writeString("connectFromField", this.connectFromField);
            writer2.writeString("connectToField", this.connectToField);
            writer2.writeString("as", this.as);
            Integer maxDepth2 = this.options.getMaxDepth();
            if (maxDepth2 != null) {
                writer2.writeInt32("maxDepth", maxDepth2);
            }
            if ((depthField = this.options.getDepthField()) != null) {
                writer2.writeString("depthField", depthField);
            }
            if ((restrictSearchWithMatch = this.options.getRestrictSearchWithMatch()) != null) {
                writer2.writeName("restrictSearchWithMatch");
                BuildersHelper.encodeValue(writer2, restrictSearchWithMatch, codecRegistry);
            }
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Stage{name='$graphLookup', as='" + this.as + '\'' + ", connectFromField='" + this.connectFromField + '\'' + ", connectToField='" + this.connectToField + '\'' + ", from='" + this.from + '\'' + ", options=" + this.options + ", startWith=" + this.startWith + '}';
        }
    }

    private static final class LookupStage<TExpression>
    implements Bson {
        private final String from;
        private final List<Variable<TExpression>> let;
        private final List<? extends Bson> pipeline;
        private final String as;

        private LookupStage(String from2, @Nullable List<Variable<TExpression>> let, List<? extends Bson> pipeline, String as2) {
            this.from = from2;
            this.let = let;
            this.pipeline = pipeline;
            this.as = as2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeStartDocument("$lookup");
            writer2.writeString("from", this.from);
            if (this.let != null) {
                writer2.writeStartDocument("let");
                for (Variable variable : this.let) {
                    writer2.writeName(variable.getName());
                    BuildersHelper.encodeValue(writer2, variable.getValue(), codecRegistry);
                }
                writer2.writeEndDocument();
            }
            writer2.writeName("pipeline");
            writer2.writeStartArray();
            for (Bson bson : this.pipeline) {
                BuildersHelper.encodeValue(writer2, bson, codecRegistry);
            }
            writer2.writeEndArray();
            writer2.writeString("as", this.as);
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Stage{name='$lookup', from='" + this.from + '\'' + ", let=" + this.let + ", pipeline=" + this.pipeline + ", as='" + this.as + '\'' + '}';
        }
    }

    private static final class BucketAutoStage<TExpression>
    implements Bson {
        private final TExpression groupBy;
        private final int buckets;
        private final BucketAutoOptions options;

        BucketAutoStage(TExpression groupBy2, int buckets, BucketAutoOptions options2) {
            Assertions.notNull("options", options2);
            this.groupBy = groupBy2;
            this.buckets = buckets;
            this.options = options2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeStartDocument("$bucketAuto");
            writer2.writeName("groupBy");
            BuildersHelper.encodeValue(writer2, this.groupBy, codecRegistry);
            writer2.writeInt32("buckets", this.buckets);
            Aggregates.writeBucketOutput(codecRegistry, writer2, this.options.getOutput());
            BucketGranularity granularity = this.options.getGranularity();
            if (granularity != null) {
                writer2.writeString("granularity", granularity.getValue());
            }
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Stage{name='$bucketAuto', buckets=" + this.buckets + ", groupBy=" + this.groupBy + ", options=" + this.options + '}';
        }
    }

    private static final class BucketStage<TExpression, TBoundary>
    implements Bson {
        private final TExpression groupBy;
        private final List<TBoundary> boundaries;
        private final BucketOptions options;

        BucketStage(TExpression groupBy2, List<TBoundary> boundaries, BucketOptions options2) {
            Assertions.notNull("options", options2);
            this.groupBy = groupBy2;
            this.boundaries = boundaries;
            this.options = options2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer2 = new BsonDocumentWriter(new BsonDocument());
            writer2.writeStartDocument();
            writer2.writeStartDocument("$bucket");
            writer2.writeName("groupBy");
            BuildersHelper.encodeValue(writer2, this.groupBy, codecRegistry);
            writer2.writeStartArray("boundaries");
            for (TBoundary boundary : this.boundaries) {
                BuildersHelper.encodeValue(writer2, boundary, codecRegistry);
            }
            writer2.writeEndArray();
            Object defaultBucket = this.options.getDefaultBucket();
            if (defaultBucket != null) {
                writer2.writeName("default");
                BuildersHelper.encodeValue(writer2, defaultBucket, codecRegistry);
            }
            Aggregates.writeBucketOutput(codecRegistry, writer2, this.options.getOutput());
            writer2.writeEndDocument();
            return writer2.getDocument();
        }

        public String toString() {
            return "Stage{name='$bucket', boundaries=" + this.boundaries + ", groupBy=" + this.groupBy + ", options=" + this.options + '}';
        }
    }

    private static class SimplePipelineStage
    implements Bson {
        private final String name;
        private final Bson value;

        SimplePipelineStage(String name, Bson value2) {
            this.name = name;
            this.value = value2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            return new BsonDocument(this.name, this.value.toBsonDocument(documentClass, codecRegistry));
        }

        public String toString() {
            return "Stage{name='" + this.name + '\'' + ", value=" + this.value + '}';
        }
    }
}

