/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ClientSessionOptions;
import com.mongodb.Function;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.internal.MongoClientDelegate;
import com.mongodb.client.internal.MongoDatabaseImpl;
import com.mongodb.client.internal.MongoIterables;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.changestream.ChangeStreamLevel;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.DefaultClusterFactory;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SocketStreamFactory;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

public final class MongoClientImpl
implements MongoClient {
    private final MongoClientSettings settings;
    private final MongoClientDelegate delegate;

    public MongoClientImpl(MongoClientSettings settings2, @Nullable MongoDriverInformation mongoDriverInformation) {
        this(MongoClientImpl.createCluster(settings2, mongoDriverInformation), settings2, null);
    }

    public MongoClientImpl(Cluster cluster, MongoClientSettings settings2, @Nullable OperationExecutor operationExecutor) {
        this.settings = Assertions.notNull("settings", settings2);
        this.delegate = new MongoClientDelegate(Assertions.notNull("cluster", cluster), Collections.singletonList(settings2.getCredential()), this, operationExecutor);
    }

    @Override
    public MongoDatabase getDatabase(String databaseName) {
        return new MongoDatabaseImpl(databaseName, this.settings.getCodecRegistry(), this.settings.getReadPreference(), this.settings.getWriteConcern(), this.settings.getRetryWrites(), this.settings.getReadConcern(), this.delegate.getOperationExecutor());
    }

    @Override
    public MongoIterable<String> listDatabaseNames() {
        return this.createListDatabaseNamesIterable(null);
    }

    @Override
    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabaseNamesIterable(clientSession);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases((Class<T>)Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> clazz2) {
        return this.createListDatabasesIterable(null, clazz2);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, (Class<T>)Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(ClientSession clientSession, Class<T> clazz2) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabasesIterable(clientSession, clazz2);
    }

    @Override
    public ClientSession startSession() {
        return this.startSession(ClientSessionOptions.builder().defaultTransactionOptions(TransactionOptions.builder().readConcern(this.settings.getReadConcern()).writeConcern(this.settings.getWriteConcern()).build()).build());
    }

    @Override
    public ClientSession startSession(ClientSessionOptions options2) {
        ClientSession clientSession = this.delegate.createClientSession(Assertions.notNull("options", options2), this.settings.getReadConcern(), this.settings.getWriteConcern(), this.settings.getReadPreference());
        if (clientSession == null) {
            throw new MongoClientException("Sessions are not supported by the MongoDB cluster to which this client is connected");
        }
        return clientSession;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public ChangeStreamIterable<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createChangeStreamIterable(null, pipeline, resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, resultClass);
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return MongoIterables.changeStreamOf(clientSession, "admin", this.settings.getCodecRegistry(), this.settings.getReadPreference(), this.settings.getReadConcern(), this.delegate.getOperationExecutor(), pipeline, resultClass, ChangeStreamLevel.CLIENT);
    }

    public Cluster getCluster() {
        return this.delegate.getCluster();
    }

    private static Cluster createCluster(MongoClientSettings settings2, @Nullable MongoDriverInformation mongoDriverInformation) {
        Assertions.notNull("settings", settings2);
        List<MongoCredential> credentialList = settings2.getCredential() != null ? Collections.singletonList(settings2.getCredential()) : Collections.emptyList();
        return new DefaultClusterFactory().createCluster(settings2.getClusterSettings(), settings2.getServerSettings(), settings2.getConnectionPoolSettings(), MongoClientImpl.getStreamFactory(settings2, false), MongoClientImpl.getStreamFactory(settings2, true), credentialList, EventListenerHelper.getCommandListener(settings2.getCommandListeners()), settings2.getApplicationName(), mongoDriverInformation, settings2.getCompressorList());
    }

    private static StreamFactory getStreamFactory(MongoClientSettings settings2, boolean isHeartbeat) {
        SocketSettings socketSettings;
        StreamFactoryFactory streamFactoryFactory = settings2.getStreamFactoryFactory();
        SocketSettings socketSettings2 = socketSettings = isHeartbeat ? settings2.getHeartbeatSocketSettings() : settings2.getSocketSettings();
        if (streamFactoryFactory == null) {
            return new SocketStreamFactory(socketSettings, settings2.getSslSettings());
        }
        return streamFactoryFactory.create(socketSettings, settings2.getSslSettings());
    }

    private <T> ListDatabasesIterable<T> createListDatabasesIterable(@Nullable ClientSession clientSession, Class<T> clazz2) {
        return MongoIterables.listDatabasesOf(clientSession, clazz2, this.settings.getCodecRegistry(), ReadPreference.primary(), this.delegate.getOperationExecutor());
    }

    private MongoIterable<String> createListDatabaseNamesIterable(@Nullable ClientSession clientSession) {
        return this.createListDatabasesIterable(clientSession, BsonDocument.class).nameOnly(true).map(new Function<BsonDocument, String>(){

            @Override
            public String apply(BsonDocument result2) {
                return result2.getString("name").getValue();
            }
        });
    }
}

