/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.gridfs.model;

import com.mongodb.MongoGridFSException;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Date;
import java.util.List;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.types.ObjectId;

public final class GridFSFile {
    private final BsonValue id;
    private final String filename;
    private final long length;
    private final int chunkSize;
    private final Date uploadDate;
    private final String md5;
    private final Document metadata;
    private final Document extraElements;

    @Deprecated
    public GridFSFile(BsonValue id2, String filename, long length2, int chunkSize, Date uploadDate, @Nullable String md5, Document metadata) {
        this(id2, filename, length2, chunkSize, uploadDate, md5, metadata, null);
    }

    @Deprecated
    public GridFSFile(BsonValue id2, String filename, long length2, int chunkSize, Date uploadDate, @Nullable String md5, @Nullable Document metadata, @Nullable Document extraElements) {
        this.id = Assertions.notNull("id", id2);
        this.filename = Assertions.notNull("filename", filename);
        this.length = Assertions.notNull("length", length2);
        this.chunkSize = Assertions.notNull("chunkSize", chunkSize);
        this.uploadDate = Assertions.notNull("uploadDate", uploadDate);
        this.md5 = md5;
        this.metadata = metadata != null && metadata.isEmpty() ? null : metadata;
        this.extraElements = extraElements;
    }

    public ObjectId getObjectId() {
        if (!this.id.isObjectId()) {
            throw new MongoGridFSException("Custom id type used for this GridFS file");
        }
        return this.id.asObjectId().getValue();
    }

    public BsonValue getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getLength() {
        return this.length;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public Date getUploadDate() {
        return this.uploadDate;
    }

    @Deprecated
    @Nullable
    public String getMD5() {
        return this.md5;
    }

    @Nullable
    public Document getMetadata() {
        return this.metadata;
    }

    @Deprecated
    @Nullable
    public Document getExtraElements() {
        return this.extraElements;
    }

    @Deprecated
    public String getContentType() {
        if (this.extraElements != null && this.extraElements.containsKey("contentType")) {
            return this.extraElements.getString("contentType");
        }
        throw new MongoGridFSException("No contentType data for this GridFS file");
    }

    @Deprecated
    public List<String> getAliases() {
        if (this.extraElements != null && this.extraElements.containsKey("aliases")) {
            return (List)this.extraElements.get("aliases");
        }
        throw new MongoGridFSException("No aliases data for this GridFS file");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridFSFile that2 = (GridFSFile)o;
        if (this.id != null ? !this.id.equals(that2.id) : that2.id != null) {
            return false;
        }
        if (!this.filename.equals(that2.filename)) {
            return false;
        }
        if (this.length != that2.length) {
            return false;
        }
        if (this.chunkSize != that2.chunkSize) {
            return false;
        }
        if (!this.uploadDate.equals(that2.uploadDate)) {
            return false;
        }
        if (this.md5 != null ? !this.md5.equals(that2.md5) : that2.md5 != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that2.metadata) : that2.metadata != null) {
            return false;
        }
        return !(this.extraElements != null ? !this.extraElements.equals(that2.extraElements) : that2.extraElements != null);
    }

    public int hashCode() {
        int result2 = this.id != null ? this.id.hashCode() : 0;
        result2 = 31 * result2 + this.filename.hashCode();
        result2 = 31 * result2 + (int)(this.length ^ this.length >>> 32);
        result2 = 31 * result2 + this.chunkSize;
        result2 = 31 * result2 + this.uploadDate.hashCode();
        result2 = 31 * result2 + (this.md5 != null ? this.md5.hashCode() : 0);
        result2 = 31 * result2 + (this.metadata != null ? this.metadata.hashCode() : 0);
        result2 = 31 * result2 + (this.extraElements != null ? this.extraElements.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "GridFSFile{id=" + this.id + ", filename='" + this.filename + '\'' + ", length=" + this.length + ", chunkSize=" + this.chunkSize + ", uploadDate=" + this.uploadDate + ", md5='" + this.md5 + '\'' + ", metadata=" + this.metadata + ", extraElements='" + this.extraElements + '\'' + '}';
    }
}

