/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.gridfs;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoGridFSException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSDownloadStreamImpl;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.GridFSFindIterableImpl;
import com.mongodb.client.gridfs.GridFSUploadStream;
import com.mongodb.client.gridfs.GridFSUploadStreamImpl;
import com.mongodb.client.gridfs.model.GridFSDownloadByNameOptions;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

final class GridFSBucketImpl
implements GridFSBucket {
    private static final int DEFAULT_CHUNKSIZE_BYTES = 261120;
    private final String bucketName;
    private final int chunkSizeBytes;
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<Document> chunksCollection;
    private final boolean disableMD5;
    private volatile boolean checkedIndexes;

    GridFSBucketImpl(MongoDatabase database) {
        this(database, "fs");
    }

    GridFSBucketImpl(MongoDatabase database, String bucketName) {
        this(Assertions.notNull("bucketName", bucketName), 261120, GridFSBucketImpl.getFilesCollection(Assertions.notNull("database", database), bucketName), GridFSBucketImpl.getChunksCollection(database, bucketName), false);
    }

    GridFSBucketImpl(String bucketName, int chunkSizeBytes, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, boolean disableMD5) {
        this.bucketName = Assertions.notNull("bucketName", bucketName);
        this.chunkSizeBytes = chunkSizeBytes;
        this.filesCollection = Assertions.notNull("filesCollection", filesCollection);
        this.chunksCollection = Assertions.notNull("chunksCollection", chunksCollection);
        this.disableMD5 = disableMD5;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public int getChunkSizeBytes() {
        return this.chunkSizeBytes;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.filesCollection.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.filesCollection.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.filesCollection.getReadConcern();
    }

    @Override
    public boolean getDisableMD5() {
        return this.disableMD5;
    }

    @Override
    public GridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new GridFSBucketImpl(this.bucketName, chunkSizeBytes, this.filesCollection, this.chunksCollection, this.disableMD5);
    }

    @Override
    public GridFSBucket withReadPreference(ReadPreference readPreference) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadPreference(readPreference), this.chunksCollection.withReadPreference(readPreference), this.disableMD5);
    }

    @Override
    public GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withWriteConcern(writeConcern), this.chunksCollection.withWriteConcern(writeConcern), this.disableMD5);
    }

    @Override
    public GridFSBucket withReadConcern(ReadConcern readConcern) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadConcern(readConcern), this.chunksCollection.withReadConcern(readConcern), this.disableMD5);
    }

    @Override
    public GridFSBucket withDisableMD5(boolean disableMD5) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection, this.chunksCollection, disableMD5);
    }

    @Override
    public GridFSUploadStream openUploadStream(String filename) {
        return this.openUploadStream(new BsonObjectId(), filename);
    }

    @Override
    public GridFSUploadStream openUploadStream(String filename, GridFSUploadOptions options2) {
        return this.openUploadStream(new BsonObjectId(), filename, options2);
    }

    @Override
    public GridFSUploadStream openUploadStream(BsonValue id2, String filename) {
        return this.openUploadStream(id2, filename, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(BsonValue id2, String filename, GridFSUploadOptions options2) {
        return this.createGridFSUploadStream(null, id2, filename, options2);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, String filename) {
        return this.openUploadStream(clientSession, new BsonObjectId(), filename);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, String filename, GridFSUploadOptions options2) {
        return this.openUploadStream(clientSession, new BsonObjectId(), filename, options2);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, ObjectId id2, String filename) {
        return this.openUploadStream(clientSession, new BsonObjectId(id2), filename);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, BsonValue id2, String filename) {
        return this.openUploadStream(clientSession, id2, filename, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, BsonValue id2, String filename, GridFSUploadOptions options2) {
        Assertions.notNull("clientSession", clientSession);
        return this.createGridFSUploadStream(clientSession, id2, filename, options2);
    }

    private GridFSUploadStream createGridFSUploadStream(@Nullable ClientSession clientSession, BsonValue id2, String filename, GridFSUploadOptions options2) {
        Assertions.notNull("options", options2);
        Integer chunkSizeBytes = options2.getChunkSizeBytes();
        int chunkSize = chunkSizeBytes == null ? this.chunkSizeBytes : chunkSizeBytes;
        this.checkCreateIndex(clientSession);
        return new GridFSUploadStreamImpl(clientSession, this.filesCollection, this.chunksCollection, id2, filename, chunkSize, this.disableMD5, options2.getMetadata());
    }

    @Override
    public ObjectId uploadFromStream(String filename, InputStream source2) {
        return this.uploadFromStream(filename, source2, new GridFSUploadOptions());
    }

    @Override
    public ObjectId uploadFromStream(String filename, InputStream source2, GridFSUploadOptions options2) {
        ObjectId id2 = new ObjectId();
        this.uploadFromStream(new BsonObjectId(id2), filename, source2, options2);
        return id2;
    }

    @Override
    public void uploadFromStream(BsonValue id2, String filename, InputStream source2) {
        this.uploadFromStream(id2, filename, source2, new GridFSUploadOptions());
    }

    @Override
    public void uploadFromStream(BsonValue id2, String filename, InputStream source2, GridFSUploadOptions options2) {
        this.executeUploadFromStream(null, id2, filename, source2, options2);
    }

    @Override
    public ObjectId uploadFromStream(ClientSession clientSession, String filename, InputStream source2) {
        return this.uploadFromStream(clientSession, filename, source2, new GridFSUploadOptions());
    }

    @Override
    public ObjectId uploadFromStream(ClientSession clientSession, String filename, InputStream source2, GridFSUploadOptions options2) {
        ObjectId id2 = new ObjectId();
        this.uploadFromStream(clientSession, new BsonObjectId(id2), filename, source2, options2);
        return id2;
    }

    @Override
    public void uploadFromStream(ClientSession clientSession, BsonValue id2, String filename, InputStream source2) {
        this.uploadFromStream(clientSession, id2, filename, source2, new GridFSUploadOptions());
    }

    @Override
    public void uploadFromStream(ClientSession clientSession, BsonValue id2, String filename, InputStream source2, GridFSUploadOptions options2) {
        Assertions.notNull("clientSession", clientSession);
        this.executeUploadFromStream(clientSession, id2, filename, source2, options2);
    }

    private void executeUploadFromStream(@Nullable ClientSession clientSession, BsonValue id2, String filename, InputStream source2, GridFSUploadOptions options2) {
        GridFSUploadStream uploadStream = this.createGridFSUploadStream(clientSession, id2, filename, options2);
        Integer chunkSizeBytes = options2.getChunkSizeBytes();
        int chunkSize = chunkSizeBytes == null ? this.chunkSizeBytes : chunkSizeBytes;
        byte[] buffer = new byte[chunkSize];
        try {
            int len2;
            while ((len2 = source2.read(buffer)) != -1) {
                uploadStream.write(buffer, 0, len2);
            }
            uploadStream.close();
        }
        catch (IOException e) {
            uploadStream.abort();
            throw new MongoGridFSException("IOException when reading from the InputStream", e);
        }
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ObjectId id2) {
        return this.openDownloadStream(new BsonObjectId(id2));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(BsonValue id2) {
        return this.createGridFSDownloadStream(null, this.getFileInfoById(null, id2));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(String filename) {
        return this.openDownloadStream(filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadStream openDownloadStream(String filename, GridFSDownloadOptions options2) {
        return this.createGridFSDownloadStream(null, this.getFileByName(null, filename, options2));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, ObjectId id2) {
        return this.openDownloadStream(clientSession, new BsonObjectId(id2));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, BsonValue id2) {
        Assertions.notNull("clientSession", clientSession);
        return this.createGridFSDownloadStream(clientSession, this.getFileInfoById(clientSession, id2));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, String filename) {
        return this.openDownloadStream(clientSession, filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, String filename, GridFSDownloadOptions options2) {
        Assertions.notNull("clientSession", clientSession);
        return this.createGridFSDownloadStream(clientSession, this.getFileByName(clientSession, filename, options2));
    }

    private GridFSDownloadStream createGridFSDownloadStream(@Nullable ClientSession clientSession, GridFSFile gridFSFile) {
        return new GridFSDownloadStreamImpl(clientSession, gridFSFile, this.chunksCollection);
    }

    @Override
    public void downloadToStream(ObjectId id2, OutputStream destination) {
        this.downloadToStream(new BsonObjectId(id2), destination);
    }

    @Override
    public void downloadToStream(BsonValue id2, OutputStream destination) {
        this.downloadToStream(this.openDownloadStream(id2), destination);
    }

    @Override
    public void downloadToStream(String filename, OutputStream destination) {
        this.downloadToStream(filename, destination, new GridFSDownloadOptions());
    }

    @Override
    public void downloadToStream(String filename, OutputStream destination, GridFSDownloadOptions options2) {
        this.downloadToStream(this.openDownloadStream(filename, options2), destination);
    }

    @Override
    public void downloadToStream(ClientSession clientSession, ObjectId id2, OutputStream destination) {
        this.downloadToStream(clientSession, new BsonObjectId(id2), destination);
    }

    @Override
    public void downloadToStream(ClientSession clientSession, BsonValue id2, OutputStream destination) {
        Assertions.notNull("clientSession", clientSession);
        this.downloadToStream(this.openDownloadStream(clientSession, id2), destination);
    }

    @Override
    public void downloadToStream(ClientSession clientSession, String filename, OutputStream destination) {
        this.downloadToStream(clientSession, filename, destination, new GridFSDownloadOptions());
    }

    @Override
    public void downloadToStream(ClientSession clientSession, String filename, OutputStream destination, GridFSDownloadOptions options2) {
        Assertions.notNull("clientSession", clientSession);
        this.downloadToStream(this.openDownloadStream(clientSession, filename, options2), destination);
    }

    @Override
    public GridFSFindIterable find() {
        return this.createGridFSFindIterable(null, null);
    }

    @Override
    public GridFSFindIterable find(Bson filter2) {
        Assertions.notNull("filter", filter2);
        return this.createGridFSFindIterable(null, filter2);
    }

    @Override
    public GridFSFindIterable find(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createGridFSFindIterable(clientSession, null);
    }

    @Override
    public GridFSFindIterable find(ClientSession clientSession, Bson filter2) {
        Assertions.notNull("clientSession", clientSession);
        Assertions.notNull("filter", filter2);
        return this.createGridFSFindIterable(clientSession, filter2);
    }

    private GridFSFindIterable createGridFSFindIterable(@Nullable ClientSession clientSession, @Nullable Bson filter2) {
        return new GridFSFindIterableImpl(this.createFindIterable(clientSession, filter2));
    }

    @Override
    public void delete(ObjectId id2) {
        this.delete(new BsonObjectId(id2));
    }

    @Override
    public void delete(BsonValue id2) {
        this.executeDelete(null, id2);
    }

    @Override
    public void delete(ClientSession clientSession, ObjectId id2) {
        this.delete(clientSession, new BsonObjectId(id2));
    }

    @Override
    public void delete(ClientSession clientSession, BsonValue id2) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDelete(clientSession, id2);
    }

    private void executeDelete(@Nullable ClientSession clientSession, BsonValue id2) {
        DeleteResult result2;
        if (clientSession != null) {
            result2 = this.filesCollection.deleteOne(clientSession, new BsonDocument("_id", id2));
            this.chunksCollection.deleteMany(clientSession, new BsonDocument("files_id", id2));
        } else {
            result2 = this.filesCollection.deleteOne(new BsonDocument("_id", id2));
            this.chunksCollection.deleteMany(new BsonDocument("files_id", id2));
        }
        if (result2.wasAcknowledged() && result2.getDeletedCount() == 0L) {
            throw new MongoGridFSException(String.format("No file found with the id: %s", id2));
        }
    }

    @Override
    public void rename(ObjectId id2, String newFilename) {
        this.rename(new BsonObjectId(id2), newFilename);
    }

    @Override
    public void rename(BsonValue id2, String newFilename) {
        this.executeRename(null, id2, newFilename);
    }

    @Override
    public void rename(ClientSession clientSession, ObjectId id2, String newFilename) {
        this.rename(clientSession, new BsonObjectId(id2), newFilename);
    }

    @Override
    public void rename(ClientSession clientSession, BsonValue id2, String newFilename) {
        Assertions.notNull("clientSession", clientSession);
        this.executeRename(clientSession, id2, newFilename);
    }

    private void executeRename(@Nullable ClientSession clientSession, BsonValue id2, String newFilename) {
        UpdateResult updateResult = clientSession != null ? this.filesCollection.updateOne(clientSession, (Bson)new BsonDocument("_id", id2), new BsonDocument("$set", new BsonDocument("filename", new BsonString(newFilename)))) : this.filesCollection.updateOne(new BsonDocument("_id", id2), new BsonDocument("$set", new BsonDocument("filename", new BsonString(newFilename))));
        if (updateResult.wasAcknowledged() && updateResult.getMatchedCount() == 0L) {
            throw new MongoGridFSException(String.format("No file found with the id: %s", id2));
        }
    }

    @Override
    public void drop() {
        this.filesCollection.drop();
        this.chunksCollection.drop();
    }

    @Override
    public void drop(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        this.filesCollection.drop(clientSession);
        this.chunksCollection.drop(clientSession);
    }

    @Override
    public GridFSDownloadStream openDownloadStreamByName(String filename) {
        return this.openDownloadStreamByName(filename, new GridFSDownloadByNameOptions());
    }

    @Override
    public GridFSDownloadStream openDownloadStreamByName(String filename, GridFSDownloadByNameOptions options2) {
        return this.openDownloadStream(filename, new GridFSDownloadOptions().revision(options2.getRevision()));
    }

    @Override
    public void downloadToStreamByName(String filename, OutputStream destination) {
        this.downloadToStreamByName(filename, destination, new GridFSDownloadByNameOptions());
    }

    @Override
    public void downloadToStreamByName(String filename, OutputStream destination, GridFSDownloadByNameOptions options2) {
        this.downloadToStream(filename, destination, new GridFSDownloadOptions().revision(options2.getRevision()));
    }

    private static MongoCollection<GridFSFile> getFilesCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".files", GridFSFile.class).withCodecRegistry(CodecRegistries.fromRegistries(database.getCodecRegistry(), MongoClientSettings.getDefaultCodecRegistry()));
    }

    private static MongoCollection<Document> getChunksCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".chunks").withCodecRegistry(MongoClientSettings.getDefaultCodecRegistry());
    }

    private void checkCreateIndex(@Nullable ClientSession clientSession) {
        if (!this.checkedIndexes) {
            if (this.collectionIsEmpty(clientSession, this.filesCollection.withDocumentClass(Document.class).withReadPreference(ReadPreference.primary()))) {
                Document filesIndex = new Document("filename", 1).append("uploadDate", 1);
                if (!this.hasIndex(clientSession, this.filesCollection.withReadPreference(ReadPreference.primary()), filesIndex)) {
                    this.createIndex(clientSession, this.filesCollection, filesIndex, new IndexOptions());
                }
                Document chunksIndex = new Document("files_id", 1).append("n", 1);
                if (!this.hasIndex(clientSession, this.chunksCollection.withReadPreference(ReadPreference.primary()), chunksIndex)) {
                    this.createIndex(clientSession, this.chunksCollection, chunksIndex, new IndexOptions().unique(true));
                }
            }
            this.checkedIndexes = true;
        }
    }

    private <T> boolean collectionIsEmpty(@Nullable ClientSession clientSession, MongoCollection<T> collection) {
        if (clientSession != null) {
            return collection.find(clientSession).projection(new Document("_id", 1)).first() == null;
        }
        return collection.find().projection(new Document("_id", 1)).first() == null;
    }

    private <T> boolean hasIndex(@Nullable ClientSession clientSession, MongoCollection<T> collection, Document index2) {
        boolean hasIndex = false;
        ListIndexesIterable<Document> listIndexesIterable = clientSession != null ? collection.listIndexes(clientSession) : collection.listIndexes();
        ArrayList indexes = listIndexesIterable.into(new ArrayList());
        for (Document indexDoc : indexes) {
            if (!((Document)((Object)indexDoc.get((Object)"key", Document.class))).equals(index2)) continue;
            hasIndex = true;
            break;
        }
        return hasIndex;
    }

    private <T> void createIndex(@Nullable ClientSession clientSession, MongoCollection<T> collection, Document index2, IndexOptions indexOptions) {
        if (clientSession != null) {
            collection.createIndex(clientSession, index2, indexOptions);
        } else {
            collection.createIndex(index2, indexOptions);
        }
    }

    private GridFSFile getFileByName(@Nullable ClientSession clientSession, String filename, GridFSDownloadOptions options2) {
        int sort2;
        int skip;
        int revision = options2.getRevision();
        if (revision >= 0) {
            skip = revision;
            sort2 = 1;
        } else {
            skip = -revision - 1;
            sort2 = -1;
        }
        GridFSFile fileInfo = (GridFSFile)this.createGridFSFindIterable(clientSession, new Document("filename", filename)).skip(skip).sort(new Document("uploadDate", sort2)).first();
        if (fileInfo == null) {
            throw new MongoGridFSException(String.format("No file found with the filename: %s and revision: %s", filename, revision));
        }
        return fileInfo;
    }

    private GridFSFile getFileInfoById(@Nullable ClientSession clientSession, BsonValue id2) {
        Assertions.notNull("id", id2);
        GridFSFile fileInfo = (GridFSFile)this.createFindIterable(clientSession, new Document("_id", id2)).first();
        if (fileInfo == null) {
            throw new MongoGridFSException(String.format("No file found with the id: %s", id2));
        }
        return fileInfo;
    }

    private FindIterable<GridFSFile> createFindIterable(@Nullable ClientSession clientSession, @Nullable Bson filter2) {
        FindIterable<GridFSFile> findIterable = clientSession != null ? this.filesCollection.find(clientSession) : this.filesCollection.find();
        if (filter2 != null) {
            findIterable = findIterable.filter(filter2);
        }
        return findIterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadToStream(GridFSDownloadStream downloadStream, OutputStream destination) {
        block16: {
            byte[] buffer = new byte[downloadStream.getGridFSFile().getChunkSize()];
            MongoGridFSException savedThrowable = null;
            try {
                int len2;
                while ((len2 = downloadStream.read(buffer)) != -1) {
                    destination.write(buffer, 0, len2);
                }
            }
            catch (IOException e) {
                savedThrowable = new MongoGridFSException("IOException when reading from the OutputStream", e);
            }
            catch (Exception e) {
                savedThrowable = new MongoGridFSException("Unexpected Exception when reading GridFS and writing to the Stream", e);
            }
            finally {
                try {
                    downloadStream.close();
                }
                catch (Exception e) {}
                if (savedThrowable == null) break block16;
                throw savedThrowable;
            }
        }
    }
}

