/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.bulk;

import com.mongodb.assertions.Assertions;
import org.bson.BsonDocument;

public class WriteConcernError {
    private final int code;
    private final String codeName;
    private final String message;
    private final BsonDocument details;

    public WriteConcernError(int code2, String codeName, String message, BsonDocument details) {
        this.code = code2;
        this.codeName = Assertions.notNull("codeName", codeName);
        this.message = Assertions.notNull("message", message);
        this.details = Assertions.notNull("details", details);
    }

    @Deprecated
    public WriteConcernError(int code2, String message, BsonDocument details) {
        this(code2, "", message, details);
    }

    public int getCode() {
        return this.code;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getMessage() {
        return this.message;
    }

    public BsonDocument getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteConcernError that2 = (WriteConcernError)o;
        if (this.code != that2.code) {
            return false;
        }
        if (!this.codeName.equals(that2.codeName)) {
            return false;
        }
        if (!this.details.equals(that2.details)) {
            return false;
        }
        return this.message.equals(that2.message);
    }

    public int hashCode() {
        int result2 = this.code;
        result2 = 31 * result2 + this.codeName.hashCode();
        result2 = 31 * result2 + this.message.hashCode();
        result2 = 31 * result2 + this.details.hashCode();
        return result2;
    }

    public String toString() {
        return "WriteConcernError{code=" + this.code + ", codeName='" + this.codeName + '\'' + ", message='" + this.message + '\'' + ", details=" + this.details + '}';
    }
}

