/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.bulk;

import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.WriteRequest;
import java.util.List;

public abstract class BulkWriteResult {
    public abstract boolean wasAcknowledged();

    public abstract int getInsertedCount();

    public abstract int getMatchedCount();

    public abstract int getDeletedCount();

    public abstract boolean isModifiedCountAvailable();

    public abstract int getModifiedCount();

    public abstract List<BulkWriteUpsert> getUpserts();

    public static BulkWriteResult acknowledged(WriteRequest.Type type, int count2, List<BulkWriteUpsert> upserts) {
        return BulkWriteResult.acknowledged(type, count2, 0, upserts);
    }

    public static BulkWriteResult acknowledged(WriteRequest.Type type, int count2, Integer modifiedCount2, List<BulkWriteUpsert> upserts) {
        return BulkWriteResult.acknowledged(type == WriteRequest.Type.INSERT ? count2 : 0, type == WriteRequest.Type.UPDATE || type == WriteRequest.Type.REPLACE ? count2 : 0, type == WriteRequest.Type.DELETE ? count2 : 0, modifiedCount2, upserts);
    }

    public static BulkWriteResult acknowledged(final int insertedCount, final int matchedCount, final int removedCount, final Integer modifiedCount2, final List<BulkWriteUpsert> upserts) {
        return new BulkWriteResult(){

            @Override
            public boolean wasAcknowledged() {
                return true;
            }

            @Override
            public int getInsertedCount() {
                return insertedCount;
            }

            @Override
            public int getMatchedCount() {
                return matchedCount;
            }

            @Override
            public int getDeletedCount() {
                return removedCount;
            }

            @Override
            public boolean isModifiedCountAvailable() {
                return modifiedCount2 != null;
            }

            @Override
            public int getModifiedCount() {
                if (modifiedCount2 == null) {
                    throw new UnsupportedOperationException("The modifiedCount is not available because at least one of the servers that was updated was not able to provide this information (the server is must be at least version 2.6");
                }
                return modifiedCount2;
            }

            @Override
            public List<BulkWriteUpsert> getUpserts() {
                return upserts;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                BulkWriteResult that2 = (BulkWriteResult)o;
                if (!that2.wasAcknowledged()) {
                    return false;
                }
                if (insertedCount != that2.getInsertedCount()) {
                    return false;
                }
                if (this.isModifiedCountAvailable() != that2.isModifiedCountAvailable()) {
                    return false;
                }
                if (modifiedCount2 != null && !modifiedCount2.equals(that2.getModifiedCount())) {
                    return false;
                }
                if (removedCount != that2.getDeletedCount()) {
                    return false;
                }
                if (matchedCount != that2.getMatchedCount()) {
                    return false;
                }
                return upserts.equals(that2.getUpserts());
            }

            public int hashCode() {
                int result2 = upserts.hashCode();
                result2 = 31 * result2 + insertedCount;
                result2 = 31 * result2 + matchedCount;
                result2 = 31 * result2 + removedCount;
                result2 = 31 * result2 + (modifiedCount2 != null ? modifiedCount2.hashCode() : 0);
                return result2;
            }

            public String toString() {
                return "AcknowledgedBulkWriteResult{insertedCount=" + insertedCount + ", matchedCount=" + matchedCount + ", removedCount=" + removedCount + ", modifiedCount=" + modifiedCount2 + ", upserts=" + upserts + '}';
            }
        };
    }

    public static BulkWriteResult unacknowledged() {
        return new BulkWriteResult(){

            @Override
            public boolean wasAcknowledged() {
                return false;
            }

            @Override
            public int getInsertedCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public int getMatchedCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public int getDeletedCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public boolean isModifiedCountAvailable() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public int getModifiedCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public List<BulkWriteUpsert> getUpserts() {
                throw this.getUnacknowledgedWriteException();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                BulkWriteResult that2 = (BulkWriteResult)o;
                return !that2.wasAcknowledged();
            }

            public int hashCode() {
                return 0;
            }

            public String toString() {
                return "UnacknowledgedBulkWriteResult{}";
            }

            private UnsupportedOperationException getUnacknowledgedWriteException() {
                return new UnsupportedOperationException("Cannot get information about an unacknowledged write");
            }
        };
    }
}

