/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MongoCompressor {
    public static final String LEVEL = "LEVEL";
    private final String name;
    private final Map<String, Object> properties;

    public static MongoCompressor createSnappyCompressor() {
        return new MongoCompressor("snappy");
    }

    public static MongoCompressor createZlibCompressor() {
        return new MongoCompressor("zlib");
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public <T> T getProperty(String key, T defaultValue2) {
        Assertions.notNull("key", key);
        Object value2 = this.properties.get(key.toLowerCase());
        return (T)(value2 == null && !this.properties.containsKey(key) ? defaultValue2 : value2);
    }

    public <T> T getPropertyNonNull(String key, T defaultValue2) {
        T value2 = this.getProperty(key, defaultValue2);
        if (value2 == null) {
            throw new IllegalArgumentException();
        }
        return value2;
    }

    public <T> MongoCompressor withProperty(String key, T value2) {
        return new MongoCompressor(this, key, value2);
    }

    private MongoCompressor(String name) {
        this.name = name;
        this.properties = Collections.emptyMap();
    }

    private <T> MongoCompressor(MongoCompressor from2, String propertyKey, T propertyValue) {
        Assertions.notNull("propertyKey", propertyKey);
        this.name = from2.name;
        this.properties = new HashMap<String, Object>(from2.properties);
        this.properties.put(propertyKey.toLowerCase(), propertyValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoCompressor that2 = (MongoCompressor)o;
        if (!this.name.equals(that2.name)) {
            return false;
        }
        return this.properties.equals(that2.properties);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + this.properties.hashCode();
        return result2;
    }

    public String toString() {
        return "MongoCompressor{name='" + this.name + '\'' + ", properties=" + this.properties + '}';
    }
}

