/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBDecoderFactory;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.MongoClient;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoInternalException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerMonitorListener;
import com.mongodb.lang.Nullable;
import com.mongodb.selector.ServerSelector;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.bson.codecs.configuration.CodecRegistry;

@Immutable
public class MongoClientOptions {
    private static final SocketFactory DEFAULT_SSL_SOCKET_FACTORY = SSLSocketFactory.getDefault();
    private static final SocketFactory DEFAULT_SOCKET_FACTORY = SocketFactory.getDefault();
    private final String description;
    private final String applicationName;
    private final List<MongoCompressor> compressorList;
    private final ReadPreference readPreference;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final ReadConcern readConcern;
    private final CodecRegistry codecRegistry;
    private final ServerSelector serverSelector;
    private final int minConnectionsPerHost;
    private final int maxConnectionsPerHost;
    private final int threadsAllowedToBlockForConnectionMultiplier;
    private final int serverSelectionTimeout;
    private final int maxWaitTime;
    private final int maxConnectionIdleTime;
    private final int maxConnectionLifeTime;
    private final int connectTimeout;
    private final int socketTimeout;
    private final boolean socketKeepAlive;
    private final boolean sslEnabled;
    private final boolean sslInvalidHostNameAllowed;
    private final SSLContext sslContext;
    private final boolean alwaysUseMBeans;
    private final int heartbeatFrequency;
    private final int minHeartbeatFrequency;
    private final int heartbeatConnectTimeout;
    private final int heartbeatSocketTimeout;
    private final int localThreshold;
    private final String requiredReplicaSetName;
    private final DBDecoderFactory dbDecoderFactory;
    private final DBEncoderFactory dbEncoderFactory;
    private final SocketFactory socketFactory;
    private final boolean cursorFinalizerEnabled;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final SocketSettings socketSettings;
    private final ServerSettings serverSettings;
    private final SocketSettings heartbeatSocketSettings;
    private final SslSettings sslSettings;
    private final List<ClusterListener> clusterListeners;
    private final List<CommandListener> commandListeners;

    private MongoClientOptions(Builder builder) {
        this.description = builder.description;
        this.applicationName = builder.applicationName;
        this.compressorList = builder.compressorList;
        this.minConnectionsPerHost = builder.minConnectionsPerHost;
        this.maxConnectionsPerHost = builder.maxConnectionsPerHost;
        this.threadsAllowedToBlockForConnectionMultiplier = builder.threadsAllowedToBlockForConnectionMultiplier;
        this.serverSelectionTimeout = builder.serverSelectionTimeout;
        this.maxWaitTime = builder.maxWaitTime;
        this.maxConnectionIdleTime = builder.maxConnectionIdleTime;
        this.maxConnectionLifeTime = builder.maxConnectionLifeTime;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
        this.socketKeepAlive = builder.socketKeepAlive;
        this.readPreference = builder.readPreference;
        this.writeConcern = builder.writeConcern;
        this.retryWrites = builder.retryWrites;
        this.readConcern = builder.readConcern;
        this.codecRegistry = builder.codecRegistry;
        this.serverSelector = builder.serverSelector;
        this.sslEnabled = builder.sslEnabled;
        this.sslInvalidHostNameAllowed = builder.sslInvalidHostNameAllowed;
        this.sslContext = builder.sslContext;
        this.alwaysUseMBeans = builder.alwaysUseMBeans;
        this.heartbeatFrequency = builder.heartbeatFrequency;
        this.minHeartbeatFrequency = builder.minHeartbeatFrequency;
        this.heartbeatConnectTimeout = builder.heartbeatConnectTimeout;
        this.heartbeatSocketTimeout = builder.heartbeatSocketTimeout;
        this.localThreshold = builder.localThreshold;
        this.requiredReplicaSetName = builder.requiredReplicaSetName;
        this.dbDecoderFactory = builder.dbDecoderFactory;
        this.dbEncoderFactory = builder.dbEncoderFactory;
        this.socketFactory = builder.socketFactory;
        this.cursorFinalizerEnabled = builder.cursorFinalizerEnabled;
        this.clusterListeners = Collections.unmodifiableList(builder.clusterListeners);
        this.commandListeners = Collections.unmodifiableList(builder.commandListeners);
        ConnectionPoolSettings.Builder connectionPoolSettingsBuilder = ConnectionPoolSettings.builder().minSize(this.getMinConnectionsPerHost()).maxSize(this.getConnectionsPerHost()).maxWaitQueueSize(this.getThreadsAllowedToBlockForConnectionMultiplier() * this.getConnectionsPerHost()).maxWaitTime(this.getMaxWaitTime(), TimeUnit.MILLISECONDS).maxConnectionIdleTime(this.getMaxConnectionIdleTime(), TimeUnit.MILLISECONDS).maxConnectionLifeTime(this.getMaxConnectionLifeTime(), TimeUnit.MILLISECONDS);
        for (Iterator connectionPoolListener : builder.connectionPoolListeners) {
            connectionPoolSettingsBuilder.addConnectionPoolListener((ConnectionPoolListener)((Object)connectionPoolListener));
        }
        this.connectionPoolSettings = connectionPoolSettingsBuilder.build();
        this.socketSettings = SocketSettings.builder().connectTimeout(this.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(this.getSocketTimeout(), TimeUnit.MILLISECONDS).keepAlive(this.isSocketKeepAlive()).build();
        this.heartbeatSocketSettings = SocketSettings.builder().connectTimeout(this.getHeartbeatConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(this.getHeartbeatSocketTimeout(), TimeUnit.MILLISECONDS).keepAlive(this.isSocketKeepAlive()).build();
        ServerSettings.Builder serverSettingsBuilder = ServerSettings.builder().heartbeatFrequency(this.getHeartbeatFrequency(), TimeUnit.MILLISECONDS).minHeartbeatFrequency(this.getMinHeartbeatFrequency(), TimeUnit.MILLISECONDS);
        for (ServerListener serverListener : builder.serverListeners) {
            serverSettingsBuilder.addServerListener(serverListener);
        }
        for (ServerMonitorListener serverMonitorListener : builder.serverMonitorListeners) {
            serverSettingsBuilder.addServerMonitorListener(serverMonitorListener);
        }
        this.serverSettings = serverSettingsBuilder.build();
        try {
            this.sslSettings = SslSettings.builder().enabled(this.sslEnabled).invalidHostNameAllowed(this.sslInvalidHostNameAllowed).context(this.sslContext).build();
        }
        catch (MongoInternalException e) {
            throw new MongoInternalException("By default, SSL connections are only supported on Java 7 or later.  If the application must run on Java 6, you must set the MongoClientOptions.sslInvalidHostNameAllowed property to true");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MongoClientOptions options2) {
        return new Builder(options2);
    }

    @Deprecated
    public String getDescription() {
        return this.description;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public List<MongoCompressor> getCompressorList() {
        return this.compressorList;
    }

    public int getConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public int getMinConnectionsPerHost() {
        return this.minConnectionsPerHost;
    }

    public int getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier;
    }

    public int getServerSelectionTimeout() {
        return this.serverSelectionTimeout;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    public int getMaxConnectionLifeTime() {
        return this.maxConnectionLifeTime;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Deprecated
    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    public int getMinHeartbeatFrequency() {
        return this.minHeartbeatFrequency;
    }

    public int getHeartbeatConnectTimeout() {
        return this.heartbeatConnectTimeout;
    }

    public int getHeartbeatSocketTimeout() {
        return this.heartbeatSocketTimeout;
    }

    public int getLocalThreshold() {
        return this.localThreshold;
    }

    @Nullable
    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public boolean isSslInvalidHostNameAllowed() {
        return this.sslInvalidHostNameAllowed;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean getRetryWrites() {
        return this.retryWrites;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public ServerSelector getServerSelector() {
        return this.serverSelector;
    }

    public List<ClusterListener> getClusterListeners() {
        return this.clusterListeners;
    }

    public List<CommandListener> getCommandListeners() {
        return this.commandListeners;
    }

    public List<ConnectionPoolListener> getConnectionPoolListeners() {
        return this.connectionPoolSettings.getConnectionPoolListeners();
    }

    public List<ServerListener> getServerListeners() {
        return this.serverSettings.getServerListeners();
    }

    public List<ServerMonitorListener> getServerMonitorListeners() {
        return this.serverSettings.getServerMonitorListeners();
    }

    public DBDecoderFactory getDbDecoderFactory() {
        return this.dbDecoderFactory;
    }

    public DBEncoderFactory getDbEncoderFactory() {
        return this.dbEncoderFactory;
    }

    @Deprecated
    public boolean isAlwaysUseMBeans() {
        return this.alwaysUseMBeans;
    }

    @Deprecated
    public SocketFactory getSocketFactory() {
        if (this.socketFactory != null) {
            return this.socketFactory;
        }
        if (this.getSslSettings().isEnabled()) {
            return this.sslContext == null ? DEFAULT_SSL_SOCKET_FACTORY : this.sslContext.getSocketFactory();
        }
        return DEFAULT_SOCKET_FACTORY;
    }

    public boolean isCursorFinalizerEnabled() {
        return this.cursorFinalizerEnabled;
    }

    ConnectionPoolSettings getConnectionPoolSettings() {
        return this.connectionPoolSettings;
    }

    SocketSettings getSocketSettings() {
        return this.socketSettings;
    }

    ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    SocketSettings getHeartbeatSocketSettings() {
        return this.heartbeatSocketSettings;
    }

    SslSettings getSslSettings() {
        return this.sslSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClientOptions that2 = (MongoClientOptions)o;
        if (this.localThreshold != that2.localThreshold) {
            return false;
        }
        if (this.alwaysUseMBeans != that2.alwaysUseMBeans) {
            return false;
        }
        if (this.connectTimeout != that2.connectTimeout) {
            return false;
        }
        if (this.cursorFinalizerEnabled != that2.cursorFinalizerEnabled) {
            return false;
        }
        if (this.minHeartbeatFrequency != that2.minHeartbeatFrequency) {
            return false;
        }
        if (this.heartbeatConnectTimeout != that2.heartbeatConnectTimeout) {
            return false;
        }
        if (this.heartbeatFrequency != that2.heartbeatFrequency) {
            return false;
        }
        if (this.heartbeatSocketTimeout != that2.heartbeatSocketTimeout) {
            return false;
        }
        if (this.maxConnectionIdleTime != that2.maxConnectionIdleTime) {
            return false;
        }
        if (this.maxConnectionLifeTime != that2.maxConnectionLifeTime) {
            return false;
        }
        if (this.maxConnectionsPerHost != that2.maxConnectionsPerHost) {
            return false;
        }
        if (this.serverSelectionTimeout != that2.serverSelectionTimeout) {
            return false;
        }
        if (this.maxWaitTime != that2.maxWaitTime) {
            return false;
        }
        if (this.minConnectionsPerHost != that2.minConnectionsPerHost) {
            return false;
        }
        if (this.socketKeepAlive != that2.socketKeepAlive) {
            return false;
        }
        if (this.socketTimeout != that2.socketTimeout) {
            return false;
        }
        if (this.sslEnabled != that2.sslEnabled) {
            return false;
        }
        if (this.sslInvalidHostNameAllowed != that2.sslInvalidHostNameAllowed) {
            return false;
        }
        if (this.sslContext != null ? !this.sslContext.equals(that2.sslContext) : that2.sslContext != null) {
            return false;
        }
        if (this.threadsAllowedToBlockForConnectionMultiplier != that2.threadsAllowedToBlockForConnectionMultiplier) {
            return false;
        }
        if (this.dbDecoderFactory != null ? !this.dbDecoderFactory.equals(that2.dbDecoderFactory) : that2.dbDecoderFactory != null) {
            return false;
        }
        if (this.dbEncoderFactory != null ? !this.dbEncoderFactory.equals(that2.dbEncoderFactory) : that2.dbEncoderFactory != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that2.description) : that2.description != null) {
            return false;
        }
        if (this.applicationName != null ? !this.applicationName.equals(that2.applicationName) : that2.applicationName != null) {
            return false;
        }
        if (!this.readPreference.equals(that2.readPreference)) {
            return false;
        }
        if (!this.writeConcern.equals(that2.writeConcern)) {
            return false;
        }
        if (this.retryWrites != that2.retryWrites) {
            return false;
        }
        if (!this.readConcern.equals(that2.readConcern)) {
            return false;
        }
        if (!this.codecRegistry.equals(that2.codecRegistry)) {
            return false;
        }
        if (this.serverSelector != null ? !this.serverSelector.equals(that2.serverSelector) : that2.serverSelector != null) {
            return false;
        }
        if (!this.clusterListeners.equals(that2.clusterListeners)) {
            return false;
        }
        if (!this.commandListeners.equals(that2.commandListeners)) {
            return false;
        }
        if (this.requiredReplicaSetName != null ? !this.requiredReplicaSetName.equals(that2.requiredReplicaSetName) : that2.requiredReplicaSetName != null) {
            return false;
        }
        if (this.socketFactory != null ? !this.socketFactory.equals(that2.socketFactory) : that2.socketFactory != null) {
            return false;
        }
        return this.compressorList.equals(that2.compressorList);
    }

    public int hashCode() {
        int result2 = this.description != null ? this.description.hashCode() : 0;
        result2 = 31 * result2 + (this.applicationName != null ? this.applicationName.hashCode() : 0);
        result2 = 31 * result2 + this.readPreference.hashCode();
        result2 = 31 * result2 + this.writeConcern.hashCode();
        result2 = 31 * result2 + (this.retryWrites ? 1 : 0);
        result2 = 31 * result2 + (this.readConcern != null ? this.readConcern.hashCode() : 0);
        result2 = 31 * result2 + this.codecRegistry.hashCode();
        result2 = 31 * result2 + (this.serverSelector != null ? this.serverSelector.hashCode() : 0);
        result2 = 31 * result2 + this.clusterListeners.hashCode();
        result2 = 31 * result2 + this.commandListeners.hashCode();
        result2 = 31 * result2 + this.minConnectionsPerHost;
        result2 = 31 * result2 + this.maxConnectionsPerHost;
        result2 = 31 * result2 + this.threadsAllowedToBlockForConnectionMultiplier;
        result2 = 31 * result2 + this.serverSelectionTimeout;
        result2 = 31 * result2 + this.maxWaitTime;
        result2 = 31 * result2 + this.maxConnectionIdleTime;
        result2 = 31 * result2 + this.maxConnectionLifeTime;
        result2 = 31 * result2 + this.connectTimeout;
        result2 = 31 * result2 + this.socketTimeout;
        result2 = 31 * result2 + (this.socketKeepAlive ? 1 : 0);
        result2 = 31 * result2 + (this.sslEnabled ? 1 : 0);
        result2 = 31 * result2 + (this.sslInvalidHostNameAllowed ? 1 : 0);
        result2 = 31 * result2 + (this.sslContext != null ? this.sslContext.hashCode() : 0);
        result2 = 31 * result2 + (this.alwaysUseMBeans ? 1 : 0);
        result2 = 31 * result2 + this.heartbeatFrequency;
        result2 = 31 * result2 + this.minHeartbeatFrequency;
        result2 = 31 * result2 + this.heartbeatConnectTimeout;
        result2 = 31 * result2 + this.heartbeatSocketTimeout;
        result2 = 31 * result2 + this.localThreshold;
        result2 = 31 * result2 + (this.requiredReplicaSetName != null ? this.requiredReplicaSetName.hashCode() : 0);
        result2 = 31 * result2 + (this.dbDecoderFactory != null ? this.dbDecoderFactory.hashCode() : 0);
        result2 = 31 * result2 + (this.dbEncoderFactory != null ? this.dbEncoderFactory.hashCode() : 0);
        result2 = 31 * result2 + (this.cursorFinalizerEnabled ? 1 : 0);
        result2 = 31 * result2 + (this.socketFactory != null ? this.socketFactory.hashCode() : 0);
        result2 = 31 * result2 + this.compressorList.hashCode();
        return result2;
    }

    public String toString() {
        return "MongoClientOptions{description='" + this.description + '\'' + ", applicationName='" + this.applicationName + '\'' + ", compressors='" + this.compressorList + '\'' + ", readPreference=" + this.readPreference + ", writeConcern=" + this.writeConcern + ", retryWrites=" + this.retryWrites + ", readConcern=" + this.readConcern + ", codecRegistry=" + this.codecRegistry + ", serverSelector=" + this.serverSelector + ", clusterListeners=" + this.clusterListeners + ", commandListeners=" + this.commandListeners + ", minConnectionsPerHost=" + this.minConnectionsPerHost + ", maxConnectionsPerHost=" + this.maxConnectionsPerHost + ", threadsAllowedToBlockForConnectionMultiplier=" + this.threadsAllowedToBlockForConnectionMultiplier + ", serverSelectionTimeout=" + this.serverSelectionTimeout + ", maxWaitTime=" + this.maxWaitTime + ", maxConnectionIdleTime=" + this.maxConnectionIdleTime + ", maxConnectionLifeTime=" + this.maxConnectionLifeTime + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + ", socketKeepAlive=" + this.socketKeepAlive + ", sslEnabled=" + this.sslEnabled + ", sslInvalidHostNamesAllowed=" + this.sslInvalidHostNameAllowed + ", sslContext=" + this.sslContext + ", alwaysUseMBeans=" + this.alwaysUseMBeans + ", heartbeatFrequency=" + this.heartbeatFrequency + ", minHeartbeatFrequency=" + this.minHeartbeatFrequency + ", heartbeatConnectTimeout=" + this.heartbeatConnectTimeout + ", heartbeatSocketTimeout=" + this.heartbeatSocketTimeout + ", localThreshold=" + this.localThreshold + ", requiredReplicaSetName='" + this.requiredReplicaSetName + '\'' + ", dbDecoderFactory=" + this.dbDecoderFactory + ", dbEncoderFactory=" + this.dbEncoderFactory + ", socketFactory=" + this.socketFactory + ", cursorFinalizerEnabled=" + this.cursorFinalizerEnabled + ", connectionPoolSettings=" + this.connectionPoolSettings + ", socketSettings=" + this.socketSettings + ", serverSettings=" + this.serverSettings + ", heartbeatSocketSettings=" + this.heartbeatSocketSettings + '}';
    }

    @NotThreadSafe
    public static class Builder {
        private final List<ClusterListener> clusterListeners = new ArrayList<ClusterListener>();
        private final List<CommandListener> commandListeners = new ArrayList<CommandListener>();
        private final List<ConnectionPoolListener> connectionPoolListeners = new ArrayList<ConnectionPoolListener>();
        private final List<ServerListener> serverListeners = new ArrayList<ServerListener>();
        private final List<ServerMonitorListener> serverMonitorListeners = new ArrayList<ServerMonitorListener>();
        private String description;
        private String applicationName;
        private List<MongoCompressor> compressorList = Collections.emptyList();
        private ReadPreference readPreference = ReadPreference.primary();
        private WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;
        private boolean retryWrites = false;
        private ReadConcern readConcern = ReadConcern.DEFAULT;
        private CodecRegistry codecRegistry = MongoClient.getDefaultCodecRegistry();
        private ServerSelector serverSelector;
        private int minConnectionsPerHost;
        private int maxConnectionsPerHost = 100;
        private int threadsAllowedToBlockForConnectionMultiplier = 5;
        private int serverSelectionTimeout = 30000;
        private int maxWaitTime = 120000;
        private int maxConnectionIdleTime;
        private int maxConnectionLifeTime;
        private int connectTimeout = 10000;
        private int socketTimeout = 0;
        private boolean socketKeepAlive = true;
        private boolean sslEnabled = false;
        private boolean sslInvalidHostNameAllowed = false;
        private SSLContext sslContext;
        private boolean alwaysUseMBeans = false;
        private int heartbeatFrequency = 10000;
        private int minHeartbeatFrequency = 500;
        private int heartbeatConnectTimeout = 20000;
        private int heartbeatSocketTimeout = 20000;
        private int localThreshold = 15;
        private String requiredReplicaSetName;
        private DBDecoderFactory dbDecoderFactory = DefaultDBDecoder.FACTORY;
        private DBEncoderFactory dbEncoderFactory = DefaultDBEncoder.FACTORY;
        private SocketFactory socketFactory;
        private boolean cursorFinalizerEnabled = true;

        public Builder() {
            this.heartbeatFrequency(Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalMS", "10000")));
            this.minHeartbeatFrequency(Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalNoMasterMS", "500")));
            this.heartbeatConnectTimeout(Integer.parseInt(System.getProperty("com.mongodb.updaterConnectTimeoutMS", "20000")));
            this.heartbeatSocketTimeout(Integer.parseInt(System.getProperty("com.mongodb.updaterSocketTimeoutMS", "20000")));
            this.localThreshold(Integer.parseInt(System.getProperty("com.mongodb.slaveAcceptableLatencyMS", "15")));
        }

        public Builder(MongoClientOptions options2) {
            this.description = options2.getDescription();
            this.applicationName = options2.getApplicationName();
            this.compressorList = options2.getCompressorList();
            this.minConnectionsPerHost = options2.getMinConnectionsPerHost();
            this.maxConnectionsPerHost = options2.getConnectionsPerHost();
            this.threadsAllowedToBlockForConnectionMultiplier = options2.getThreadsAllowedToBlockForConnectionMultiplier();
            this.serverSelectionTimeout = options2.getServerSelectionTimeout();
            this.maxWaitTime = options2.getMaxWaitTime();
            this.maxConnectionIdleTime = options2.getMaxConnectionIdleTime();
            this.maxConnectionLifeTime = options2.getMaxConnectionLifeTime();
            this.connectTimeout = options2.getConnectTimeout();
            this.socketTimeout = options2.getSocketTimeout();
            this.socketKeepAlive = options2.isSocketKeepAlive();
            this.readPreference = options2.getReadPreference();
            this.writeConcern = options2.getWriteConcern();
            this.retryWrites = options2.getRetryWrites();
            this.readConcern = options2.getReadConcern();
            this.codecRegistry = options2.getCodecRegistry();
            this.serverSelector = options2.getServerSelector();
            this.sslEnabled = options2.isSslEnabled();
            this.sslInvalidHostNameAllowed = options2.isSslInvalidHostNameAllowed();
            this.sslContext = options2.getSslContext();
            this.alwaysUseMBeans = options2.isAlwaysUseMBeans();
            this.heartbeatFrequency = options2.getHeartbeatFrequency();
            this.minHeartbeatFrequency = options2.getMinHeartbeatFrequency();
            this.heartbeatConnectTimeout = options2.getHeartbeatConnectTimeout();
            this.heartbeatSocketTimeout = options2.getHeartbeatSocketTimeout();
            this.localThreshold = options2.getLocalThreshold();
            this.requiredReplicaSetName = options2.getRequiredReplicaSetName();
            this.dbDecoderFactory = options2.getDbDecoderFactory();
            this.dbEncoderFactory = options2.getDbEncoderFactory();
            this.socketFactory = options2.socketFactory;
            this.cursorFinalizerEnabled = options2.isCursorFinalizerEnabled();
            this.clusterListeners.addAll(options2.getClusterListeners());
            this.commandListeners.addAll(options2.getCommandListeners());
            this.connectionPoolListeners.addAll(options2.getConnectionPoolListeners());
            this.serverListeners.addAll(options2.getServerListeners());
            this.serverMonitorListeners.addAll(options2.getServerMonitorListeners());
        }

        @Deprecated
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder applicationName(String applicationName) {
            if (applicationName != null) {
                Assertions.isTrueArgument("applicationName UTF-8 encoding length <= 128", applicationName.getBytes(Charset.forName("UTF-8")).length <= 128);
            }
            this.applicationName = applicationName;
            return this;
        }

        public Builder compressorList(List<MongoCompressor> compressorList) {
            Assertions.notNull("compressorList", compressorList);
            this.compressorList = Collections.unmodifiableList(new ArrayList<MongoCompressor>(compressorList));
            return this;
        }

        public Builder minConnectionsPerHost(int minConnectionsPerHost) {
            Assertions.isTrueArgument("minConnectionsPerHost must be >= 0", minConnectionsPerHost >= 0);
            this.minConnectionsPerHost = minConnectionsPerHost;
            return this;
        }

        public Builder connectionsPerHost(int connectionsPerHost) {
            Assertions.isTrueArgument("connectionPerHost must be > 0", connectionsPerHost > 0);
            this.maxConnectionsPerHost = connectionsPerHost;
            return this;
        }

        public Builder threadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
            Assertions.isTrueArgument("threadsAllowedToBlockForConnectionMultiplier must be > 0", threadsAllowedToBlockForConnectionMultiplier > 0);
            this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
            return this;
        }

        public Builder serverSelectionTimeout(int serverSelectionTimeout) {
            this.serverSelectionTimeout = serverSelectionTimeout;
            return this;
        }

        public Builder maxWaitTime(int maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
            return this;
        }

        public Builder maxConnectionIdleTime(int maxConnectionIdleTime) {
            this.maxConnectionIdleTime = maxConnectionIdleTime;
            return this;
        }

        public Builder maxConnectionLifeTime(int maxConnectionLifeTime) {
            this.maxConnectionLifeTime = maxConnectionLifeTime;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            Assertions.isTrueArgument("connectTimeout must be >= 0", connectTimeout >= 0);
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        @Deprecated
        public Builder socketKeepAlive(boolean socketKeepAlive) {
            this.socketKeepAlive = socketKeepAlive;
            return this;
        }

        public Builder sslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public Builder sslInvalidHostNameAllowed(boolean sslInvalidHostNameAllowed) {
            this.sslInvalidHostNameAllowed = sslInvalidHostNameAllowed;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder readPreference(ReadPreference readPreference) {
            this.readPreference = Assertions.notNull("readPreference", readPreference);
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
            return this;
        }

        public Builder retryWrites(boolean retryWrites) {
            this.retryWrites = retryWrites;
            return this;
        }

        public Builder readConcern(ReadConcern readConcern) {
            this.readConcern = Assertions.notNull("readConcern", readConcern);
            return this;
        }

        public Builder codecRegistry(CodecRegistry codecRegistry) {
            this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
            return this;
        }

        public Builder serverSelector(ServerSelector serverSelector) {
            this.serverSelector = serverSelector;
            return this;
        }

        public Builder addCommandListener(CommandListener commandListener) {
            this.commandListeners.add(Assertions.notNull("commandListener", commandListener));
            return this;
        }

        public Builder addConnectionPoolListener(ConnectionPoolListener connectionPoolListener) {
            this.connectionPoolListeners.add(Assertions.notNull("connectionPoolListener", connectionPoolListener));
            return this;
        }

        public Builder addClusterListener(ClusterListener clusterListener) {
            this.clusterListeners.add(Assertions.notNull("clusterListener", clusterListener));
            return this;
        }

        public Builder addServerListener(ServerListener serverListener) {
            this.serverListeners.add(Assertions.notNull("serverListener", serverListener));
            return this;
        }

        public Builder addServerMonitorListener(ServerMonitorListener serverMonitorListener) {
            this.serverMonitorListeners.add(Assertions.notNull("serverMonitorListener", serverMonitorListener));
            return this;
        }

        @Deprecated
        public Builder socketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder cursorFinalizerEnabled(boolean cursorFinalizerEnabled) {
            this.cursorFinalizerEnabled = cursorFinalizerEnabled;
            return this;
        }

        @Deprecated
        public Builder alwaysUseMBeans(boolean alwaysUseMBeans) {
            this.alwaysUseMBeans = alwaysUseMBeans;
            return this;
        }

        public Builder dbDecoderFactory(DBDecoderFactory dbDecoderFactory) {
            if (dbDecoderFactory == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.dbDecoderFactory = dbDecoderFactory;
            return this;
        }

        public Builder dbEncoderFactory(DBEncoderFactory dbEncoderFactory) {
            if (dbEncoderFactory == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.dbEncoderFactory = dbEncoderFactory;
            return this;
        }

        public Builder heartbeatFrequency(int heartbeatFrequency) {
            Assertions.isTrueArgument("heartbeatFrequency must be > 0", heartbeatFrequency > 0);
            this.heartbeatFrequency = heartbeatFrequency;
            return this;
        }

        public Builder minHeartbeatFrequency(int minHeartbeatFrequency) {
            Assertions.isTrueArgument("minHeartbeatFrequency must be > 0", minHeartbeatFrequency > 0);
            this.minHeartbeatFrequency = minHeartbeatFrequency;
            return this;
        }

        public Builder heartbeatConnectTimeout(int connectTimeout) {
            this.heartbeatConnectTimeout = connectTimeout;
            return this;
        }

        public Builder heartbeatSocketTimeout(int socketTimeout) {
            this.heartbeatSocketTimeout = socketTimeout;
            return this;
        }

        public Builder localThreshold(int localThreshold) {
            Assertions.isTrueArgument("localThreshold must be >= 0", localThreshold >= 0);
            this.localThreshold = localThreshold;
            return this;
        }

        public Builder requiredReplicaSetName(String requiredReplicaSetName) {
            this.requiredReplicaSetName = requiredReplicaSetName;
            return this;
        }

        @Deprecated
        public Builder legacyDefaults() {
            this.connectionsPerHost(10).writeConcern(WriteConcern.UNACKNOWLEDGED);
            return this;
        }

        public MongoClientOptions build() {
            return new MongoClientOptions(this);
        }
    }
}

