/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBEncoder;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DBRef;
import org.bson.BSONObject;
import org.bson.BasicBSONEncoder;
import org.bson.io.OutputBuffer;

public class DefaultDBEncoder
extends BasicBSONEncoder
implements DBEncoder {
    public static final DBEncoderFactory FACTORY = new DBEncoderFactory(){

        @Override
        public DBEncoder create() {
            return new DefaultDBEncoder();
        }
    };

    @Override
    public int writeObject(OutputBuffer outputBuffer, BSONObject document2) {
        this.set(outputBuffer);
        int x = this.putObject(document2);
        this.done();
        return x;
    }

    @Override
    protected boolean putSpecial(String name, Object value2) {
        if (value2 instanceof DBRef) {
            this.putDBRef(name, (DBRef)value2);
            return true;
        }
        return false;
    }

    protected void putDBRef(String name, DBRef ref2) {
        BasicDBObject dbRefDocument = new BasicDBObject("$ref", ref2.getCollectionName()).append("$id", ref2.getId());
        if (ref2.getDatabaseName() != null) {
            dbRefDocument.put("$db", ref2.getDatabaseName());
        }
        this.putObject(name, dbRefDocument);
    }

    public String toString() {
        return String.format("DBEncoder{class=%s}", this.getClass().getName());
    }
}

