/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.DBCallback;
import com.mongodb.DBCallbackFactory;
import com.mongodb.DBCollection;
import com.mongodb.DBCollectionObjectFactory;
import com.mongodb.DBObjectFactory;
import com.mongodb.DBRef;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.types.BasicBSONList;
import org.bson.types.ObjectId;

public class DefaultDBCallback
extends BasicBSONCallback
implements DBCallback {
    private final DBObjectFactory objectFactory;
    public static final DBCallbackFactory FACTORY = new DBCallbackFactory(){

        @Override
        public DBCallback create(DBCollection collection) {
            return new DefaultDBCallback(collection);
        }
    };

    public DefaultDBCallback(DBCollection collection) {
        this.objectFactory = collection != null ? collection.getObjectFactory() : new DBCollectionObjectFactory();
    }

    @Override
    public BSONObject create() {
        return this.objectFactory.getInstance();
    }

    @Override
    public BSONObject create(boolean array2, List<String> path2) {
        return array2 ? new BasicDBList() : this.objectFactory.getInstance(path2 != null ? path2 : Collections.emptyList());
    }

    @Override
    public void gotDBRef(String name, String namespace, ObjectId id2) {
        this._put(name, new DBRef(namespace, id2));
    }

    @Override
    public Object objectDone() {
        Iterator<String> iterator2;
        String name = this.curName();
        BSONObject document2 = (BSONObject)super.objectDone();
        if (!(document2 instanceof BasicBSONList) && (iterator2 = document2.keySet().iterator()).hasNext() && iterator2.next().equals("$ref") && iterator2.hasNext() && iterator2.next().equals("$id")) {
            this._put(name, new DBRef((String)document2.get("$db"), (String)document2.get("$ref"), document2.get("$id")));
        }
        return document2;
    }
}

