/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBRef;
import com.mongodb.assertions.Assertions;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class DBRefCodec
implements Codec<DBRef> {
    private final CodecRegistry registry;

    public DBRefCodec(CodecRegistry registry) {
        this.registry = Assertions.notNull("registry", registry);
    }

    @Override
    public void encode(BsonWriter writer2, DBRef value2, EncoderContext encoderContext) {
        writer2.writeStartDocument();
        writer2.writeString("$ref", value2.getCollectionName());
        writer2.writeName("$id");
        Codec<?> codec = this.registry.get(value2.getId().getClass());
        codec.encode(writer2, value2.getId(), encoderContext);
        if (value2.getDatabaseName() != null) {
            writer2.writeString("$db", value2.getDatabaseName());
        }
        writer2.writeEndDocument();
    }

    @Override
    public Class<DBRef> getEncoderClass() {
        return DBRef.class;
    }

    @Override
    public DBRef decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("DBRefCodec does not support decoding");
    }
}

