/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObjectFactory;
import com.mongodb.DBObject;
import com.mongodb.DBObjectCodecProvider;
import com.mongodb.DBObjectFactory;
import com.mongodb.DBRef;
import com.mongodb.assertions.Assertions;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonDbPointer;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IdGenerator;
import org.bson.codecs.ObjectIdGenerator;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.CodeWScope;
import org.bson.types.Symbol;

public class DBObjectCodec
implements CollectibleCodec<DBObject> {
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP = DBObjectCodec.createDefaultBsonTypeClassMap();
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DBObjectCodecProvider()));
    private static final String ID_FIELD_NAME = "_id";
    private final CodecRegistry codecRegistry;
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final DBObjectFactory objectFactory;
    private final IdGenerator idGenerator = new ObjectIdGenerator();

    static BsonTypeClassMap createDefaultBsonTypeClassMap() {
        HashMap replacements = new HashMap();
        replacements.put(BsonType.REGULAR_EXPRESSION, Pattern.class);
        replacements.put(BsonType.SYMBOL, String.class);
        replacements.put(BsonType.TIMESTAMP, BSONTimestamp.class);
        replacements.put(BsonType.JAVASCRIPT_WITH_SCOPE, null);
        replacements.put(BsonType.DOCUMENT, null);
        return new BsonTypeClassMap(replacements);
    }

    static BsonTypeClassMap getDefaultBsonTypeClassMap() {
        return DEFAULT_BSON_TYPE_CLASS_MAP;
    }

    static CodecRegistry getDefaultRegistry() {
        return DEFAULT_REGISTRY;
    }

    public DBObjectCodec() {
        this(DEFAULT_REGISTRY);
    }

    public DBObjectCodec(CodecRegistry codecRegistry) {
        this(codecRegistry, DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public DBObjectCodec(CodecRegistry codecRegistry, BsonTypeClassMap bsonTypeClassMap) {
        this(codecRegistry, bsonTypeClassMap, new BasicDBObjectFactory());
    }

    public DBObjectCodec(CodecRegistry codecRegistry, BsonTypeClassMap bsonTypeClassMap, DBObjectFactory objectFactory) {
        this.objectFactory = Assertions.notNull("objectFactory", objectFactory);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.bsonTypeCodecMap = new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), codecRegistry);
    }

    @Override
    public void encode(BsonWriter writer2, DBObject document2, EncoderContext encoderContext) {
        writer2.writeStartDocument();
        this.beforeFields(writer2, encoderContext, document2);
        for (String key : document2.keySet()) {
            if (this.skipField(encoderContext, key)) continue;
            writer2.writeName(key);
            this.writeValue(writer2, encoderContext, document2.get(key));
        }
        writer2.writeEndDocument();
    }

    @Override
    public DBObject decode(BsonReader reader, DecoderContext decoderContext) {
        ArrayList<String> path2 = new ArrayList<String>(10);
        return this.readDocument(reader, decoderContext, path2);
    }

    @Override
    public Class<DBObject> getEncoderClass() {
        return DBObject.class;
    }

    @Override
    public boolean documentHasId(DBObject document2) {
        return document2.containsField(ID_FIELD_NAME);
    }

    @Override
    public BsonValue getDocumentId(DBObject document2) {
        if (!this.documentHasId(document2)) {
            throw new IllegalStateException("The document does not contain an _id");
        }
        Object id2 = document2.get(ID_FIELD_NAME);
        if (id2 instanceof BsonValue) {
            return (BsonValue)id2;
        }
        BsonDocument idHoldingDocument = new BsonDocument();
        BsonDocumentWriter writer2 = new BsonDocumentWriter(idHoldingDocument);
        writer2.writeStartDocument();
        writer2.writeName(ID_FIELD_NAME);
        this.writeValue(writer2, EncoderContext.builder().build(), id2);
        writer2.writeEndDocument();
        return idHoldingDocument.get(ID_FIELD_NAME);
    }

    @Override
    public DBObject generateIdIfAbsentFromDocument(DBObject document2) {
        if (!this.documentHasId(document2)) {
            document2.put(ID_FIELD_NAME, this.idGenerator.generate());
        }
        return document2;
    }

    private void beforeFields(BsonWriter bsonWriter, EncoderContext encoderContext, DBObject document2) {
        if (encoderContext.isEncodingCollectibleDocument() && document2.containsField(ID_FIELD_NAME)) {
            bsonWriter.writeName(ID_FIELD_NAME);
            this.writeValue(bsonWriter, null, document2.get(ID_FIELD_NAME));
        }
    }

    private boolean skipField(EncoderContext encoderContext, String key) {
        return encoderContext.isEncodingCollectibleDocument() && key.equals(ID_FIELD_NAME);
    }

    private void writeValue(BsonWriter bsonWriter, EncoderContext encoderContext, Object initialValue) {
        Object value2 = BSON.applyEncodingHooks(initialValue);
        if (value2 == null) {
            bsonWriter.writeNull();
        } else if (value2 instanceof DBRef) {
            this.encodeDBRef(bsonWriter, (DBRef)value2);
        } else if (value2 instanceof Map) {
            this.encodeMap(bsonWriter, (Map)value2);
        } else if (value2 instanceof Iterable) {
            this.encodeIterable(bsonWriter, (Iterable)value2);
        } else if (value2 instanceof BSONObject) {
            this.encodeBsonObject(bsonWriter, (BSONObject)value2);
        } else if (value2 instanceof CodeWScope) {
            this.encodeCodeWScope(bsonWriter, (CodeWScope)value2);
        } else if (value2 instanceof byte[]) {
            this.encodeByteArray(bsonWriter, (byte[])value2);
        } else if (value2.getClass().isArray()) {
            this.encodeArray(bsonWriter, value2);
        } else if (value2 instanceof Symbol) {
            bsonWriter.writeSymbol(((Symbol)value2).getSymbol());
        } else {
            Codec<?> codec = this.codecRegistry.get(value2.getClass());
            codec.encode(bsonWriter, value2, encoderContext);
        }
    }

    private void encodeMap(BsonWriter bsonWriter, Map<String, Object> document2) {
        bsonWriter.writeStartDocument();
        for (Map.Entry<String, Object> entry2 : document2.entrySet()) {
            bsonWriter.writeName(entry2.getKey());
            this.writeValue(bsonWriter, null, entry2.getValue());
        }
        bsonWriter.writeEndDocument();
    }

    private void encodeBsonObject(BsonWriter bsonWriter, BSONObject document2) {
        bsonWriter.writeStartDocument();
        for (String key : document2.keySet()) {
            bsonWriter.writeName(key);
            this.writeValue(bsonWriter, null, document2.get(key));
        }
        bsonWriter.writeEndDocument();
    }

    private void encodeByteArray(BsonWriter bsonWriter, byte[] value2) {
        bsonWriter.writeBinaryData(new BsonBinary(value2));
    }

    private void encodeArray(BsonWriter bsonWriter, Object value2) {
        bsonWriter.writeStartArray();
        int size2 = Array.getLength(value2);
        for (int i = 0; i < size2; ++i) {
            this.writeValue(bsonWriter, null, Array.get(value2, i));
        }
        bsonWriter.writeEndArray();
    }

    private void encodeDBRef(BsonWriter bsonWriter, DBRef dbRef) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeString("$ref", dbRef.getCollectionName());
        bsonWriter.writeName("$id");
        this.writeValue(bsonWriter, null, dbRef.getId());
        if (dbRef.getDatabaseName() != null) {
            bsonWriter.writeString("$db", dbRef.getDatabaseName());
        }
        bsonWriter.writeEndDocument();
    }

    private void encodeCodeWScope(BsonWriter bsonWriter, CodeWScope value2) {
        bsonWriter.writeJavaScriptWithScope(value2.getCode());
        this.encodeBsonObject(bsonWriter, value2.getScope());
    }

    private void encodeIterable(BsonWriter bsonWriter, Iterable iterable2) {
        bsonWriter.writeStartArray();
        for (Object cur : iterable2) {
            this.writeValue(bsonWriter, null, cur);
        }
        bsonWriter.writeEndArray();
    }

    private Object readValue(BsonReader reader, DecoderContext decoderContext, String fieldName2, List<String> path2) {
        Object initialRetVal;
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType.isContainer() && fieldName2 != null) {
            path2.add(fieldName2);
        }
        switch (bsonType) {
            case DOCUMENT: {
                initialRetVal = this.verifyForDBRef(this.readDocument(reader, decoderContext, path2));
                break;
            }
            case ARRAY: {
                initialRetVal = this.readArray(reader, decoderContext, path2);
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                initialRetVal = this.readCodeWScope(reader, decoderContext, path2);
                break;
            }
            case DB_POINTER: {
                BsonDbPointer dbPointer = reader.readDBPointer();
                initialRetVal = new DBRef(dbPointer.getNamespace(), dbPointer.getId());
                break;
            }
            case BINARY: {
                initialRetVal = this.readBinary(reader, decoderContext);
                break;
            }
            case NULL: {
                reader.readNull();
                initialRetVal = null;
                break;
            }
            default: {
                initialRetVal = this.bsonTypeCodecMap.get(bsonType).decode(reader, decoderContext);
            }
        }
        if (bsonType.isContainer() && fieldName2 != null) {
            path2.remove(fieldName2);
        }
        return BSON.applyDecodingHooks(initialRetVal);
    }

    private Object readBinary(BsonReader reader, DecoderContext decoderContext) {
        byte bsonBinarySubType = reader.peekBinarySubType();
        if (BsonBinarySubType.isUuid(bsonBinarySubType) && reader.peekBinarySize() == 16) {
            return this.codecRegistry.get(UUID.class).decode(reader, decoderContext);
        }
        if (bsonBinarySubType == BsonBinarySubType.BINARY.getValue() || bsonBinarySubType == BsonBinarySubType.OLD_BINARY.getValue()) {
            return this.codecRegistry.get(byte[].class).decode(reader, decoderContext);
        }
        return this.codecRegistry.get(Binary.class).decode(reader, decoderContext);
    }

    private List readArray(BsonReader reader, DecoderContext decoderContext, List<String> path2) {
        reader.readStartArray();
        BasicDBList list2 = new BasicDBList();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list2.add(this.readValue(reader, decoderContext, null, path2));
        }
        reader.readEndArray();
        return list2;
    }

    private DBObject readDocument(BsonReader reader, DecoderContext decoderContext, List<String> path2) {
        DBObject document2 = this.objectFactory.getInstance(path2);
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName2 = reader.readName();
            document2.put(fieldName2, this.readValue(reader, decoderContext, fieldName2, path2));
        }
        reader.readEndDocument();
        return document2;
    }

    private CodeWScope readCodeWScope(BsonReader reader, DecoderContext decoderContext, List<String> path2) {
        return new CodeWScope(reader.readJavaScriptWithScope(), this.readDocument(reader, decoderContext, path2));
    }

    private Object verifyForDBRef(DBObject document2) {
        if (document2.containsField("$ref") && document2.containsField("$id")) {
            return new DBRef((String)document2.get("$db"), (String)document2.get("$ref"), document2.get("$id"));
        }
        return document2;
    }
}

