/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AggregationOptions;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BulkWriteHelper;
import com.mongodb.BulkWriteOperation;
import com.mongodb.BulkWriteResult;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.CompoundDBObjectCodec;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollectionObjectFactory;
import com.mongodb.DBCursor;
import com.mongodb.DBDecoderAdapter;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBEncoder;
import com.mongodb.DBEncoderAdapter;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DBEncoderFactoryAdapter;
import com.mongodb.DBObject;
import com.mongodb.DBObjectCodec;
import com.mongodb.DBObjectCollationHelper;
import com.mongodb.DBObjectFactory;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.ExplainVerbosity;
import com.mongodb.Function;
import com.mongodb.GroupCommand;
import com.mongodb.InsertOptions;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClient;
import com.mongodb.MongoCursorAdapter;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.ParallelScanOptions;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteResult;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.IndexRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.client.internal.MongoBatchCursorAdapter;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.DBCollectionCountOptions;
import com.mongodb.client.model.DBCollectionDistinctOptions;
import com.mongodb.client.model.DBCollectionFindAndModifyOptions;
import com.mongodb.client.model.DBCollectionFindOptions;
import com.mongodb.client.model.DBCollectionRemoveOptions;
import com.mongodb.client.model.DBCollectionUpdateOptions;
import com.mongodb.connection.BufferProvider;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.AggregateOperation;
import com.mongodb.operation.AggregateToCollectionOperation;
import com.mongodb.operation.BaseFindAndModifyOperation;
import com.mongodb.operation.BaseWriteOperation;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.CountOperation;
import com.mongodb.operation.CreateIndexesOperation;
import com.mongodb.operation.DeleteOperation;
import com.mongodb.operation.DistinctOperation;
import com.mongodb.operation.DropCollectionOperation;
import com.mongodb.operation.DropIndexOperation;
import com.mongodb.operation.FindAndDeleteOperation;
import com.mongodb.operation.FindAndReplaceOperation;
import com.mongodb.operation.FindAndUpdateOperation;
import com.mongodb.operation.InsertOperation;
import com.mongodb.operation.ListIndexesOperation;
import com.mongodb.operation.MapReduceBatchCursor;
import com.mongodb.operation.MapReduceStatistics;
import com.mongodb.operation.MapReduceToCollectionOperation;
import com.mongodb.operation.MapReduceWithInlineResultsOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.ParallelCollectionScanOperation;
import com.mongodb.operation.ReadOperation;
import com.mongodb.operation.RenameCollectionOperation;
import com.mongodb.operation.UpdateOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonInt32;
import org.bson.BsonJavaScript;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.BsonValueCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.types.ObjectId;

@ThreadSafe
public class DBCollection {
    public static final String ID_FIELD_NAME = "_id";
    private final String name;
    private final DB database;
    private final OperationExecutor executor;
    private final Bytes.OptionHolder optionHolder;
    private final boolean retryWrites;
    private volatile ReadPreference readPreference;
    private volatile WriteConcern writeConcern;
    private volatile ReadConcern readConcern;
    private List<DBObject> hintFields;
    private DBEncoderFactory encoderFactory;
    private DBDecoderFactory decoderFactory;
    private DBCollectionObjectFactory objectFactory;
    private volatile CompoundDBObjectCodec objectCodec;

    DBCollection(String name, DB database, OperationExecutor executor) {
        MongoNamespace.checkCollectionNameValidity(name);
        this.name = name;
        this.database = database;
        this.executor = executor;
        this.optionHolder = new Bytes.OptionHolder(database.getOptionHolder());
        this.objectFactory = new DBCollectionObjectFactory();
        this.objectCodec = new CompoundDBObjectCodec(this.getDefaultDBObjectCodec());
        this.retryWrites = database.getMongo().getMongoClientOptions().getRetryWrites();
    }

    protected DBCollection(DB database, String name) {
        this(name, database, database.getExecutor());
    }

    private static BasicDBList toDBList(BatchCursor<DBObject> source2) {
        BasicDBList dbList = new BasicDBList();
        while (source2.hasNext()) {
            dbList.addAll(source2.next());
        }
        return dbList;
    }

    public WriteResult insert(DBObject document2, WriteConcern writeConcern) {
        return this.insert(Arrays.asList(document2), writeConcern);
    }

    public WriteResult insert(DBObject ... documents) {
        return this.insert(Arrays.asList(documents), this.getWriteConcern());
    }

    public WriteResult insert(WriteConcern writeConcern, DBObject ... documents) {
        return this.insert(documents, writeConcern);
    }

    public WriteResult insert(DBObject[] documents, WriteConcern writeConcern) {
        return this.insert(Arrays.asList(documents), writeConcern);
    }

    public WriteResult insert(List<? extends DBObject> documents) {
        return this.insert(documents, this.getWriteConcern());
    }

    public WriteResult insert(List<? extends DBObject> documents, WriteConcern aWriteConcern) {
        return this.insert(documents, aWriteConcern, null);
    }

    public WriteResult insert(DBObject[] documents, WriteConcern aWriteConcern, DBEncoder encoder) {
        return this.insert(Arrays.asList(documents), aWriteConcern, encoder);
    }

    public WriteResult insert(List<? extends DBObject> documents, WriteConcern aWriteConcern, @Nullable DBEncoder dbEncoder) {
        return this.insert(documents, new InsertOptions().writeConcern(aWriteConcern).dbEncoder(dbEncoder));
    }

    public WriteResult insert(List<? extends DBObject> documents, InsertOptions insertOptions) {
        WriteConcern writeConcern = insertOptions.getWriteConcern() != null ? insertOptions.getWriteConcern() : this.getWriteConcern();
        Encoder<DBObject> encoder = this.toEncoder(insertOptions.getDbEncoder());
        ArrayList<InsertRequest> insertRequestList = new ArrayList<InsertRequest>(documents.size());
        for (DBObject dBObject : documents) {
            if (dBObject.get(ID_FIELD_NAME) == null) {
                dBObject.put(ID_FIELD_NAME, new ObjectId());
            }
            insertRequestList.add(new InsertRequest(new BsonDocumentWrapper<DBObject>(dBObject, encoder)));
        }
        return this.insert(insertRequestList, writeConcern, insertOptions.isContinueOnError(), insertOptions.getBypassDocumentValidation());
    }

    private Encoder<DBObject> toEncoder(@Nullable DBEncoder dbEncoder) {
        return dbEncoder != null ? new DBEncoderAdapter(dbEncoder) : this.objectCodec;
    }

    private WriteResult insert(List<InsertRequest> insertRequestList, WriteConcern writeConcern, boolean continueOnError, @Nullable Boolean bypassDocumentValidation) {
        return this.executeWriteOperation(new InsertOperation(this.getNamespace(), !continueOnError, writeConcern, this.retryWrites, insertRequestList).bypassDocumentValidation(bypassDocumentValidation));
    }

    WriteResult executeWriteOperation(BaseWriteOperation operation) {
        return this.translateWriteResult(this.executor.execute(operation, this.getReadConcern()));
    }

    private WriteResult translateWriteResult(WriteConcernResult writeConcernResult) {
        if (!writeConcernResult.wasAcknowledged()) {
            return WriteResult.unacknowledged();
        }
        return this.translateWriteResult(writeConcernResult.getCount(), writeConcernResult.isUpdateOfExisting(), writeConcernResult.getUpsertedId());
    }

    private WriteResult translateWriteResult(int count2, boolean isUpdateOfExisting, @Nullable BsonValue upsertedId) {
        Object newUpsertedId = upsertedId == null ? null : ((DBObject)this.getObjectCodec().decode(new BsonDocumentReader(new BsonDocument(ID_FIELD_NAME, upsertedId)), DecoderContext.builder().build())).get(ID_FIELD_NAME);
        return new WriteResult(count2, isUpdateOfExisting, newUpsertedId);
    }

    public WriteResult save(DBObject document2) {
        return this.save(document2, this.getWriteConcern());
    }

    public WriteResult save(DBObject document2, WriteConcern writeConcern) {
        Object id2 = document2.get(ID_FIELD_NAME);
        if (id2 == null) {
            return this.insert(document2, writeConcern);
        }
        return this.replaceOrInsert(document2, id2, writeConcern);
    }

    private WriteResult replaceOrInsert(DBObject obj, Object id2, WriteConcern writeConcern) {
        BasicDBObject filter2 = new BasicDBObject(ID_FIELD_NAME, id2);
        UpdateRequest replaceRequest = new UpdateRequest(this.wrap(filter2), this.wrap(obj, this.objectCodec), WriteRequest.Type.REPLACE).upsert(true);
        return this.executeWriteOperation(new UpdateOperation(this.getNamespace(), false, writeConcern, this.retryWrites, Collections.singletonList(replaceRequest)));
    }

    public WriteResult update(DBObject query, DBObject update2, boolean upsert, boolean multi2, WriteConcern aWriteConcern) {
        return this.update(query, update2, upsert, multi2, aWriteConcern, null);
    }

    public WriteResult update(DBObject query, DBObject update2, boolean upsert, boolean multi2, WriteConcern concern, @Nullable DBEncoder encoder) {
        return this.update(query, update2, upsert, multi2, concern, null, encoder);
    }

    public WriteResult update(DBObject query, DBObject update2, boolean upsert, boolean multi2, WriteConcern concern, @Nullable Boolean bypassDocumentValidation, @Nullable DBEncoder encoder) {
        return this.update(query, update2, new DBCollectionUpdateOptions().upsert(upsert).multi(multi2).writeConcern(concern).bypassDocumentValidation(bypassDocumentValidation).encoder(encoder));
    }

    public WriteResult update(DBObject query, DBObject update2, boolean upsert, boolean multi2) {
        return this.update(query, update2, upsert, multi2, this.getWriteConcern());
    }

    public WriteResult update(DBObject query, DBObject update2) {
        return this.update(query, update2, false, false);
    }

    public WriteResult updateMulti(DBObject query, DBObject update2) {
        return this.update(query, update2, false, true);
    }

    public WriteResult update(DBObject query, DBObject update2, DBCollectionUpdateOptions options2) {
        Assertions.notNull("query", query);
        Assertions.notNull("update", update2);
        Assertions.notNull("options", options2);
        WriteConcern writeConcern = options2.getWriteConcern() != null ? options2.getWriteConcern() : this.getWriteConcern();
        WriteRequest.Type updateType = !update2.keySet().isEmpty() && update2.keySet().iterator().next().startsWith("$") ? WriteRequest.Type.UPDATE : WriteRequest.Type.REPLACE;
        UpdateRequest updateRequest = new UpdateRequest(this.wrap(query), this.wrap(update2, options2.getEncoder()), updateType).upsert(options2.isUpsert()).multi(options2.isMulti()).collation(options2.getCollation()).arrayFilters(this.wrapAllowNull(options2.getArrayFilters(), options2.getEncoder()));
        return this.executeWriteOperation(new UpdateOperation(this.getNamespace(), true, writeConcern, this.retryWrites, Collections.singletonList(updateRequest)).bypassDocumentValidation(options2.getBypassDocumentValidation()));
    }

    public WriteResult remove(DBObject query) {
        return this.remove(query, this.getWriteConcern());
    }

    public WriteResult remove(DBObject query, WriteConcern writeConcern) {
        return this.remove(query, new DBCollectionRemoveOptions().writeConcern(writeConcern));
    }

    public WriteResult remove(DBObject query, WriteConcern writeConcern, DBEncoder encoder) {
        return this.remove(query, new DBCollectionRemoveOptions().writeConcern(writeConcern).encoder(encoder));
    }

    public WriteResult remove(DBObject query, DBCollectionRemoveOptions options2) {
        Assertions.notNull("query", query);
        Assertions.notNull("options", options2);
        WriteConcern writeConcern = options2.getWriteConcern() != null ? options2.getWriteConcern() : this.getWriteConcern();
        DeleteRequest deleteRequest = new DeleteRequest(this.wrap(query, options2.getEncoder())).collation(options2.getCollation());
        return this.executeWriteOperation(new DeleteOperation(this.getNamespace(), false, writeConcern, this.retryWrites, Collections.singletonList(deleteRequest)));
    }

    @Deprecated
    public DBCursor find(DBObject query, DBObject projection2, int numToSkip, int batchSize, int options2) {
        return new DBCursor(this, query, projection2, this.getReadPreference()).batchSize(batchSize).skip(numToSkip).setOptions(options2);
    }

    @Deprecated
    public DBCursor find(DBObject query, DBObject projection2, int numToSkip, int batchSize) {
        return new DBCursor(this, query, projection2, this.getReadPreference()).batchSize(batchSize).skip(numToSkip);
    }

    public DBCursor find(DBObject query) {
        return new DBCursor(this, query, null, this.getReadPreference());
    }

    public DBCursor find(DBObject query, DBObject projection2) {
        return new DBCursor(this, query, projection2, this.getReadPreference());
    }

    public DBCursor find() {
        return this.find(new BasicDBObject());
    }

    public DBCursor find(@Nullable DBObject query, DBCollectionFindOptions options2) {
        return new DBCursor(this, query, options2);
    }

    @Nullable
    public DBObject findOne() {
        return this.findOne(new BasicDBObject());
    }

    @Nullable
    public DBObject findOne(DBObject query) {
        return this.findOne(query, null, null, this.getReadPreference());
    }

    @Nullable
    public DBObject findOne(DBObject query, DBObject projection2) {
        return this.findOne(query, projection2, null, this.getReadPreference());
    }

    @Nullable
    public DBObject findOne(DBObject query, DBObject projection2, DBObject sort2) {
        return this.findOne(query, projection2, sort2, this.getReadPreference());
    }

    @Nullable
    public DBObject findOne(DBObject query, DBObject projection2, ReadPreference readPreference) {
        return this.findOne(query, projection2, null, readPreference);
    }

    @Nullable
    public DBObject findOne(@Nullable DBObject query, @Nullable DBObject projection2, @Nullable DBObject sort2, ReadPreference readPreference) {
        return this.findOne(query != null ? query : new BasicDBObject(), new DBCollectionFindOptions().projection(projection2).sort(sort2).readPreference(readPreference));
    }

    @Nullable
    public DBObject findOne(Object id2) {
        return this.findOne((DBObject)new BasicDBObject(ID_FIELD_NAME, id2), new DBCollectionFindOptions());
    }

    @Nullable
    public DBObject findOne(Object id2, DBObject projection2) {
        return this.findOne((DBObject)new BasicDBObject(ID_FIELD_NAME, id2), new DBCollectionFindOptions().projection(projection2));
    }

    @Nullable
    public DBObject findOne(@Nullable DBObject query, DBCollectionFindOptions findOptions) {
        return this.find(query, findOptions).one();
    }

    public long count() {
        return this.getCount((DBObject)new BasicDBObject(), new DBCollectionCountOptions());
    }

    public long count(@Nullable DBObject query) {
        return this.getCount(query, new DBCollectionCountOptions());
    }

    public long count(@Nullable DBObject query, ReadPreference readPreference) {
        return this.getCount(query, null, readPreference);
    }

    public long count(@Nullable DBObject query, DBCollectionCountOptions options2) {
        return this.getCount(query, options2);
    }

    public long getCount() {
        return this.getCount((DBObject)new BasicDBObject(), new DBCollectionCountOptions());
    }

    public long getCount(ReadPreference readPreference) {
        return this.getCount(new BasicDBObject(), null, readPreference);
    }

    public long getCount(@Nullable DBObject query) {
        return this.getCount(query, new DBCollectionCountOptions());
    }

    @Deprecated
    public long getCount(@Nullable DBObject query, DBObject projection2) {
        return this.getCount(query, projection2, 0L, 0L);
    }

    @Deprecated
    public long getCount(@Nullable DBObject query, @Nullable DBObject projection2, ReadPreference readPreference) {
        return this.getCount(query, projection2, 0L, 0L, readPreference);
    }

    @Deprecated
    public long getCount(@Nullable DBObject query, @Nullable DBObject projection2, long limit2, long skip) {
        return this.getCount(query, projection2, limit2, skip, this.getReadPreference());
    }

    @Deprecated
    public long getCount(@Nullable DBObject query, @Nullable DBObject projection2, long limit2, long skip, ReadPreference readPreference) {
        return this.getCount(query, new DBCollectionCountOptions().limit(limit2).skip(skip).readPreference(readPreference));
    }

    public long getCount(@Nullable DBObject query, DBCollectionCountOptions options2) {
        DBObject hint;
        Assertions.notNull("countOptions", options2);
        CountOperation operation = new CountOperation(this.getNamespace()).skip(options2.getSkip()).limit(options2.getLimit()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).collation(options2.getCollation());
        if (query != null) {
            operation.filter(this.wrap(query));
        }
        if ((hint = options2.getHint()) != null) {
            operation.hint(this.wrap(hint));
        } else {
            String hintString = options2.getHintString();
            if (hintString != null) {
                operation.hint(new BsonString(hintString));
            }
        }
        ReadPreference optionsReadPreference = options2.getReadPreference();
        ReadConcern optionsReadConcern = options2.getReadConcern();
        return this.executor.execute(operation, optionsReadPreference != null ? optionsReadPreference : this.getReadPreference(), optionsReadConcern != null ? optionsReadConcern : this.getReadConcern());
    }

    public DBCollection rename(String newName) {
        return this.rename(newName, false);
    }

    public DBCollection rename(String newName, boolean dropTarget) {
        try {
            this.executor.execute(new RenameCollectionOperation(this.getNamespace(), new MongoNamespace(this.getNamespace().getDatabaseName(), newName), this.getWriteConcern()).dropTarget(dropTarget), this.getReadConcern());
            return this.getDB().getCollection(newName);
        }
        catch (MongoWriteConcernException e) {
            throw DBCollection.createWriteConcernException(e);
        }
    }

    @Deprecated
    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce2) {
        return this.group(key, cond, initial, reduce2, null);
    }

    @Deprecated
    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce2, @Nullable String finalize) {
        return this.group(key, cond, initial, reduce2, finalize, this.getReadPreference());
    }

    @Deprecated
    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce2, @Nullable String finalize, ReadPreference readPreference) {
        return this.group(new GroupCommand(this, key, cond, initial, reduce2, finalize), readPreference);
    }

    @Deprecated
    public DBObject group(GroupCommand cmd) {
        return this.group(cmd, this.getReadPreference());
    }

    @Deprecated
    public DBObject group(GroupCommand cmd, ReadPreference readPreference) {
        return DBCollection.toDBList((BatchCursor)((Object)this.executor.execute(cmd.toOperation(this.getNamespace(), this.getDefaultDBObjectCodec()), readPreference, this.getReadConcern())));
    }

    public List distinct(String fieldName2) {
        return this.distinct(fieldName2, this.getReadPreference());
    }

    public List distinct(String fieldName2, ReadPreference readPreference) {
        return this.distinct(fieldName2, new BasicDBObject(), readPreference);
    }

    public List distinct(String fieldName2, DBObject query) {
        return this.distinct(fieldName2, query, this.getReadPreference());
    }

    public List distinct(String fieldName2, DBObject query, ReadPreference readPreference) {
        return this.distinct(fieldName2, new DBCollectionDistinctOptions().filter(query).readPreference(readPreference));
    }

    public List distinct(final String fieldName2, final DBCollectionDistinctOptions options2) {
        Assertions.notNull("fieldName", fieldName2);
        return new MongoIterableImpl<BsonValue>(null, this.executor, options2.getReadConcern() != null ? options2.getReadConcern() : this.getReadConcern(), options2.getReadPreference() != null ? options2.getReadPreference() : this.getReadPreference()){

            @Override
            public ReadOperation<BatchCursor<BsonValue>> asReadOperation() {
                return new DistinctOperation<BsonValue>(DBCollection.this.getNamespace(), fieldName2, new BsonValueCodec()).filter(DBCollection.this.wrapAllowNull(options2.getFilter())).collation(options2.getCollation());
            }
        }.map(new Function<BsonValue, Object>(){

            @Override
            public Object apply(BsonValue bsonValue) {
                if (bsonValue == null) {
                    return null;
                }
                BsonDocument document2 = new BsonDocument("value", bsonValue);
                DBObject obj = DBCollection.this.getDefaultDBObjectCodec().decode(new BsonDocumentReader(document2), DecoderContext.builder().build());
                return obj.get("value");
            }
        }).into(new ArrayList());
    }

    public MapReduceOutput mapReduce(String map2, String reduce2, String outputTarget, DBObject query) {
        MapReduceCommand command = new MapReduceCommand(this, map2, reduce2, outputTarget, MapReduceCommand.OutputType.REDUCE, query);
        return this.mapReduce(command);
    }

    public MapReduceOutput mapReduce(String map2, String reduce2, String outputTarget, MapReduceCommand.OutputType outputType, DBObject query) {
        MapReduceCommand command = new MapReduceCommand(this, map2, reduce2, outputTarget, outputType, query);
        return this.mapReduce(command);
    }

    public MapReduceOutput mapReduce(String map2, String reduce2, String outputTarget, MapReduceCommand.OutputType outputType, DBObject query, ReadPreference readPreference) {
        MapReduceCommand command = new MapReduceCommand(this, map2, reduce2, outputTarget, outputType, query);
        command.setReadPreference(readPreference);
        return this.mapReduce(command);
    }

    public MapReduceOutput mapReduce(MapReduceCommand command) {
        String action2;
        ReadPreference readPreference = command.getReadPreference() == null ? this.getReadPreference() : command.getReadPreference();
        Map<String, Object> scope2 = command.getScope();
        Boolean jsMode = command.getJsMode();
        if (command.getOutputType() == MapReduceCommand.OutputType.INLINE) {
            MapReduceWithInlineResultsOperation<DBObject> operation = new MapReduceWithInlineResultsOperation<DBObject>(this.getNamespace(), new BsonJavaScript(command.getMap()), new BsonJavaScript(command.getReduce()), this.getDefaultDBObjectCodec()).filter(this.wrapAllowNull(command.getQuery())).limit(command.getLimit()).maxTime(command.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).jsMode(jsMode == null ? false : jsMode).sort(this.wrapAllowNull(command.getSort())).verbose(command.isVerbose()).collation(command.getCollation());
            if (scope2 != null) {
                operation.scope(this.wrap(new BasicDBObject(scope2)));
            }
            if (command.getFinalize() != null) {
                operation.finalizeFunction(new BsonJavaScript(command.getFinalize()));
            }
            MapReduceBatchCursor executionResult = (MapReduceBatchCursor)((Object)this.executor.execute(operation, readPreference, this.getReadConcern()));
            return new MapReduceOutput(command.toDBObject(), executionResult);
        }
        switch (command.getOutputType()) {
            case REPLACE: {
                action2 = "replace";
                break;
            }
            case MERGE: {
                action2 = "merge";
                break;
            }
            case REDUCE: {
                action2 = "reduce";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected output type");
            }
        }
        MapReduceToCollectionOperation operation = new MapReduceToCollectionOperation(this.getNamespace(), new BsonJavaScript(command.getMap()), new BsonJavaScript(command.getReduce()), command.getOutputTarget(), this.getWriteConcern()).filter(this.wrapAllowNull(command.getQuery())).limit(command.getLimit()).maxTime(command.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).jsMode(jsMode == null ? false : jsMode).sort(this.wrapAllowNull(command.getSort())).verbose(command.isVerbose()).action(action2).databaseName(command.getOutputDB()).bypassDocumentValidation(command.getBypassDocumentValidation()).collation(command.getCollation());
        if (scope2 != null) {
            operation.scope(this.wrap(new BasicDBObject(scope2)));
        }
        if (command.getFinalize() != null) {
            operation.finalizeFunction(new BsonJavaScript(command.getFinalize()));
        }
        try {
            MapReduceStatistics mapReduceStatistics = this.executor.execute(operation, this.getReadConcern());
            DBCollection mapReduceOutputCollection = this.getMapReduceOutputCollection(command);
            DBCursor executionResult = mapReduceOutputCollection.find();
            return new MapReduceOutput(command.toDBObject(), executionResult, mapReduceStatistics, mapReduceOutputCollection);
        }
        catch (MongoWriteConcernException e) {
            throw DBCollection.createWriteConcernException(e);
        }
    }

    private DBCollection getMapReduceOutputCollection(MapReduceCommand command) {
        String requestedDatabaseName = command.getOutputDB();
        DB database = requestedDatabaseName != null ? this.getDB().getSisterDB(requestedDatabaseName) : this.getDB();
        return database.getCollection(command.getOutputTargetNonNull());
    }

    @Deprecated
    public AggregationOutput aggregate(DBObject firstOp, DBObject ... additionalOps) {
        ArrayList<DBObject> pipeline = new ArrayList<DBObject>();
        pipeline.add(firstOp);
        Collections.addAll(pipeline, additionalOps);
        return this.aggregate(pipeline);
    }

    @Deprecated
    public AggregationOutput aggregate(List<? extends DBObject> pipeline) {
        return this.aggregate(pipeline, this.getReadPreference());
    }

    @Deprecated
    public AggregationOutput aggregate(List<? extends DBObject> pipeline, ReadPreference readPreference) {
        Cursor cursor = this.aggregate(pipeline, AggregationOptions.builder().build(), readPreference, false);
        if (cursor == null) {
            return new AggregationOutput(Collections.<DBObject>emptyList());
        }
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        while (cursor.hasNext()) {
            results.add((DBObject)cursor.next());
        }
        return new AggregationOutput(results);
    }

    public Cursor aggregate(List<? extends DBObject> pipeline, AggregationOptions options2) {
        return this.aggregate(pipeline, options2, this.getReadPreference());
    }

    public Cursor aggregate(List<? extends DBObject> pipeline, AggregationOptions options2, ReadPreference readPreference) {
        Cursor cursor = this.aggregate(pipeline, options2, readPreference, true);
        if (cursor == null) {
            throw new MongoInternalException("cursor can not be null in this context");
        }
        return cursor;
    }

    @Nullable
    private Cursor aggregate(List<? extends DBObject> pipeline, AggregationOptions options2, ReadPreference readPreference, boolean returnCursorForOutCollection) {
        Assertions.notNull("options", options2);
        List<BsonDocument> stages = this.preparePipeline(pipeline);
        BsonValue outCollection = stages.get(stages.size() - 1).get("$out");
        if (outCollection != null) {
            AggregateToCollectionOperation operation = new AggregateToCollectionOperation(this.getNamespace(), stages, this.getWriteConcern()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).allowDiskUse(options2.getAllowDiskUse()).bypassDocumentValidation(options2.getBypassDocumentValidation()).collation(options2.getCollation());
            try {
                this.executor.execute(operation, this.getReadConcern());
                if (returnCursorForOutCollection) {
                    return new DBCursor(this.database.getCollection(outCollection.asString().getValue()), new BasicDBObject(), new DBCollectionFindOptions().readPreference(ReadPreference.primary()).collation(options2.getCollation()));
                }
                return null;
            }
            catch (MongoWriteConcernException e) {
                throw DBCollection.createWriteConcernException(e);
            }
        }
        AggregateOperation<DBObject> operation = new AggregateOperation<DBObject>(this.getNamespace(), stages, this.getDefaultDBObjectCodec()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).allowDiskUse(options2.getAllowDiskUse()).batchSize(options2.getBatchSize()).useCursor(options2.getOutputMode() == AggregationOptions.OutputMode.CURSOR).collation(options2.getCollation());
        BatchCursor cursor = (BatchCursor)((Object)this.executor.execute(operation, readPreference, this.getReadConcern()));
        return new MongoCursorAdapter(new MongoBatchCursorAdapter<DBObject>(cursor));
    }

    public CommandResult explainAggregate(List<? extends DBObject> pipeline, AggregationOptions options2) {
        AggregateOperation<BsonDocument> operation = new AggregateOperation<BsonDocument>(this.getNamespace(), this.preparePipeline(pipeline), new BsonDocumentCodec()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).allowDiskUse(options2.getAllowDiskUse()).collation(options2.getCollation());
        return new CommandResult(this.executor.execute(operation.asExplainableOperation(ExplainVerbosity.QUERY_PLANNER), ReadPreference.primaryPreferred(), this.getReadConcern()));
    }

    List<BsonDocument> preparePipeline(List<? extends DBObject> pipeline) {
        ArrayList<BsonDocument> stages = new ArrayList<BsonDocument>();
        for (DBObject dBObject : pipeline) {
            stages.add(this.wrap(dBObject));
        }
        return stages;
    }

    @Deprecated
    public List<Cursor> parallelScan(ParallelScanOptions options2) {
        ArrayList<Cursor> cursors = new ArrayList<Cursor>();
        ParallelCollectionScanOperation<DBObject> operation = new ParallelCollectionScanOperation<DBObject>(this.getNamespace(), options2.getNumCursors(), this.objectCodec).batchSize(options2.getBatchSize());
        ReadPreference readPreferenceFromOptions = options2.getReadPreference();
        List mongoCursors = (List)((Object)this.executor.execute(operation, readPreferenceFromOptions != null ? readPreferenceFromOptions : this.getReadPreference(), this.getReadConcern()));
        for (BatchCursor mongoCursor : mongoCursors) {
            cursors.add(new MongoCursorAdapter(new MongoBatchCursorAdapter<DBObject>(mongoCursor)));
        }
        return cursors;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.getNamespace().getFullName();
    }

    public DBCollection getCollection(String name) {
        return this.database.getCollection(this.getName() + "." + name);
    }

    public void createIndex(String name) {
        this.createIndex(new BasicDBObject(name, (Object)1));
    }

    public void createIndex(DBObject keys2, String name) {
        this.createIndex(keys2, name, false);
    }

    public void createIndex(DBObject keys2, @Nullable String name, boolean unique2) {
        BasicDBObject options2 = new BasicDBObject();
        if (name != null && name.length() > 0) {
            options2.put("name", name);
        }
        if (unique2) {
            options2.put("unique", Boolean.TRUE);
        }
        this.createIndex(keys2, options2);
    }

    public void createIndex(DBObject keys2) {
        this.createIndex(keys2, new BasicDBObject());
    }

    public void createIndex(DBObject keys2, DBObject options2) {
        try {
            this.executor.execute(this.createIndexOperation(keys2, options2), this.getReadConcern());
        }
        catch (MongoWriteConcernException e) {
            throw DBCollection.createWriteConcernException(e);
        }
    }

    @Deprecated
    @Nullable
    public List<DBObject> getHintFields() {
        return this.hintFields;
    }

    @Deprecated
    public void setHintFields(List<? extends DBObject> indexes) {
        this.hintFields = new ArrayList<DBObject>(indexes);
    }

    @Nullable
    public DBObject findAndModify(@Nullable DBObject query, @Nullable DBObject sort2, DBObject update2) {
        return this.findAndModify(query, null, sort2, false, update2, false, false);
    }

    @Nullable
    public DBObject findAndModify(@Nullable DBObject query, DBObject update2) {
        return this.findAndModify(query, null, null, false, update2, false, false);
    }

    @Nullable
    public DBObject findAndRemove(@Nullable DBObject query) {
        return this.findAndModify(query, null, null, true, null, false, false);
    }

    @Nullable
    public DBObject findAndModify(@Nullable DBObject query, @Nullable DBObject fields, @Nullable DBObject sort2, boolean remove2, @Nullable DBObject update2, boolean returnNew, boolean upsert) {
        return this.findAndModify(query, fields, sort2, remove2, update2, returnNew, upsert, 0L, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public DBObject findAndModify(@Nullable DBObject query, @Nullable DBObject fields, @Nullable DBObject sort2, boolean remove2, DBObject update2, boolean returnNew, boolean upsert, WriteConcern writeConcern) {
        return this.findAndModify(query, fields, sort2, remove2, update2, returnNew, upsert, 0L, TimeUnit.MILLISECONDS, writeConcern);
    }

    @Nullable
    public DBObject findAndModify(@Nullable DBObject query, @Nullable DBObject fields, @Nullable DBObject sort2, boolean remove2, @Nullable DBObject update2, boolean returnNew, boolean upsert, long maxTime, TimeUnit maxTimeUnit) {
        return this.findAndModify(query, fields, sort2, remove2, update2, returnNew, upsert, maxTime, maxTimeUnit, this.getWriteConcern());
    }

    @Nullable
    public DBObject findAndModify(@Nullable DBObject query, @Nullable DBObject fields, @Nullable DBObject sort2, boolean remove2, @Nullable DBObject update2, boolean returnNew, boolean upsert, long maxTime, TimeUnit maxTimeUnit, WriteConcern writeConcern) {
        return this.findAndModify(query != null ? query : new BasicDBObject(), new DBCollectionFindAndModifyOptions().projection(fields).sort(sort2).remove(remove2).update(update2).returnNew(returnNew).upsert(upsert).maxTime(maxTime, maxTimeUnit).writeConcern(writeConcern));
    }

    @Nullable
    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort2, boolean remove2, @Nullable DBObject update2, boolean returnNew, boolean upsert, boolean bypassDocumentValidation, long maxTime, TimeUnit maxTimeUnit) {
        return this.findAndModify(query, fields, sort2, remove2, update2, returnNew, upsert, bypassDocumentValidation, maxTime, maxTimeUnit, this.getWriteConcern());
    }

    public DBObject findAndModify(@Nullable DBObject query, @Nullable DBObject fields, @Nullable DBObject sort2, boolean remove2, @Nullable DBObject update2, boolean returnNew, boolean upsert, boolean bypassDocumentValidation, long maxTime, TimeUnit maxTimeUnit, WriteConcern writeConcern) {
        return this.findAndModify(query != null ? query : new BasicDBObject(), new DBCollectionFindAndModifyOptions().projection(fields).sort(sort2).remove(remove2).update(update2).returnNew(returnNew).upsert(upsert).bypassDocumentValidation(bypassDocumentValidation).maxTime(maxTime, maxTimeUnit).writeConcern(writeConcern));
    }

    public DBObject findAndModify(DBObject query, DBCollectionFindAndModifyOptions options2) {
        BaseFindAndModifyOperation operation;
        WriteConcern writeConcern;
        Assertions.notNull("query", query);
        Assertions.notNull("options", options2);
        WriteConcern optionsWriteConcern = options2.getWriteConcern();
        WriteConcern writeConcern2 = writeConcern = optionsWriteConcern != null ? optionsWriteConcern : this.getWriteConcern();
        if (options2.isRemove()) {
            operation = new FindAndDeleteOperation<DBObject>(this.getNamespace(), writeConcern, this.retryWrites, this.objectCodec).filter(this.wrapAllowNull(query)).projection(this.wrapAllowNull(options2.getProjection())).sort(this.wrapAllowNull(options2.getSort())).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).collation(options2.getCollation());
        } else {
            DBObject update2 = options2.getUpdate();
            if (update2 == null) {
                throw new IllegalArgumentException("update can not be null unless it's a remove");
            }
            operation = !update2.keySet().isEmpty() && update2.keySet().iterator().next().charAt(0) == '$' ? new FindAndUpdateOperation<DBObject>(this.getNamespace(), writeConcern, this.retryWrites, this.objectCodec, this.wrap(update2)).filter(this.wrap(query)).projection(this.wrapAllowNull(options2.getProjection())).sort(this.wrapAllowNull(options2.getSort())).returnOriginal(!options2.returnNew()).upsert(options2.isUpsert()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).bypassDocumentValidation(options2.getBypassDocumentValidation()).collation(options2.getCollation()).arrayFilters(this.wrapAllowNull(options2.getArrayFilters(), (Encoder<DBObject>)null)) : new FindAndReplaceOperation<DBObject>(this.getNamespace(), writeConcern, this.retryWrites, this.objectCodec, this.wrap(update2)).filter(this.wrap(query)).projection(this.wrapAllowNull(options2.getProjection())).sort(this.wrapAllowNull(options2.getSort())).returnOriginal(!options2.returnNew()).upsert(options2.isUpsert()).maxTime(options2.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).bypassDocumentValidation(options2.getBypassDocumentValidation()).collation(options2.getCollation());
        }
        try {
            return this.executor.execute(operation, this.getReadConcern());
        }
        catch (MongoWriteConcernException e) {
            throw DBCollection.createWriteConcernException(e);
        }
    }

    public DB getDB() {
        return this.database;
    }

    public WriteConcern getWriteConcern() {
        if (this.writeConcern != null) {
            return this.writeConcern;
        }
        return this.database.getWriteConcern();
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public ReadPreference getReadPreference() {
        if (this.readPreference != null) {
            return this.readPreference;
        }
        return this.database.getReadPreference();
    }

    public void setReadPreference(ReadPreference preference) {
        this.readPreference = preference;
    }

    public void setReadConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
    }

    public ReadConcern getReadConcern() {
        if (this.readConcern != null) {
            return this.readConcern;
        }
        return this.database.getReadConcern();
    }

    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    @Deprecated
    public void addOption(int option2) {
        this.optionHolder.add(option2);
    }

    @Deprecated
    public void resetOptions() {
        this.optionHolder.reset();
    }

    @Deprecated
    public int getOptions() {
        return this.optionHolder.get();
    }

    @Deprecated
    public void setOptions(int options2) {
        this.optionHolder.set(options2);
    }

    public void drop() {
        try {
            this.executor.execute(new DropCollectionOperation(this.getNamespace(), this.getWriteConcern()), this.getReadConcern());
        }
        catch (MongoWriteConcernException e) {
            throw DBCollection.createWriteConcernException(e);
        }
    }

    public synchronized DBDecoderFactory getDBDecoderFactory() {
        return this.decoderFactory;
    }

    public synchronized void setDBDecoderFactory(@Nullable DBDecoderFactory factory) {
        this.decoderFactory = factory;
        DBObjectCodec decoder = factory == null || factory == DefaultDBDecoder.FACTORY ? this.getDefaultDBObjectCodec() : new DBDecoderAdapter(factory.create(), this, this.getBufferPool());
        this.objectCodec = new CompoundDBObjectCodec(this.objectCodec.getEncoder(), decoder);
    }

    public synchronized DBEncoderFactory getDBEncoderFactory() {
        return this.encoderFactory;
    }

    public synchronized void setDBEncoderFactory(@Nullable DBEncoderFactory factory) {
        this.encoderFactory = factory;
        DBObjectCodec encoder = factory == null || factory == DefaultDBEncoder.FACTORY ? this.getDefaultDBObjectCodec() : new DBEncoderFactoryAdapter(this.encoderFactory);
        this.objectCodec = new CompoundDBObjectCodec(encoder, this.objectCodec.getDecoder());
    }

    public List<DBObject> getIndexInfo() {
        return new MongoIterableImpl<DBObject>(null, this.executor, ReadConcern.DEFAULT, ReadPreference.primary()){

            @Override
            public ReadOperation<BatchCursor<DBObject>> asReadOperation() {
                return new ListIndexesOperation<DBObject>(DBCollection.this.getNamespace(), DBCollection.this.getDefaultDBObjectCodec());
            }
        }.into(new ArrayList());
    }

    public void dropIndex(DBObject index2) {
        try {
            this.executor.execute(new DropIndexOperation(this.getNamespace(), this.wrap(index2), this.getWriteConcern()), this.getReadConcern());
        }
        catch (MongoWriteConcernException e) {
            throw DBCollection.createWriteConcernException(e);
        }
    }

    public void dropIndex(String indexName) {
        try {
            this.executor.execute(new DropIndexOperation(this.getNamespace(), indexName, this.getWriteConcern()), this.getReadConcern());
        }
        catch (MongoWriteConcernException e) {
            throw DBCollection.createWriteConcernException(e);
        }
    }

    public void dropIndexes() {
        this.dropIndex("*");
    }

    public void dropIndexes(String indexName) {
        this.dropIndex(indexName);
    }

    public CommandResult getStats() {
        return this.getDB().executeCommand(new BsonDocument("collStats", new BsonString(this.getName())), this.getReadPreference());
    }

    public boolean isCapped() {
        CommandResult commandResult = this.getStats();
        Object cappedField = commandResult.get("capped");
        return cappedField != null && (cappedField.equals(1) || cappedField.equals(true));
    }

    public Class getObjectClass() {
        return this.objectFactory.getClassForPath(Collections.<String>emptyList());
    }

    public void setObjectClass(Class<? extends DBObject> aClass) {
        this.setObjectFactory(this.objectFactory.update(aClass));
    }

    public void setInternalClass(String path2, Class<? extends DBObject> aClass) {
        this.setObjectFactory(this.objectFactory.update(aClass, Arrays.asList(path2.split("\\."))));
    }

    protected Class<? extends DBObject> getInternalClass(String path2) {
        return this.objectFactory.getClassForPath(Arrays.asList(path2.split("\\.")));
    }

    public String toString() {
        return "DBCollection{database=" + this.database + ", name='" + this.name + '\'' + '}';
    }

    synchronized DBObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    synchronized void setObjectFactory(DBCollectionObjectFactory factory) {
        this.objectFactory = factory;
        this.objectCodec = new CompoundDBObjectCodec(this.objectCodec.getEncoder(), this.getDefaultDBObjectCodec());
    }

    public BulkWriteOperation initializeOrderedBulkOperation() {
        return new BulkWriteOperation(true, this);
    }

    public BulkWriteOperation initializeUnorderedBulkOperation() {
        return new BulkWriteOperation(false, this);
    }

    BulkWriteResult executeBulkWriteOperation(boolean ordered, Boolean bypassDocumentValidation, List<com.mongodb.WriteRequest> writeRequests) {
        return this.executeBulkWriteOperation(ordered, bypassDocumentValidation, writeRequests, this.getWriteConcern());
    }

    BulkWriteResult executeBulkWriteOperation(boolean ordered, Boolean bypassDocumentValidation, List<com.mongodb.WriteRequest> writeRequests, WriteConcern writeConcern) {
        try {
            return BulkWriteHelper.translateBulkWriteResult(this.executor.execute(new MixedBulkWriteOperation(this.getNamespace(), this.translateWriteRequestsToNew(writeRequests), ordered, writeConcern, false).bypassDocumentValidation(bypassDocumentValidation), this.getReadConcern()), this.getObjectCodec());
        }
        catch (MongoBulkWriteException e) {
            throw BulkWriteHelper.translateBulkWriteException(e, MongoClient.getDefaultCodecRegistry().get(DBObject.class));
        }
    }

    private List<WriteRequest> translateWriteRequestsToNew(List<com.mongodb.WriteRequest> writeRequests) {
        ArrayList<WriteRequest> retVal = new ArrayList<WriteRequest>(writeRequests.size());
        for (com.mongodb.WriteRequest cur : writeRequests) {
            retVal.add(cur.toNew(this));
        }
        return retVal;
    }

    DBObjectCodec getDefaultDBObjectCodec() {
        return new DBObjectCodec(MongoClient.getDefaultCodecRegistry(), DBObjectCodec.getDefaultBsonTypeClassMap(), this.getObjectFactory());
    }

    private <T> T convertOptionsToType(DBObject options2, String field2, Class<T> clazz2) {
        return this.convertToType(clazz2, options2.get(field2), String.format("'%s' should be of class %s", field2, clazz2.getSimpleName()));
    }

    private <T> T convertToType(Class<T> clazz2, Object value2, String errorMessage2) {
        Object transformedValue = value2;
        if (clazz2 == Boolean.class) {
            if (value2 instanceof Boolean) {
                transformedValue = value2;
            } else if (value2 instanceof Number) {
                transformedValue = ((Number)value2).doubleValue() != 0.0;
            }
        } else if (clazz2 == Double.class) {
            if (value2 instanceof Number) {
                transformedValue = ((Number)value2).doubleValue();
            }
        } else if (clazz2 == Integer.class) {
            if (value2 instanceof Number) {
                transformedValue = ((Number)value2).intValue();
            }
        } else if (clazz2 == Long.class && value2 instanceof Number) {
            transformedValue = ((Number)value2).longValue();
        }
        if (!clazz2.isAssignableFrom(transformedValue.getClass())) {
            throw new IllegalArgumentException(errorMessage2);
        }
        return (T)transformedValue;
    }

    private CreateIndexesOperation createIndexOperation(DBObject key, DBObject options2) {
        IndexRequest request2 = new IndexRequest(this.wrap(key));
        if (options2.containsField("name")) {
            request2.name(this.convertOptionsToType(options2, "name", String.class));
        }
        if (options2.containsField("background")) {
            request2.background(this.convertOptionsToType(options2, "background", Boolean.class));
        }
        if (options2.containsField("unique")) {
            request2.unique(this.convertOptionsToType(options2, "unique", Boolean.class));
        }
        if (options2.containsField("sparse")) {
            request2.sparse(this.convertOptionsToType(options2, "sparse", Boolean.class));
        }
        if (options2.containsField("expireAfterSeconds")) {
            request2.expireAfter(this.convertOptionsToType(options2, "expireAfterSeconds", Long.class), TimeUnit.SECONDS);
        }
        if (options2.containsField("v")) {
            request2.version(this.convertOptionsToType(options2, "v", Integer.class));
        }
        if (options2.containsField("weights")) {
            request2.weights(this.wrap(this.convertOptionsToType(options2, "weights", DBObject.class)));
        }
        if (options2.containsField("default_language")) {
            request2.defaultLanguage(this.convertOptionsToType(options2, "default_language", String.class));
        }
        if (options2.containsField("language_override")) {
            request2.languageOverride(this.convertOptionsToType(options2, "language_override", String.class));
        }
        if (options2.containsField("textIndexVersion")) {
            request2.textVersion(this.convertOptionsToType(options2, "textIndexVersion", Integer.class));
        }
        if (options2.containsField("2dsphereIndexVersion")) {
            request2.sphereVersion(this.convertOptionsToType(options2, "2dsphereIndexVersion", Integer.class));
        }
        if (options2.containsField("bits")) {
            request2.bits(this.convertOptionsToType(options2, "bits", Integer.class));
        }
        if (options2.containsField("min")) {
            request2.min(this.convertOptionsToType(options2, "min", Double.class));
        }
        if (options2.containsField("max")) {
            request2.max(this.convertOptionsToType(options2, "max", Double.class));
        }
        if (options2.containsField("bucketSize")) {
            request2.bucketSize(this.convertOptionsToType(options2, "bucketSize", Double.class));
        }
        if (options2.containsField("dropDups")) {
            request2.dropDups(this.convertOptionsToType(options2, "dropDups", Boolean.class));
        }
        if (options2.containsField("storageEngine")) {
            request2.storageEngine(this.wrap(this.convertOptionsToType(options2, "storageEngine", DBObject.class)));
        }
        if (options2.containsField("partialFilterExpression")) {
            request2.partialFilterExpression(this.wrap(this.convertOptionsToType(options2, "partialFilterExpression", DBObject.class)));
        }
        if (options2.containsField("collation")) {
            request2.collation(DBObjectCollationHelper.createCollationFromOptions(options2));
        }
        return new CreateIndexesOperation(this.getNamespace(), Collections.singletonList(request2), this.writeConcern);
    }

    Codec<DBObject> getObjectCodec() {
        return this.objectCodec;
    }

    OperationExecutor getExecutor() {
        return this.executor;
    }

    MongoNamespace getNamespace() {
        return new MongoNamespace(this.getDB().getName(), this.getName());
    }

    BufferProvider getBufferPool() {
        return this.getDB().getBufferPool();
    }

    @Nullable
    BsonDocument wrapAllowNull(@Nullable DBObject document2) {
        if (document2 == null) {
            return null;
        }
        return this.wrap(document2);
    }

    @Nullable
    List<BsonDocument> wrapAllowNull(@Nullable List<? extends DBObject> documentList, @Nullable DBEncoder encoder) {
        return this.wrapAllowNull(documentList, encoder == null ? null : new DBEncoderAdapter(encoder));
    }

    @Nullable
    List<BsonDocument> wrapAllowNull(@Nullable List<? extends DBObject> documentList, @Nullable Encoder<DBObject> encoder) {
        if (documentList == null) {
            return null;
        }
        ArrayList<BsonDocument> wrappedDocumentList = new ArrayList<BsonDocument>(documentList.size());
        for (DBObject dBObject : documentList) {
            wrappedDocumentList.add(encoder == null ? this.wrap(dBObject) : this.wrap(dBObject, encoder));
        }
        return wrappedDocumentList;
    }

    BsonDocument wrap(DBObject document2) {
        return new BsonDocumentWrapper<DBObject>(document2, this.getDefaultDBObjectCodec());
    }

    BsonDocument wrap(DBObject document2, @Nullable DBEncoder encoder) {
        if (encoder == null) {
            return this.wrap(document2);
        }
        return new BsonDocumentWrapper<DBObject>(document2, new DBEncoderAdapter(encoder));
    }

    BsonDocument wrap(DBObject document2, @Nullable Encoder<DBObject> encoder) {
        if (encoder == null) {
            return this.wrap(document2);
        }
        return new BsonDocumentWrapper<DBObject>(document2, encoder);
    }

    static WriteConcernException createWriteConcernException(MongoWriteConcernException e) {
        return new WriteConcernException(new BsonDocument("code", new BsonInt32(e.getWriteConcernError().getCode())).append("errmsg", new BsonString(e.getWriteConcernError().getMessage())), e.getServerAddress(), e.getWriteResult());
    }
}

