/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BulkWriteError;
import com.mongodb.BulkWriteResult;
import com.mongodb.MongoServerException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcernError;
import java.util.List;

public class BulkWriteException
extends MongoServerException {
    private static final long serialVersionUID = -1505950263354313025L;
    private final BulkWriteResult writeResult;
    private final List<BulkWriteError> writeErrors;
    private final ServerAddress serverAddress;
    private final WriteConcernError writeConcernError;

    BulkWriteException(BulkWriteResult writeResult, List<BulkWriteError> writeErrors, WriteConcernError writeConcernError, ServerAddress serverAddress) {
        super("Bulk write operation error on server " + serverAddress + ". " + (writeErrors.isEmpty() ? "" : "Write errors: " + writeErrors + ". ") + (writeConcernError == null ? "" : "Write concern error: " + writeConcernError + ". "), serverAddress);
        this.writeResult = writeResult;
        this.writeErrors = writeErrors;
        this.writeConcernError = writeConcernError;
        this.serverAddress = serverAddress;
    }

    public BulkWriteResult getWriteResult() {
        return this.writeResult;
    }

    public List<BulkWriteError> getWriteErrors() {
        return this.writeErrors;
    }

    public WriteConcernError getWriteConcernError() {
        return this.writeConcernError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkWriteException that2 = (BulkWriteException)o;
        if (!this.writeErrors.equals(that2.writeErrors)) {
            return false;
        }
        if (!this.serverAddress.equals(that2.serverAddress)) {
            return false;
        }
        if (this.writeConcernError != null ? !this.writeConcernError.equals(that2.writeConcernError) : that2.writeConcernError != null) {
            return false;
        }
        return this.writeResult.equals(that2.writeResult);
    }

    public int hashCode() {
        int result2 = this.writeResult.hashCode();
        result2 = 31 * result2 + this.writeErrors.hashCode();
        result2 = 31 * result2 + this.serverAddress.hashCode();
        result2 = 31 * result2 + (this.writeConcernError != null ? this.writeConcernError.hashCode() : 0);
        return result2;
    }
}

