/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BulkWriteResult;
import com.mongodb.BulkWriteUpsert;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;

class AcknowledgedBulkWriteResult
extends BulkWriteResult {
    private int insertedCount;
    private int matchedCount;
    private int removedCount;
    private Integer modifiedCount;
    private final List<BulkWriteUpsert> upserts;

    AcknowledgedBulkWriteResult(int insertedCount, int matchedCount, int removedCount, @Nullable Integer modifiedCount2, List<BulkWriteUpsert> upserts) {
        this.insertedCount = insertedCount;
        this.matchedCount = matchedCount;
        this.removedCount = removedCount;
        this.modifiedCount = modifiedCount2;
        this.upserts = Collections.unmodifiableList(Assertions.notNull("upserts", upserts));
    }

    @Override
    public boolean isAcknowledged() {
        return true;
    }

    @Override
    public int getInsertedCount() {
        return this.insertedCount;
    }

    @Override
    public int getMatchedCount() {
        return this.matchedCount;
    }

    @Override
    public int getRemovedCount() {
        return this.removedCount;
    }

    @Override
    public boolean isModifiedCountAvailable() {
        return this.modifiedCount != null;
    }

    @Override
    public int getModifiedCount() {
        if (this.modifiedCount == null) {
            throw new UnsupportedOperationException("The modifiedCount is not available because at least one of the servers updated was not able to provide this information (the server must be at least version 2.6 or higher.");
        }
        return this.modifiedCount;
    }

    @Override
    public List<BulkWriteUpsert> getUpserts() {
        return this.upserts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcknowledgedBulkWriteResult that2 = (AcknowledgedBulkWriteResult)o;
        if (this.insertedCount != that2.insertedCount) {
            return false;
        }
        if (this.matchedCount != that2.matchedCount) {
            return false;
        }
        if (this.removedCount != that2.removedCount) {
            return false;
        }
        if (this.modifiedCount != null ? !this.modifiedCount.equals(that2.modifiedCount) : that2.modifiedCount != null) {
            return false;
        }
        return this.upserts.equals(that2.upserts);
    }

    public int hashCode() {
        int result2 = this.insertedCount;
        result2 = 31 * result2 + this.matchedCount;
        result2 = 31 * result2 + this.removedCount;
        result2 = 31 * result2 + (this.modifiedCount != null ? this.modifiedCount.hashCode() : 0);
        result2 = 31 * result2 + this.upserts.hashCode();
        return result2;
    }

    public String toString() {
        return "AcknowledgedBulkWriteResult{insertedCount=" + this.insertedCount + ", matchedCount=" + this.matchedCount + ", removedCount=" + this.removedCount + ", modifiedCount=" + this.modifiedCount + ", upserts=" + this.upserts + '}';
    }
}

