/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.common.base;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression2) {
        if (!expression2) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression2, Object errorMessage2) {
        if (!expression2) {
            throw new IllegalArgumentException(String.valueOf(errorMessage2));
        }
    }

    public static void checkArgument(boolean expression2, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression2) {
        if (!expression2) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression2, Object errorMessage2) {
        if (!expression2) {
            throw new IllegalStateException(String.valueOf(errorMessage2));
        }
    }

    public static void checkState(boolean expression2, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression2) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, Object errorMessage2) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage2));
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T iterable2) {
        if (Preconditions.containsOrIsNull(iterable2)) {
            throw new NullPointerException();
        }
        return iterable2;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T iterable2, Object errorMessage2) {
        if (Preconditions.containsOrIsNull(iterable2)) {
            throw new NullPointerException(String.valueOf(errorMessage2));
        }
        return iterable2;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T iterable2, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (Preconditions.containsOrIsNull(iterable2)) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return iterable2;
    }

    private static boolean containsOrIsNull(Iterable<?> iterable2) {
        if (iterable2 == null) {
            return true;
        }
        if (iterable2 instanceof Collection) {
            Collection collection = (Collection)iterable2;
            try {
                return collection.contains(null);
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        for (Object element2 : iterable2) {
            if (element2 != null) continue;
            return true;
        }
        return false;
    }

    public static void checkElementIndex(int index2, int size2) {
        Preconditions.checkElementIndex(index2, size2, "index");
    }

    public static void checkElementIndex(int index2, int size2, String desc) {
        Preconditions.checkArgument(size2 >= 0, "negative size: %s", size2);
        if (index2 < 0) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must not be negative", desc, index2));
        }
        if (index2 >= size2) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must be less than size (%s)", desc, index2, size2));
        }
    }

    public static void checkPositionIndex(int index2, int size2) {
        Preconditions.checkPositionIndex(index2, size2, "index");
    }

    public static void checkPositionIndex(int index2, int size2, String desc) {
        Preconditions.checkArgument(size2 >= 0, "negative size: %s", size2);
        if (index2 < 0) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must not be negative", desc, index2));
        }
        if (index2 > size2) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must not be greater than size (%s)", desc, index2, size2));
        }
    }

    public static void checkPositionIndexes(int start2, int end, int size2) {
        Preconditions.checkPositionIndex(start2, size2, "start index");
        Preconditions.checkPositionIndex(end, size2, "end index");
        if (end < start2) {
            throw new IndexOutOfBoundsException(Preconditions.format("end index (%s) must not be less than start index (%s)", end, start2));
        }
    }

    static String format(String template, Object ... args2) {
        int placeholderStart;
        StringBuilder builder = new StringBuilder(template.length() + 16 * args2.length);
        int templateStart = 0;
        int i = 0;
        while (i < args2.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args2[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args2.length) {
            builder.append(" [");
            builder.append(args2[i++]);
            while (i < args2.length) {
                builder.append(", ");
                builder.append(args2[i++]);
            }
            builder.append("]");
        }
        return builder.toString();
    }
}

