/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.PrimitiveArrayBuilder;
import java.lang.reflect.Array;
import java.util.HashSet;

public final class ArrayBuilders {
    private BooleanBuilder _booleanBuilder = null;
    private ByteBuilder _byteBuilder = null;
    private ShortBuilder _shortBuilder = null;
    private IntBuilder _intBuilder = null;
    private LongBuilder _longBuilder = null;
    private FloatBuilder _floatBuilder = null;
    private DoubleBuilder _doubleBuilder = null;

    public BooleanBuilder getBooleanBuilder() {
        if (this._booleanBuilder == null) {
            this._booleanBuilder = new BooleanBuilder();
        }
        return this._booleanBuilder;
    }

    public ByteBuilder getByteBuilder() {
        if (this._byteBuilder == null) {
            this._byteBuilder = new ByteBuilder();
        }
        return this._byteBuilder;
    }

    public ShortBuilder getShortBuilder() {
        if (this._shortBuilder == null) {
            this._shortBuilder = new ShortBuilder();
        }
        return this._shortBuilder;
    }

    public IntBuilder getIntBuilder() {
        if (this._intBuilder == null) {
            this._intBuilder = new IntBuilder();
        }
        return this._intBuilder;
    }

    public LongBuilder getLongBuilder() {
        if (this._longBuilder == null) {
            this._longBuilder = new LongBuilder();
        }
        return this._longBuilder;
    }

    public FloatBuilder getFloatBuilder() {
        if (this._floatBuilder == null) {
            this._floatBuilder = new FloatBuilder();
        }
        return this._floatBuilder;
    }

    public DoubleBuilder getDoubleBuilder() {
        if (this._doubleBuilder == null) {
            this._doubleBuilder = new DoubleBuilder();
        }
        return this._doubleBuilder;
    }

    public static Object getArrayComparator(final Object defaultValue2) {
        final int length2 = Array.getLength(defaultValue2);
        final Class<?> defaultValueType = defaultValue2.getClass();
        return new Object(){

            public boolean equals(Object other) {
                if (other == this) {
                    return true;
                }
                if (!ClassUtil.hasClass(other, defaultValueType)) {
                    return false;
                }
                if (Array.getLength(other) != length2) {
                    return false;
                }
                for (int i = 0; i < length2; ++i) {
                    Object value2;
                    Object value1 = Array.get(defaultValue2, i);
                    if (value1 == (value2 = Array.get(other, i)) || value1 == null || value1.equals(value2)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> HashSet<T> arrayToSet(T[] elements2) {
        if (elements2 != null) {
            int len2 = elements2.length;
            HashSet<T> result2 = new HashSet<T>(len2);
            for (int i = 0; i < len2; ++i) {
                result2.add(elements2[i]);
            }
            return result2;
        }
        return new HashSet();
    }

    public static <T> T[] insertInListNoDup(T[] array2, T element2) {
        int len2 = array2.length;
        for (int ix = 0; ix < len2; ++ix) {
            if (array2[ix] != element2) continue;
            if (ix == 0) {
                return array2;
            }
            Object[] result2 = (Object[])Array.newInstance(array2.getClass().getComponentType(), len2);
            System.arraycopy(array2, 0, result2, 1, ix);
            result2[0] = element2;
            int left2 = len2 - ++ix;
            if (left2 > 0) {
                System.arraycopy(array2, ix, result2, ix, left2);
            }
            return result2;
        }
        Object[] result3 = (Object[])Array.newInstance(array2.getClass().getComponentType(), len2 + 1);
        if (len2 > 0) {
            System.arraycopy(array2, 0, result3, 1, len2);
        }
        result3[0] = element2;
        return result3;
    }

    public static final class DoubleBuilder
    extends PrimitiveArrayBuilder<double[]> {
        @Override
        public final double[] _constructArray(int len2) {
            return new double[len2];
        }
    }

    public static final class FloatBuilder
    extends PrimitiveArrayBuilder<float[]> {
        @Override
        public final float[] _constructArray(int len2) {
            return new float[len2];
        }
    }

    public static final class LongBuilder
    extends PrimitiveArrayBuilder<long[]> {
        @Override
        public final long[] _constructArray(int len2) {
            return new long[len2];
        }
    }

    public static final class IntBuilder
    extends PrimitiveArrayBuilder<int[]> {
        @Override
        public final int[] _constructArray(int len2) {
            return new int[len2];
        }
    }

    public static final class ShortBuilder
    extends PrimitiveArrayBuilder<short[]> {
        @Override
        public final short[] _constructArray(int len2) {
            return new short[len2];
        }
    }

    public static final class ByteBuilder
    extends PrimitiveArrayBuilder<byte[]> {
        @Override
        public final byte[] _constructArray(int len2) {
            return new byte[len2];
        }
    }

    public static final class BooleanBuilder
    extends PrimitiveArrayBuilder<boolean[]> {
        @Override
        public final boolean[] _constructArray(int len2) {
            return new boolean[len2];
        }
    }
}

