/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ArrayNode
extends ContainerNode<ArrayNode> {
    private final List<JsonNode> _children;

    public ArrayNode(JsonNodeFactory nf) {
        super(nf);
        this._children = new ArrayList<JsonNode>();
    }

    public ArrayNode(JsonNodeFactory nf, int capacity) {
        super(nf);
        this._children = new ArrayList<JsonNode>(capacity);
    }

    public ArrayNode(JsonNodeFactory nf, List<JsonNode> children2) {
        super(nf);
        this._children = children2;
    }

    @Override
    protected JsonNode _at(JsonPointer ptr) {
        return this.get(ptr.getMatchingIndex());
    }

    public ArrayNode deepCopy() {
        ArrayNode ret = new ArrayNode(this._nodeFactory);
        for (JsonNode element2 : this._children) {
            ret._children.add((JsonNode)element2.deepCopy());
        }
        return ret;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.iterator();
    }

    @Override
    public JsonNode get(int index2) {
        if (index2 >= 0 && index2 < this._children.size()) {
            return this._children.get(index2);
        }
        return null;
    }

    @Override
    public JsonNode get(String fieldName2) {
        return null;
    }

    @Override
    public JsonNode path(String fieldName2) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(int index2) {
        if (index2 >= 0 && index2 < this._children.size()) {
            return this._children.get(index2);
        }
        return MissingNode.getInstance();
    }

    @Override
    public boolean equals(Comparator<JsonNode> comparator, JsonNode o) {
        if (!(o instanceof ArrayNode)) {
            return false;
        }
        ArrayNode other = (ArrayNode)o;
        int len2 = this._children.size();
        if (other.size() != len2) {
            return false;
        }
        List<JsonNode> l1 = this._children;
        List<JsonNode> l2 = other._children;
        for (int i = 0; i < len2; ++i) {
            if (l1.get(i).equals(comparator, l2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void serialize(JsonGenerator f2, SerializerProvider provider) throws IOException {
        List<JsonNode> c = this._children;
        int size2 = c.size();
        f2.writeStartArray(size2);
        for (int i = 0; i < size2; ++i) {
            JsonNode n = c.get(i);
            ((BaseJsonNode)n).serialize(f2, provider);
        }
        f2.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(this, JsonToken.START_ARRAY));
        for (JsonNode n : this._children) {
            ((BaseJsonNode)n).serialize(g, provider);
        }
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode findValue(String fieldName2) {
        for (JsonNode node4 : this._children) {
            JsonNode value2 = node4.findValue(fieldName2);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String fieldName2, List<JsonNode> foundSoFar) {
        for (JsonNode node4 : this._children) {
            foundSoFar = node4.findValues(fieldName2, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public List<String> findValuesAsText(String fieldName2, List<String> foundSoFar) {
        for (JsonNode node4 : this._children) {
            foundSoFar = node4.findValuesAsText(fieldName2, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public ObjectNode findParent(String fieldName2) {
        for (JsonNode node4 : this._children) {
            JsonNode parent2 = node4.findParent(fieldName2);
            if (parent2 == null) continue;
            return (ObjectNode)parent2;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String fieldName2, List<JsonNode> foundSoFar) {
        for (JsonNode node4 : this._children) {
            foundSoFar = node4.findParents(fieldName2, foundSoFar);
        }
        return foundSoFar;
    }

    public JsonNode set(int index2, JsonNode value2) {
        if (value2 == null) {
            value2 = this.nullNode();
        }
        if (index2 < 0 || index2 >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + index2 + ", array size " + this.size());
        }
        return this._children.set(index2, value2);
    }

    public ArrayNode add(JsonNode value2) {
        if (value2 == null) {
            value2 = this.nullNode();
        }
        this._add(value2);
        return this;
    }

    public ArrayNode addAll(ArrayNode other) {
        this._children.addAll(other._children);
        return this;
    }

    public ArrayNode addAll(Collection<? extends JsonNode> nodes2) {
        this._children.addAll(nodes2);
        return this;
    }

    public ArrayNode insert(int index2, JsonNode value2) {
        if (value2 == null) {
            value2 = this.nullNode();
        }
        this._insert(index2, value2);
        return this;
    }

    public JsonNode remove(int index2) {
        if (index2 >= 0 && index2 < this._children.size()) {
            return this._children.remove(index2);
        }
        return null;
    }

    @Override
    public ArrayNode removeAll() {
        this._children.clear();
        return this;
    }

    public ArrayNode addArray() {
        ArrayNode n = this.arrayNode();
        this._add(n);
        return n;
    }

    public ObjectNode addObject() {
        ObjectNode n = this.objectNode();
        this._add(n);
        return n;
    }

    public ArrayNode addPOJO(Object value2) {
        if (value2 == null) {
            this.addNull();
        } else {
            this._add(this.pojoNode(value2));
        }
        return this;
    }

    public ArrayNode addRawValue(RawValue raw2) {
        if (raw2 == null) {
            this.addNull();
        } else {
            this._add(this.rawValueNode(raw2));
        }
        return this;
    }

    public ArrayNode addNull() {
        this._add(this.nullNode());
        return this;
    }

    public ArrayNode add(int v) {
        this._add(this.numberNode(v));
        return this;
    }

    public ArrayNode add(Integer value2) {
        if (value2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((int)value2));
    }

    public ArrayNode add(long v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Long value2) {
        if (value2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((long)value2));
    }

    public ArrayNode add(float v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Float value2) {
        if (value2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(value2.floatValue()));
    }

    public ArrayNode add(double v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Double value2) {
        if (value2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((double)value2));
    }

    public ArrayNode add(BigDecimal v) {
        if (v == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(BigInteger v) {
        if (v == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(String v) {
        if (v == null) {
            return this.addNull();
        }
        return this._add(this.textNode(v));
    }

    public ArrayNode add(boolean v) {
        return this._add(this.booleanNode(v));
    }

    public ArrayNode add(Boolean value2) {
        if (value2 == null) {
            return this.addNull();
        }
        return this._add(this.booleanNode(value2));
    }

    public ArrayNode add(byte[] v) {
        if (v == null) {
            return this.addNull();
        }
        return this._add(this.binaryNode(v));
    }

    public ArrayNode insertArray(int index2) {
        ArrayNode n = this.arrayNode();
        this._insert(index2, n);
        return n;
    }

    public ObjectNode insertObject(int index2) {
        ObjectNode n = this.objectNode();
        this._insert(index2, n);
        return n;
    }

    public ArrayNode insertPOJO(int index2, Object value2) {
        if (value2 == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.pojoNode(value2));
    }

    public ArrayNode insertNull(int index2) {
        this._insert(index2, this.nullNode());
        return this;
    }

    public ArrayNode insert(int index2, int v) {
        this._insert(index2, this.numberNode(v));
        return this;
    }

    public ArrayNode insert(int index2, Integer value2) {
        if (value2 == null) {
            this.insertNull(index2);
        } else {
            this._insert(index2, this.numberNode((int)value2));
        }
        return this;
    }

    public ArrayNode insert(int index2, long v) {
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, Long value2) {
        if (value2 == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.numberNode((long)value2));
    }

    public ArrayNode insert(int index2, float v) {
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, Float value2) {
        if (value2 == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.numberNode(value2.floatValue()));
    }

    public ArrayNode insert(int index2, double v) {
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, Double value2) {
        if (value2 == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.numberNode((double)value2));
    }

    public ArrayNode insert(int index2, BigDecimal v) {
        if (v == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, BigInteger v) {
        if (v == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, String v) {
        if (v == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.textNode(v));
    }

    public ArrayNode insert(int index2, boolean v) {
        return this._insert(index2, this.booleanNode(v));
    }

    public ArrayNode insert(int index2, Boolean value2) {
        if (value2 == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.booleanNode(value2));
    }

    public ArrayNode insert(int index2, byte[] v) {
        if (v == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.binaryNode(v));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ArrayNode) {
            return this._children.equals(((ArrayNode)o)._children);
        }
        return false;
    }

    protected boolean _childrenEqual(ArrayNode other) {
        return this._children.equals(other._children);
    }

    @Override
    public int hashCode() {
        return this._children.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16 + (this.size() << 4));
        sb.append('[');
        int len2 = this._children.size();
        for (int i = 0; i < len2; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this._children.get(i).toString());
        }
        sb.append(']');
        return sb.toString();
    }

    protected ArrayNode _add(JsonNode node4) {
        this._children.add(node4);
        return this;
    }

    protected ArrayNode _insert(int index2, JsonNode node4) {
        if (index2 < 0) {
            this._children.add(0, node4);
        } else if (index2 >= this._children.size()) {
            this._children.add(node4);
        } else {
            this._children.add(index2, node4);
        }
        return this;
    }
}

