/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StdSubtypeResolver
extends SubtypeResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected LinkedHashSet<NamedType> _registeredSubtypes;

    @Override
    public void registerSubtypes(NamedType ... types2) {
        if (this._registeredSubtypes == null) {
            this._registeredSubtypes = new LinkedHashSet();
        }
        for (NamedType type : types2) {
            this._registeredSubtypes.add(type);
        }
    }

    @Override
    public void registerSubtypes(Class<?> ... classes2) {
        NamedType[] types2 = new NamedType[classes2.length];
        int len2 = classes2.length;
        for (int i = 0; i < len2; ++i) {
            types2[i] = new NamedType(classes2[i]);
        }
        this.registerSubtypes(types2);
    }

    @Override
    public void registerSubtypes(Collection<Class<?>> subtypes) {
        int len2 = subtypes.size();
        NamedType[] types2 = new NamedType[len2];
        int i = 0;
        for (Class<?> subtype : subtypes) {
            types2[i++] = new NamedType(subtype);
        }
        this.registerSubtypes(types2);
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypesByClass(MapperConfig<?> config, AnnotatedMember property, JavaType baseType) {
        List<NamedType> st2;
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        Class<?> rawBase = baseType == null ? property.getRawType() : baseType.getRawClass();
        HashMap<NamedType, NamedType> collected = new HashMap<NamedType, NamedType>();
        if (this._registeredSubtypes != null) {
            for (NamedType namedType : this._registeredSubtypes) {
                if (!rawBase.isAssignableFrom(namedType.getType())) continue;
                AnnotatedClass curr = AnnotatedClassResolver.resolveWithoutSuperTypes(config, namedType.getType());
                this._collectAndResolve(curr, namedType, config, ai, collected);
            }
        }
        if (property != null && (st2 = ai.findSubtypes(property)) != null) {
            for (NamedType nt : st2) {
                AnnotatedClass ac = AnnotatedClassResolver.resolveWithoutSuperTypes(config, nt.getType());
                this._collectAndResolve(ac, nt, config, ai, collected);
            }
        }
        NamedType rootType = new NamedType(rawBase, null);
        AnnotatedClass annotatedClass = AnnotatedClassResolver.resolveWithoutSuperTypes(config, rawBase);
        this._collectAndResolve(annotatedClass, rootType, config, ai, collected);
        return new ArrayList<NamedType>(collected.values());
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypesByClass(MapperConfig<?> config, AnnotatedClass type) {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        HashMap<NamedType, NamedType> subtypes = new HashMap<NamedType, NamedType>();
        if (this._registeredSubtypes != null) {
            Class<?> rawBase = type.getRawType();
            for (NamedType subtype : this._registeredSubtypes) {
                if (!rawBase.isAssignableFrom(subtype.getType())) continue;
                AnnotatedClass curr = AnnotatedClassResolver.resolveWithoutSuperTypes(config, subtype.getType());
                this._collectAndResolve(curr, subtype, config, ai, subtypes);
            }
        }
        NamedType rootType = new NamedType(type.getRawType(), null);
        this._collectAndResolve(type, rootType, config, ai, subtypes);
        return new ArrayList<NamedType>(subtypes.values());
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypesByTypeId(MapperConfig<?> config, AnnotatedMember property, JavaType baseType) {
        List<NamedType> st2;
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        Class<?> rawBase = baseType.getRawClass();
        HashSet typesHandled = new HashSet();
        LinkedHashMap<String, NamedType> byName2 = new LinkedHashMap<String, NamedType>();
        NamedType rootType = new NamedType(rawBase, null);
        AnnotatedClass ac = AnnotatedClassResolver.resolveWithoutSuperTypes(config, rawBase);
        this._collectAndResolveByTypeId(ac, rootType, config, typesHandled, byName2);
        if (property != null && (st2 = ai.findSubtypes(property)) != null) {
            for (NamedType nt : st2) {
                ac = AnnotatedClassResolver.resolveWithoutSuperTypes(config, nt.getType());
                this._collectAndResolveByTypeId(ac, nt, config, typesHandled, byName2);
            }
        }
        if (this._registeredSubtypes != null) {
            for (NamedType subtype : this._registeredSubtypes) {
                if (!rawBase.isAssignableFrom(subtype.getType())) continue;
                AnnotatedClass curr = AnnotatedClassResolver.resolveWithoutSuperTypes(config, subtype.getType());
                this._collectAndResolveByTypeId(curr, subtype, config, typesHandled, byName2);
            }
        }
        return this._combineNamedAndUnnamed(rawBase, typesHandled, byName2);
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypesByTypeId(MapperConfig<?> config, AnnotatedClass baseType) {
        Class<?> rawBase = baseType.getRawType();
        HashSet typesHandled = new HashSet();
        LinkedHashMap<String, NamedType> byName2 = new LinkedHashMap<String, NamedType>();
        NamedType rootType = new NamedType(rawBase, null);
        this._collectAndResolveByTypeId(baseType, rootType, config, typesHandled, byName2);
        if (this._registeredSubtypes != null) {
            for (NamedType subtype : this._registeredSubtypes) {
                if (!rawBase.isAssignableFrom(subtype.getType())) continue;
                AnnotatedClass curr = AnnotatedClassResolver.resolveWithoutSuperTypes(config, subtype.getType());
                this._collectAndResolveByTypeId(curr, subtype, config, typesHandled, byName2);
            }
        }
        return this._combineNamedAndUnnamed(rawBase, typesHandled, byName2);
    }

    protected void _collectAndResolve(AnnotatedClass annotatedType, NamedType namedType, MapperConfig<?> config, AnnotationIntrospector ai, HashMap<NamedType, NamedType> collectedSubtypes) {
        String name;
        if (!namedType.hasName() && (name = ai.findTypeName(annotatedType)) != null) {
            namedType = new NamedType(namedType.getType(), name);
        }
        if (collectedSubtypes.containsKey(namedType)) {
            NamedType prev;
            if (namedType.hasName() && !(prev = collectedSubtypes.get(namedType)).hasName()) {
                collectedSubtypes.put(namedType, namedType);
            }
            return;
        }
        collectedSubtypes.put(namedType, namedType);
        List<NamedType> st2 = ai.findSubtypes(annotatedType);
        if (st2 != null && !st2.isEmpty()) {
            for (NamedType subtype : st2) {
                AnnotatedClass subtypeClass = AnnotatedClassResolver.resolveWithoutSuperTypes(config, subtype.getType());
                this._collectAndResolve(subtypeClass, subtype, config, ai, collectedSubtypes);
            }
        }
    }

    protected void _collectAndResolveByTypeId(AnnotatedClass annotatedType, NamedType namedType, MapperConfig<?> config, Set<Class<?>> typesHandled, Map<String, NamedType> byName2) {
        List<NamedType> st2;
        String name;
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        if (!namedType.hasName() && (name = ai.findTypeName(annotatedType)) != null) {
            namedType = new NamedType(namedType.getType(), name);
        }
        if (namedType.hasName()) {
            byName2.put(namedType.getName(), namedType);
        }
        if (typesHandled.add(namedType.getType()) && (st2 = ai.findSubtypes(annotatedType)) != null && !st2.isEmpty()) {
            for (NamedType subtype : st2) {
                AnnotatedClass subtypeClass = AnnotatedClassResolver.resolveWithoutSuperTypes(config, subtype.getType());
                this._collectAndResolveByTypeId(subtypeClass, subtype, config, typesHandled, byName2);
            }
        }
    }

    protected Collection<NamedType> _combineNamedAndUnnamed(Class<?> rawBase, Set<Class<?>> typesHandled, Map<String, NamedType> byName2) {
        ArrayList<NamedType> result2 = new ArrayList<NamedType>(byName2.values());
        for (NamedType namedType : byName2.values()) {
            typesHandled.remove(namedType.getType());
        }
        for (Class clazz2 : typesHandled) {
            if (clazz2 == rawBase && Modifier.isAbstract(clazz2.getModifiers())) continue;
            result2.add(new NamedType(clazz2));
        }
        return result2;
    }
}

