/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethodMap;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.CollectorBase;
import com.fasterxml.jackson.databind.introspect.MemberKey;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AnnotatedMethodCollector
extends CollectorBase {
    private final ClassIntrospector.MixInResolver _mixInResolver;

    AnnotatedMethodCollector(AnnotationIntrospector intr, ClassIntrospector.MixInResolver mixins) {
        super(intr);
        this._mixInResolver = intr == null ? null : mixins;
    }

    public static AnnotatedMethodMap collectMethods(AnnotationIntrospector intr, TypeResolutionContext tc, ClassIntrospector.MixInResolver mixins, TypeFactory types2, JavaType type, List<JavaType> superTypes, Class<?> primaryMixIn) {
        return new AnnotatedMethodCollector(intr, mixins).collect(types2, tc, type, superTypes, primaryMixIn);
    }

    AnnotatedMethodMap collect(TypeFactory typeFactory, TypeResolutionContext tc, JavaType mainType, List<JavaType> superTypes, Class<?> primaryMixIn) {
        Object mixin;
        LinkedHashMap<MemberKey, MethodBuilder> methods2 = new LinkedHashMap<MemberKey, MethodBuilder>();
        this._addMemberMethods(tc, mainType.getRawClass(), methods2, primaryMixIn);
        for (JavaType type : superTypes) {
            Class<?> clazz2 = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(type.getRawClass());
            this._addMemberMethods(new TypeResolutionContext.Basic(typeFactory, type.getBindings()), type.getRawClass(), methods2, clazz2);
        }
        boolean checkJavaLangObject = false;
        if (this._mixInResolver != null && (mixin = this._mixInResolver.findMixInClassFor(Object.class)) != null) {
            this._addMethodMixIns(tc, mainType.getRawClass(), (Map<MemberKey, MethodBuilder>)methods2, (Class<?>)mixin);
            checkJavaLangObject = true;
        }
        if (checkJavaLangObject && this._intr != null && !methods2.isEmpty()) {
            for (Map.Entry entry2 : methods2.entrySet()) {
                MemberKey k = (MemberKey)entry2.getKey();
                if (!"hashCode".equals(k.getName()) || 0 != k.argCount()) continue;
                try {
                    Method m = Object.class.getDeclaredMethod(k.getName(), new Class[0]);
                    if (m == null) continue;
                    MethodBuilder b2 = (MethodBuilder)entry2.getValue();
                    b2.annotations = this.collectDefaultAnnotations(b2.annotations, m.getDeclaredAnnotations());
                    b2.method = m;
                }
                catch (Exception m) {}
            }
        }
        if (methods2.isEmpty()) {
            return new AnnotatedMethodMap();
        }
        LinkedHashMap<MemberKey, AnnotatedMethod> actual = new LinkedHashMap<MemberKey, AnnotatedMethod>(methods2.size());
        for (Map.Entry entry3 : methods2.entrySet()) {
            AnnotatedMethod am = ((MethodBuilder)entry3.getValue()).build();
            if (am == null) continue;
            actual.put((MemberKey)entry3.getKey(), am);
        }
        return new AnnotatedMethodMap(actual);
    }

    private void _addMemberMethods(TypeResolutionContext tc, Class<?> cls, Map<MemberKey, MethodBuilder> methods2, Class<?> mixInCls) {
        if (mixInCls != null) {
            this._addMethodMixIns(tc, cls, methods2, mixInCls);
        }
        if (cls == null) {
            return;
        }
        for (Method m : ClassUtil.getClassMethods(cls)) {
            Method old;
            if (!this._isIncludableMemberMethod(m)) continue;
            MemberKey key = new MemberKey(m);
            MethodBuilder b2 = methods2.get(key);
            if (b2 == null) {
                AnnotationCollector c = this._intr == null ? AnnotationCollector.emptyCollector() : this.collectAnnotations(m.getDeclaredAnnotations());
                methods2.put(key, new MethodBuilder(tc, m, c));
                continue;
            }
            if (this._intr != null) {
                b2.annotations = this.collectDefaultAnnotations(b2.annotations, m.getDeclaredAnnotations());
            }
            if ((old = b2.method) == null) {
                b2.method = m;
                continue;
            }
            if (!Modifier.isAbstract(old.getModifiers()) || Modifier.isAbstract(m.getModifiers())) continue;
            b2.method = m;
            b2.typeContext = tc;
        }
    }

    protected void _addMethodMixIns(TypeResolutionContext tc, Class<?> targetClass, Map<MemberKey, MethodBuilder> methods2, Class<?> mixInCls) {
        if (this._intr == null) {
            return;
        }
        for (Class<?> mixin : ClassUtil.findRawSuperTypes(mixInCls, targetClass, true)) {
            for (Method m : ClassUtil.getDeclaredMethods(mixin)) {
                if (!this._isIncludableMemberMethod(m)) continue;
                MemberKey key = new MemberKey(m);
                MethodBuilder b2 = methods2.get(key);
                Annotation[] anns = m.getDeclaredAnnotations();
                if (b2 == null) {
                    methods2.put(key, new MethodBuilder(tc, null, this.collectAnnotations(anns)));
                    continue;
                }
                b2.annotations = this.collectDefaultAnnotations(b2.annotations, anns);
            }
        }
    }

    private boolean _isIncludableMemberMethod(Method m) {
        if (Modifier.isStatic(m.getModifiers()) || m.isSynthetic() || m.isBridge()) {
            return false;
        }
        int pcount = m.getParameterTypes().length;
        return pcount <= 2;
    }

    private static final class MethodBuilder {
        public TypeResolutionContext typeContext;
        public Method method;
        public AnnotationCollector annotations;

        public MethodBuilder(TypeResolutionContext tc, Method m, AnnotationCollector ann) {
            this.typeContext = tc;
            this.method = m;
            this.annotations = ann;
        }

        public AnnotatedMethod build() {
            if (this.method == null) {
                return null;
            }
            return new AnnotatedMethod(this.typeContext, this.method, this.annotations.asAnnotationMap(), null);
        }
    }
}

