/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class COWArrayList<E>
implements List<E> {
    AtomicBoolean fresh = new AtomicBoolean(false);
    CopyOnWriteArrayList<E> underlyingList = new CopyOnWriteArrayList();
    E[] ourCopy;
    final E[] modelArray;

    public COWArrayList(E[] modelArray) {
        this.modelArray = modelArray;
    }

    @Override
    public int size() {
        return this.underlyingList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.underlyingList.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.underlyingList.iterator();
    }

    private void refreshCopyIfNecessary() {
        if (!this.isFresh()) {
            this.refreshCopy();
        }
    }

    private boolean isFresh() {
        return this.fresh.get();
    }

    private void refreshCopy() {
        this.ourCopy = this.underlyingList.toArray(this.modelArray);
        this.fresh.set(true);
    }

    @Override
    public Object[] toArray() {
        this.refreshCopyIfNecessary();
        return this.ourCopy;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        this.refreshCopyIfNecessary();
        return this.ourCopy;
    }

    public E[] asTypedArray() {
        this.refreshCopyIfNecessary();
        return this.ourCopy;
    }

    private void markAsStale() {
        this.fresh.set(false);
    }

    public void addIfAbsent(E e) {
        this.underlyingList.addIfAbsent(e);
        this.markAsStale();
    }

    @Override
    public boolean add(E e) {
        boolean result2 = this.underlyingList.add(e);
        this.markAsStale();
        return result2;
    }

    @Override
    public boolean remove(Object o) {
        boolean result2 = this.underlyingList.remove(o);
        this.markAsStale();
        return result2;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.underlyingList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result2 = this.underlyingList.addAll(c);
        this.markAsStale();
        return result2;
    }

    @Override
    public boolean addAll(int index2, Collection<? extends E> col) {
        boolean result2 = this.underlyingList.addAll(index2, col);
        this.markAsStale();
        return result2;
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        boolean result2 = this.underlyingList.removeAll(col);
        this.markAsStale();
        return result2;
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        boolean result2 = this.underlyingList.retainAll(col);
        this.markAsStale();
        return result2;
    }

    @Override
    public void clear() {
        this.underlyingList.clear();
        this.markAsStale();
    }

    @Override
    public E get(int index2) {
        this.refreshCopyIfNecessary();
        return this.ourCopy[index2];
    }

    @Override
    public E set(int index2, E element2) {
        E e = this.underlyingList.set(index2, element2);
        this.markAsStale();
        return e;
    }

    @Override
    public void add(int index2, E element2) {
        this.underlyingList.add(index2, element2);
        this.markAsStale();
    }

    @Override
    public E remove(int index2) {
        E e = this.underlyingList.remove(index2);
        this.markAsStale();
        return e;
    }

    @Override
    public int indexOf(Object o) {
        return this.underlyingList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.underlyingList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.underlyingList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index2) {
        return this.underlyingList.listIterator(index2);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.underlyingList.subList(fromIndex, toIndex);
    }
}

