/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util.beans;

import java.lang.reflect.Method;

public class BeanUtil {
    public static final String PREFIX_GETTER_IS = "is";
    public static final String PREFIX_GETTER_GET = "get";
    public static final String PREFIX_SETTER = "set";
    public static final String PREFIX_ADDER = "add";

    public static boolean isAdder(Method method2) {
        int parameterCount = BeanUtil.getParameterCount(method2);
        if (parameterCount != 1) {
            return false;
        }
        Class<?> returnType = method2.getReturnType();
        if (returnType != Void.TYPE) {
            return false;
        }
        String methodName = method2.getName();
        return methodName.startsWith(PREFIX_ADDER);
    }

    public static boolean isGetter(Method method2) {
        int parameterCount = BeanUtil.getParameterCount(method2);
        if (parameterCount > 0) {
            return false;
        }
        Class<?> returnType = method2.getReturnType();
        if (returnType == Void.TYPE) {
            return false;
        }
        String methodName = method2.getName();
        if (!methodName.startsWith(PREFIX_GETTER_GET) && !methodName.startsWith(PREFIX_GETTER_IS)) {
            return false;
        }
        return !methodName.startsWith(PREFIX_GETTER_IS) || returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class);
    }

    private static int getParameterCount(Method method2) {
        return method2.getParameterTypes().length;
    }

    public static boolean isSetter(Method method2) {
        int parameterCount = BeanUtil.getParameterCount(method2);
        if (parameterCount != 1) {
            return false;
        }
        Class<?> returnType = method2.getReturnType();
        if (returnType != Void.TYPE) {
            return false;
        }
        String methodName = method2.getName();
        return methodName.startsWith(PREFIX_SETTER);
    }

    public static String getPropertyName(Method method2) {
        String methodName = method2.getName();
        String rawPropertyName = BeanUtil.getSubstringIfPrefixMatches(methodName, PREFIX_GETTER_GET);
        if (rawPropertyName == null) {
            rawPropertyName = BeanUtil.getSubstringIfPrefixMatches(methodName, PREFIX_SETTER);
        }
        if (rawPropertyName == null) {
            rawPropertyName = BeanUtil.getSubstringIfPrefixMatches(methodName, PREFIX_GETTER_IS);
        }
        if (rawPropertyName == null) {
            rawPropertyName = BeanUtil.getSubstringIfPrefixMatches(methodName, PREFIX_ADDER);
        }
        return BeanUtil.toLowerCamelCase(rawPropertyName);
    }

    public static String toLowerCamelCase(String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.isEmpty()) {
            return string2;
        }
        if (string2.length() > 1 && Character.isUpperCase(string2.charAt(1)) && Character.isUpperCase(string2.charAt(0))) {
            return string2;
        }
        char[] chars = string2.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static String getSubstringIfPrefixMatches(String wholeString, String prefix) {
        if (wholeString.startsWith(prefix)) {
            return wholeString.substring(prefix.length());
        }
        return null;
    }
}

