/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.xml.sax.Attributes;

public class PropertyAction
extends Action {
    static final String RESOURCE_ATTRIBUTE = "resource";
    static String INVALID_ATTRIBUTES = "In <property> element, either the \"file\" attribute alone, or the \"resource\" element alone, or both the \"name\" and \"value\" attributes must be set.";

    @Override
    public void begin(InterpretationContext ec, String localName, Attributes attributes2) {
        if ("substitutionProperty".equals(localName)) {
            this.addWarn("[substitutionProperty] element has been deprecated. Please use the [property] element instead.");
        }
        String name = attributes2.getValue("name");
        String value2 = attributes2.getValue("value");
        String scopeStr = attributes2.getValue("scope");
        ActionUtil.Scope scope2 = ActionUtil.stringToScope(scopeStr);
        if (this.checkFileAttributeSanity(attributes2)) {
            String file = attributes2.getValue("file");
            file = ec.subst(file);
            try {
                FileInputStream istream = new FileInputStream(file);
                this.loadAndSetProperties(ec, istream, scope2);
            }
            catch (FileNotFoundException e) {
                this.addError("Could not find properties file [" + file + "].");
            }
            catch (IOException e1) {
                this.addError("Could not read properties file [" + file + "].", e1);
            }
        } else if (this.checkResourceAttributeSanity(attributes2)) {
            String resource = attributes2.getValue(RESOURCE_ATTRIBUTE);
            URL resourceURL = Loader.getResourceBySelfClassLoader(resource = ec.subst(resource));
            if (resourceURL == null) {
                this.addError("Could not find resource [" + resource + "].");
            } else {
                try {
                    InputStream istream = resourceURL.openStream();
                    this.loadAndSetProperties(ec, istream, scope2);
                }
                catch (IOException e) {
                    this.addError("Could not read resource file [" + resource + "].", e);
                }
            }
        } else if (this.checkValueNameAttributesSanity(attributes2)) {
            value2 = RegularEscapeUtil.basicEscape(value2);
            value2 = value2.trim();
            value2 = ec.subst(value2);
            ActionUtil.setProperty(ec, name, value2, scope2);
        } else {
            this.addError(INVALID_ATTRIBUTES);
        }
    }

    void loadAndSetProperties(InterpretationContext ec, InputStream istream, ActionUtil.Scope scope2) throws IOException {
        Properties props2 = new Properties();
        props2.load(istream);
        istream.close();
        ActionUtil.setProperties(ec, props2, scope2);
    }

    boolean checkFileAttributeSanity(Attributes attributes2) {
        String file = attributes2.getValue("file");
        String name = attributes2.getValue("name");
        String value2 = attributes2.getValue("value");
        String resource = attributes2.getValue(RESOURCE_ATTRIBUTE);
        return !OptionHelper.isEmpty(file) && OptionHelper.isEmpty(name) && OptionHelper.isEmpty(value2) && OptionHelper.isEmpty(resource);
    }

    boolean checkResourceAttributeSanity(Attributes attributes2) {
        String file = attributes2.getValue("file");
        String name = attributes2.getValue("name");
        String value2 = attributes2.getValue("value");
        String resource = attributes2.getValue(RESOURCE_ATTRIBUTE);
        return !OptionHelper.isEmpty(resource) && OptionHelper.isEmpty(name) && OptionHelper.isEmpty(value2) && OptionHelper.isEmpty(file);
    }

    boolean checkValueNameAttributesSanity(Attributes attributes2) {
        String file = attributes2.getValue("file");
        String name = attributes2.getValue("name");
        String value2 = attributes2.getValue("value");
        String resource = attributes2.getValue(RESOURCE_ATTRIBUTE);
        return !OptionHelper.isEmpty(name) && !OptionHelper.isEmpty(value2) && OptionHelper.isEmpty(file) && OptionHelper.isEmpty(resource);
    }

    @Override
    public void end(InterpretationContext ec, String name) {
    }

    public void finish(InterpretationContext ec) {
    }
}

