/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Properties;

public class ActionUtil {
    public static Scope stringToScope(String scopeStr) {
        if (Scope.SYSTEM.toString().equalsIgnoreCase(scopeStr)) {
            return Scope.SYSTEM;
        }
        if (Scope.CONTEXT.toString().equalsIgnoreCase(scopeStr)) {
            return Scope.CONTEXT;
        }
        return Scope.LOCAL;
    }

    public static void setProperty(InterpretationContext ic, String key, String value2, Scope scope2) {
        switch (scope2) {
            case LOCAL: {
                ic.addSubstitutionProperty(key, value2);
                break;
            }
            case CONTEXT: {
                ic.getContext().putProperty(key, value2);
                break;
            }
            case SYSTEM: {
                OptionHelper.setSystemProperty(ic, key, value2);
            }
        }
    }

    public static void setProperties(InterpretationContext ic, Properties props2, Scope scope2) {
        switch (scope2) {
            case LOCAL: {
                ic.addSubstitutionProperties(props2);
                break;
            }
            case CONTEXT: {
                ContextUtil cu = new ContextUtil(ic.getContext());
                cu.addProperties(props2);
                break;
            }
            case SYSTEM: {
                OptionHelper.setSystemProperties(ic, props2);
            }
        }
    }

    public static enum Scope {
        LOCAL,
        CONTEXT,
        SYSTEM;

    }
}

