/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.scaladsl;

import akka.event.Logging$;
import akka.pattern.BackoffSupervisor$;
import akka.stream.Inlet;
import akka.stream.Outlet;
import akka.stream.Shape;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.InHandler$class;
import akka.stream.stage.OutHandler;
import akka.stream.stage.OutHandler$class;
import akka.stream.stage.TimerGraphStageLogicWithLogging;
import scala.Predef$;
import scala.StringContext;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc!B\u0001\u0003\u0003\u0013I!a\u0006*fgR\f'\u000f^,ji\"\u0014\u0015mY6pM\u001adunZ5d\u0015\t\u0019A!\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0002\u000f\u0005!\u0011m[6b\u0007\u0001)\"AC\u0011\u0014\u0005\u0001Y\u0001C\u0001\u0007\u0010\u001b\u0005i!B\u0001\b\u0005\u0003\u0015\u0019H/Y4f\u0013\t\u0001RBA\u0010US6,'o\u0012:ba\"\u001cF/Y4f\u0019><\u0017nY,ji\"dunZ4j]\u001eD\u0001B\u0005\u0001\u0003\u0002\u0003\u0006IaE\u0001\u0005]\u0006lW\r\u0005\u0002\u001559\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\u00051\u0001K]3eK\u001aL!a\u0007\u000f\u0003\rM#(/\u001b8h\u0015\tIb\u0003\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0003\u0015\u0019\b.\u00199f!\t\u0001\u0013\u0005\u0004\u0001\u0005\u000b\t\u0002!\u0019A\u0012\u0003\u0003M\u000b\"\u0001J\u0014\u0011\u0005U)\u0013B\u0001\u0014\u0017\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001K\u0015\u000e\u0003\u0011I!A\u000b\u0003\u0003\u000bMC\u0017\r]3\t\u00111\u0002!\u0011!Q\u0001\n5\n!\"\\5o\u0005\u0006\u001c7n\u001c4g!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0005ekJ\fG/[8o\u0015\t\u0011d#\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001N\u0018\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"Aa\u0007\u0001B\u0001B\u0003%Q&\u0001\u0006nCb\u0014\u0015mY6pM\u001aD\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!O\u0001\re\u0006tGm\\7GC\u000e$xN\u001d\t\u0003+iJ!a\u000f\f\u0003\r\u0011{WO\u00197f\u0011!i\u0004A!A!\u0002\u0013q\u0014AD8oYf|eNR1jYV\u0014Xm\u001d\t\u0003+}J!\u0001\u0011\f\u0003\u000f\t{w\u000e\\3b]\"A!\t\u0001B\u0001B\u0003%1)A\u0006nCb\u0014Vm\u001d;beR\u001c\bCA\u000bE\u0013\t)eCA\u0002J]RDQa\u0012\u0001\u0005\u0002!\u000ba\u0001P5oSRtD\u0003C%L\u00196su\nU)\u0011\u0007)\u0003q$D\u0001\u0003\u0011\u0015\u0011b\t1\u0001\u0014\u0011\u0015qb\t1\u0001 \u0011\u0015ac\t1\u0001.\u0011\u00151d\t1\u0001.\u0011\u0015Ad\t1\u0001:\u0011\u0015id\t1\u0001?\u0011\u0015\u0011e\t1\u0001D\u0011\u001d\u0019\u0006\u00011A\u0005\u0002Q\u000bAB]3ti\u0006\u0014HoQ8v]R,\u0012a\u0011\u0005\b-\u0002\u0001\r\u0011\"\u0001X\u0003A\u0011Xm\u001d;beR\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002Y7B\u0011Q#W\u0005\u00035Z\u0011A!\u00168ji\"9A,VA\u0001\u0002\u0004\u0019\u0015a\u0001=%c!1a\f\u0001Q!\n\r\u000bQB]3ti\u0006\u0014HoQ8v]R\u0004\u0003b\u00021\u0001\u0001\u0004%\t!Y\u0001\u000ee\u0016\u001cX\r\u001e#fC\u0012d\u0017N\\3\u0016\u0003\t\u0004\"AL2\n\u0005\u0011|#\u0001\u0003#fC\u0012d\u0017N\\3\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\u0006\t\"/Z:fi\u0012+\u0017\r\u001a7j]\u0016|F%Z9\u0015\u0005aC\u0007b\u0002/f\u0003\u0003\u0005\rA\u0019\u0005\u0007U\u0002\u0001\u000b\u0015\u00022\u0002\u001dI,7/\u001a;EK\u0006$G.\u001b8fA!9A\u000e\u0001a\u0001\n\u0003i\u0017!\u00034j]&\u001c\b.\u001b8h+\u0005q\u0004bB8\u0001\u0001\u0004%\t\u0001]\u0001\u000eM&t\u0017n\u001d5j]\u001e|F%Z9\u0015\u0005a\u000b\bb\u0002/o\u0003\u0003\u0005\rA\u0010\u0005\u0007g\u0002\u0001\u000b\u0015\u0002 \u0002\u0015\u0019Lg.[:iS:<\u0007\u0005C\u0003v\u0001\u0019Ea/\u0001\u0006ti\u0006\u0014Ho\u0012:ba\"$\u0012\u0001\u0017\u0005\u0006q\u00021\tB^\u0001\bE\u0006\u001c7n\u001c4g\u0011\u0015Q\b\u0001\"\u0006|\u00039\u0019'/Z1uKN+(-\u00138mKR,2\u0001`A\u0005)\ri\u0018Q\u0003\t\u0005}~\f9!D\u0001\u0001\u0013\u0011\t\t!a\u0001\u0003\u0019M+(mU5oW&sG.\u001a;\n\u0007\u0005\u0015QBA\bHe\u0006\u0004\bn\u0015;bO\u0016dunZ5d!\r\u0001\u0013\u0011\u0002\u0003\b\u0003\u0017I(\u0019AA\u0007\u0005\u0005!\u0016c\u0001\u0013\u0002\u0010A\u0019Q#!\u0005\n\u0007\u0005MaCA\u0002B]fDq!a\u0006z\u0001\u0004\tI\"A\u0002pkR\u0004R\u0001KA\u000e\u0003\u000fI1!!\b\u0005\u0005\u0019yU\u000f\u001e7fi\"9\u0011\u0011\u0005\u0001\u0005\u0016\u0005\r\u0012aD2sK\u0006$XmU;c\u001fV$H.\u001a;\u0016\t\u0005\u0015\u0012q\u0006\u000b\u0005\u0003O\t\t\u0004E\u0003\u007f\u0003S\ti#\u0003\u0003\u0002,\u0005\r!aD*vEN{WO]2f\u001fV$H.\u001a;\u0011\u0007\u0001\ny\u0003\u0002\u0005\u0002\f\u0005}!\u0019AA\u0007\u0011!\t\u0019$a\bA\u0002\u0005U\u0012AA5o!\u0015A\u0013qGA\u0017\u0013\r\tI\u0004\u0002\u0002\u0006\u0013:dW\r\u001e\u0005\b\u0003{\u0001AQCA \u0003Ii\u0017\r\u001f*fgR\f'\u000f^:SK\u0006\u001c\u0007.\u001a3\u0015\u0003yBa!a\u0011\u0001\t+1\u0018\u0001F:dQ\u0016$W\u000f\\3SKN$\u0018M\u001d;US6,'\u000fC\u0004\u0002H\u0001!\t&!\u0013\u0002\u000f=tG+[7feR\u0019\u0001,a\u0013\t\u0011\u00055\u0013Q\ta\u0001\u0003\u001f\t\u0001\u0002^5nKJ\\U-\u001f\u0005\u0007\u0003#\u0002A\u0011\t<\u0002\u0011A\u0014Xm\u0015;beR\u0004")
public abstract class RestartWithBackoffLogic<S extends Shape>
extends TimerGraphStageLogicWithLogging {
    private final String name;
    private final FiniteDuration minBackoff;
    private final FiniteDuration maxBackoff;
    private final double randomFactor;
    public final boolean akka$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures;
    private final int maxRestarts;
    private int restartCount;
    private Deadline resetDeadline;
    private boolean finishing;

    public int restartCount() {
        return this.restartCount;
    }

    public void restartCount_$eq(int x$1) {
        this.restartCount = x$1;
    }

    public Deadline resetDeadline() {
        return this.resetDeadline;
    }

    public void resetDeadline_$eq(Deadline x$1) {
        this.resetDeadline = x$1;
    }

    public boolean finishing() {
        return this.finishing;
    }

    public void finishing_$eq(boolean x$1) {
        this.finishing = x$1;
    }

    public abstract void startGraph();

    public abstract void backoff();

    /*
     * WARNING - void declaration
     */
    public final <T> GraphStageLogic.SubSinkInlet<T> createSubInlet(Outlet<T> out) {
        void var2_2;
        GraphStageLogic.SubSinkInlet sinkIn = new GraphStageLogic.SubSinkInlet(this, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RestartWithBackoff", ".subIn"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name})));
        sinkIn.setHandler(new InHandler(this, out, sinkIn){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final Outlet out$1;
            private final GraphStageLogic.SubSinkInlet sinkIn$1;

            public void onPush() {
                this.$outer.push(this.out$1, this.sinkIn$1.grab());
            }

            public void onUpstreamFinish() {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached() || this.$outer.akka$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures) {
                    this.$outer.complete(this.out$1);
                } else {
                    this.$outer.scheduleRestartTimer();
                }
            }

            public void onUpstreamFailure(Throwable ex) {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached()) {
                    this.$outer.fail(this.out$1, ex);
                } else {
                    this.$outer.log().warning("Restarting graph due to failure. stack_trace: {}", Logging$.MODULE$.stackTraceFor(ex));
                    this.$outer.scheduleRestartTimer();
                }
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.out$1 = out$1;
                this.sinkIn$1 = var3_3;
                InHandler$class.$init$(this);
            }
        });
        this.setHandler(out, new OutHandler(this, sinkIn){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final GraphStageLogic.SubSinkInlet sinkIn$1;

            public void onPull() {
                this.sinkIn$1.pull();
            }

            public void onDownstreamFinish() {
                this.$outer.finishing_$eq(true);
                this.sinkIn$1.cancel();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sinkIn$1 = sinkIn$1;
                OutHandler$class.$init$(this);
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> GraphStageLogic.SubSourceOutlet<T> createSubOutlet(Inlet<T> in2) {
        void var2_2;
        GraphStageLogic.SubSourceOutlet sourceOut = new GraphStageLogic.SubSourceOutlet(this, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RestartWithBackoff", ".subOut"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name})));
        sourceOut.setHandler(new OutHandler(this, in2, sourceOut){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final Inlet in$1;
            private final GraphStageLogic.SubSourceOutlet sourceOut$1;

            public void onPull() {
                if (this.$outer.isAvailable(this.in$1)) {
                    this.sourceOut$1.push(this.$outer.grab(this.in$1));
                } else if (!this.$outer.hasBeenPulled(this.in$1)) {
                    this.$outer.pull(this.in$1);
                }
            }

            public void onDownstreamFinish() {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached() || this.$outer.akka$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures) {
                    this.$outer.cancel(this.in$1);
                } else {
                    this.$outer.scheduleRestartTimer();
                }
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.in$1 = in$1;
                this.sourceOut$1 = var3_3;
                OutHandler$class.$init$(this);
            }
        });
        this.setHandler(in2, new InHandler(this, in2, sourceOut){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final Inlet in$1;
            private final GraphStageLogic.SubSourceOutlet sourceOut$1;

            public void onPush() {
                if (this.sourceOut$1.isAvailable()) {
                    this.sourceOut$1.push(this.$outer.grab(this.in$1));
                }
            }

            public void onUpstreamFinish() {
                this.$outer.finishing_$eq(true);
                this.sourceOut$1.complete();
            }

            public void onUpstreamFailure(Throwable ex) {
                this.$outer.finishing_$eq(true);
                this.sourceOut$1.fail(ex);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.in$1 = in$1;
                this.sourceOut$1 = var3_3;
                InHandler$class.$init$(this);
            }
        });
        return var2_2;
    }

    public final boolean maxRestartsReached() {
        if (this.resetDeadline().isOverdue()) {
            this.log().debug("Last restart attempt was more than {} ago, resetting restart count", this.minBackoff);
            this.restartCount_$eq(0);
        }
        return this.restartCount() == this.maxRestarts;
    }

    public final void scheduleRestartTimer() {
        FiniteDuration restartDelay = BackoffSupervisor$.MODULE$.calculateDelay(this.restartCount(), this.minBackoff, this.maxBackoff, this.randomFactor);
        this.log().debug("Restarting graph in {}", restartDelay);
        this.scheduleOnce((Object)"RestartTimer", restartDelay);
        this.restartCount_$eq(this.restartCount() + 1);
        this.backoff();
    }

    @Override
    public void onTimer(Object timerKey) {
        this.startGraph();
        this.resetDeadline_$eq(this.minBackoff.fromNow());
    }

    @Override
    public void preStart() {
        this.startGraph();
    }

    public RestartWithBackoffLogic(String name, S shape, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, boolean onlyOnFailures, int maxRestarts) {
        this.name = name;
        this.minBackoff = minBackoff;
        this.maxBackoff = maxBackoff;
        this.randomFactor = randomFactor;
        this.akka$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures = onlyOnFailures;
        this.maxRestarts = maxRestarts;
        super((Shape)shape);
        this.restartCount = 0;
        this.resetDeadline = minBackoff.fromNow();
        this.finishing = false;
    }
}

