/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.stream.impl.io.OutputStreamSourceStage;
import akka.stream.impl.io.OutputStreamSourceStage$Close$;
import akka.stream.stage.AsyncCallback;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import scala.Option;
import scala.Predef$;
import scala.concurrent.Await$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric$IntIsIntegral$;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001y4Q!\u0001\u0002\u0001\u0011)\u00111cT;uaV$8\u000b\u001e:fC6\fE-\u00199uKJT!a\u0001\u0003\u0002\u0005%|'BA\u0003\u0007\u0003\u0011IW\u000e\u001d7\u000b\u0005\u001dA\u0011AB:ue\u0016\fWNC\u0001\n\u0003\u0011\t7n[1\u0014\u0005\u0001Y\u0001C\u0001\u0007\u0011\u001b\u0005i!BA\u0002\u000f\u0015\u0005y\u0011\u0001\u00026bm\u0006L!!E\u0007\u0003\u0019=+H\u000f];u'R\u0014X-Y7\t\u0011M\u0001!\u0011!Q\u0001\nU\t\u0011#\u001e8gk24\u0017\u000e\u001c7fI\u0012+W.\u00198e\u0007\u0001\u0001\"AF\u000e\u000e\u0003]Q!\u0001G\r\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\u001b\u001d\u0005!Q\u000f^5m\u0013\tarCA\u0005TK6\f\u0007\u000f[8sK\"Aa\u0004\u0001B\u0001B\u0003%q$A\u0006tK:$Gk\\*uC\u001e,\u0007c\u0001\u0011$K5\t\u0011E\u0003\u0002#\r\u0005)1\u000f^1hK&\u0011A%\t\u0002\u000e\u0003NLhnY\"bY2\u0014\u0017mY6\u0011\u0005\u0019\"dBA\u00143\u001d\tA\u0013G\u0004\u0002*a9\u0011!f\f\b\u0003W9j\u0011\u0001\f\u0006\u0003[Q\ta\u0001\u0010:p_Rt\u0014\"A\u0005\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A!\u0003\u00024\u0005\u00059r*\u001e;qkR\u001cFO]3b[N{WO]2f'R\fw-Z\u0005\u0003kY\u0012Q#\u00113baR,'\u000fV8Ti\u0006<W-T3tg\u0006<WM\u0003\u00024\u0005!A\u0001\b\u0001B\u0001B\u0003%\u0011(\u0001\u0007xe&$X\rV5nK>,H\u000f\u0005\u0002;\u00016\t1H\u0003\u0002={\u0005AA-\u001e:bi&|gN\u0003\u0002\u0019})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002Bw\tqa)\u001b8ji\u0016$UO]1uS>t\u0007\"B\"\u0001\t\u0003!\u0015A\u0002\u001fj]&$h\b\u0006\u0003F\u000f\"K\u0005C\u0001$\u0001\u001b\u0005\u0011\u0001\"B\nC\u0001\u0004)\u0002\"\u0002\u0010C\u0001\u0004y\u0002\"\u0002\u001dC\u0001\u0004I\u0004BB&\u0001A\u0013%A*\u0001\u0005tK:$G)\u0019;b)\ti\u0015\u000b\u0005\u0002O\u001f6\ta(\u0003\u0002Q}\t!QK\\5u\u0011\u0015\u0011&\n1\u0001T\u0003\u0011!\u0017\r^1\u0011\u0005Q3V\"A+\u000b\u0005iA\u0011BA,V\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\u0015\u0004\u0015f{\u0006c\u0001([9&\u00111L\u0010\u0002\u0007i\"\u0014xn^:\u0011\u00051i\u0016B\u00010\u000e\u0005-Iu*\u0012=dKB$\u0018n\u001c8$\u0003qCQ!\u0019\u0001\u0005B\t\fQa\u001e:ji\u0016$\"!T2\t\u000b\u0011\u0004\u0007\u0019A3\u0002\u0003\t\u0004\"A\u00144\n\u0005\u001dt$aA%oi\"\u001a\u0001-W0\t\u000b\u0005\u0004A\u0011\t6\u0015\t5['\u000f\u001e\u0005\u0006I&\u0004\r\u0001\u001c\t\u0004\u001d6|\u0017B\u00018?\u0005\u0015\t%O]1z!\tq\u0005/\u0003\u0002r}\t!!)\u001f;f\u0011\u0015\u0019\u0018\u000e1\u0001f\u0003\rygM\u001a\u0005\u0006k&\u0004\r!Z\u0001\u0004Y\u0016t\u0007fA5Z?\")\u0001\u0010\u0001C!s\u0006)a\r\\;tQR\tQ\nK\u0002x3~CQ\u0001 \u0001\u0005Be\fQa\u00197pg\u0016D3a_-`\u0001")
public class OutputStreamAdapter
extends OutputStream {
    private final Semaphore unfulfilledDemand;
    private final AsyncCallback<OutputStreamSourceStage.AdapterToStageMessage> sendToStage;
    private final FiniteDuration writeTimeout;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendData(ByteString data) throws IOException {
        if (!this.unfulfilledDemand.tryAcquire(this.writeTimeout.toMillis(), TimeUnit.MILLISECONDS)) throw new IOException("Timed out trying to write data to stream");
        try {
            Await$.MODULE$.result(this.sendToStage.invokeWithFeedback(new OutputStreamSourceStage.Send(data)), this.writeTimeout);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable3);
            if (option2.isEmpty()) {
                throw throwable2;
            }
            Throwable e = option2.get();
            throw new IOException(e);
        }
    }

    @Override
    public void write(int b2) throws IOException {
        this.sendData(ByteString$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{b2}), Numeric$IntIsIntegral$.MODULE$));
    }

    @Override
    public void write(byte[] b2, int off, int len2) throws IOException {
        this.sendData(ByteString$.MODULE$.fromArray(b2, off, len2));
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            Await$.MODULE$.result(this.sendToStage.invokeWithFeedback(OutputStreamSourceStage$Close$.MODULE$), this.writeTimeout);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable3);
            if (option2.isEmpty()) {
                throw throwable2;
            }
            Throwable e = option2.get();
            throw new IOException(e);
        }
    }

    public OutputStreamAdapter(Semaphore unfulfilledDemand, AsyncCallback<OutputStreamSourceStage.AdapterToStageMessage> sendToStage, FiniteDuration writeTimeout) {
        this.unfulfilledDemand = unfulfilledDemand;
        this.sendToStage = sendToStage;
        this.writeTimeout = writeTimeout;
    }
}

