/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl;

import akka.annotation.InternalApi;
import akka.stream.impl.CancelledSubscription$;
import akka.stream.impl.ReactiveStreamsCompliance;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@InternalApi
public final class ReactiveStreamsCompliance$ {
    public static final ReactiveStreamsCompliance$ MODULE$;
    private final String CanNotSubscribeTheSameSubscriberMultipleTimes;
    private final String SupportsOnlyASingleSubscriber;
    private final String NumberOfElementsInRequestMustBePositiveMsg;
    private final String SubscriberMustNotBeNullMsg;
    private final String ExceptionMustNotBeNullMsg;
    private final String ElementMustNotBeNullMsg;
    private final String SubscriptionMustNotBeNullMsg;

    static {
        new ReactiveStreamsCompliance$();
    }

    public final String CanNotSubscribeTheSameSubscriberMultipleTimes() {
        return "can not subscribe the same subscriber multiple times (see reactive-streams specification, rules 1.10 and 2.12)";
    }

    public final String SupportsOnlyASingleSubscriber() {
        return "only supports one subscriber (which is allowed, see reactive-streams specification, rule 1.12)";
    }

    public final String NumberOfElementsInRequestMustBePositiveMsg() {
        return "The number of requested elements must be > 0 (see reactive-streams specification, rule 3.9)";
    }

    public final String SubscriberMustNotBeNullMsg() {
        return "Subscriber must not be null, rule 1.9";
    }

    public final String ExceptionMustNotBeNullMsg() {
        return "Exception must not be null, rule 2.13";
    }

    public final String ElementMustNotBeNullMsg() {
        return "Element must not be null, rule 2.13";
    }

    public final String SubscriptionMustNotBeNullMsg() {
        return "Subscription must not be null, rule 2.13";
    }

    public final Throwable numberOfElementsInRequestMustBePositiveException() {
        return new IllegalArgumentException("The number of requested elements must be > 0 (see reactive-streams specification, rule 3.9)");
    }

    public final Throwable canNotSubscribeTheSameSubscriberMultipleTimesException() {
        return new IllegalStateException("can not subscribe the same subscriber multiple times (see reactive-streams specification, rules 1.10 and 2.12)");
    }

    public final Throwable subscriberMustNotBeNullException() {
        return new NullPointerException("Subscriber must not be null, rule 1.9");
    }

    public final Throwable exceptionMustNotBeNullException() {
        return new NullPointerException("Exception must not be null, rule 2.13");
    }

    public final Throwable elementMustNotBeNullException() {
        return new NullPointerException("Element must not be null, rule 2.13");
    }

    public final Throwable subscriptionMustNotBeNullException() {
        return new NullPointerException("Subscription must not be null, rule 2.13");
    }

    public final <T> void rejectDuplicateSubscriber(Subscriber<T> subscriber) {
        this.tryOnError(subscriber, this.canNotSubscribeTheSameSubscriberMultipleTimesException());
    }

    public final <T> void rejectAdditionalSubscriber(Subscriber<T> subscriber, String rejector) {
        this.tryOnSubscribe(subscriber, CancelledSubscription$.MODULE$);
        this.tryOnError(subscriber, new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{rejector, "only supports one subscriber (which is allowed, see reactive-streams specification, rule 1.12)"}))));
    }

    public final <T> void rejectDueToNonPositiveDemand(Subscriber<T> subscriber) {
        this.tryOnError(subscriber, this.numberOfElementsInRequestMustBePositiveException());
    }

    public final <T> void requireNonNullSubscriber(Subscriber<T> subscriber) {
        if (subscriber == null) {
            throw this.subscriberMustNotBeNullException();
        }
    }

    public final void requireNonNullException(Throwable cause) {
        if (cause == null) {
            throw this.exceptionMustNotBeNullException();
        }
    }

    public final <T> void requireNonNullElement(T element2) {
        if (element2 == null) {
            throw this.elementMustNotBeNullException();
        }
    }

    public final void requireNonNullSubscription(Subscription subscription) {
        if (subscription == null) {
            throw this.subscriptionMustNotBeNullException();
        }
    }

    public final <T> void tryOnError(Subscriber<T> subscriber, Throwable error2) {
        Throwable throwable2 = error2;
        if (throwable2 instanceof ReactiveStreamsCompliance.SpecViolation) {
            ReactiveStreamsCompliance.SpecViolation specViolation = (ReactiveStreamsCompliance.SpecViolation)((Object)throwable2);
            throw new IllegalStateException("It is not legal to try to signal onError with a SpecViolation", (Throwable)((Object)specViolation));
        }
        try {
            subscriber.onError(throwable2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable4);
            if (option2.isEmpty()) {
                throw throwable3;
            }
            Throwable t = option2.get();
            throw new ReactiveStreamsCompliance.SignalThrewException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".onError"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{subscriber})), t);
        }
    }

    public final <T> void tryOnNext(Subscriber<T> subscriber, T element2) {
        this.requireNonNullElement(element2);
        try {
            subscriber.onNext(element2);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable3);
            if (option2.isEmpty()) {
                throw throwable2;
            }
            Throwable t = option2.get();
            throw new ReactiveStreamsCompliance.SignalThrewException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".onNext"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{subscriber})), t);
        }
    }

    public final <T> void tryOnSubscribe(Subscriber<T> subscriber, Subscription subscription) {
        try {
            subscriber.onSubscribe(subscription);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable3);
            if (option2.isEmpty()) {
                throw throwable2;
            }
            Throwable t = option2.get();
            throw new ReactiveStreamsCompliance.SignalThrewException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".onSubscribe"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{subscriber})), t);
        }
    }

    public final <T> void tryOnComplete(Subscriber<T> subscriber) {
        try {
            subscriber.onComplete();
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable3);
            if (option2.isEmpty()) {
                throw throwable2;
            }
            Throwable t = option2.get();
            throw new ReactiveStreamsCompliance.SignalThrewException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".onComplete"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{subscriber})), t);
        }
    }

    public final void tryRequest(Subscription subscription, long demand) {
        if (subscription == null) {
            throw new IllegalStateException("Subscription must be not null on request() call, rule 1.3");
        }
        try {
            subscription.request(demand);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable3);
            if (option2.isEmpty()) {
                throw throwable2;
            }
            Throwable t = option2.get();
            throw new ReactiveStreamsCompliance.SignalThrewException("It is illegal to throw exceptions from request(), rule 3.16", t);
        }
    }

    public final void tryCancel(Subscription subscription) {
        if (subscription == null) {
            throw new IllegalStateException("Subscription must be not null on cancel() call, rule 1.3");
        }
        try {
            subscription.cancel();
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable3);
            if (option2.isEmpty()) {
                throw throwable2;
            }
            Throwable t = option2.get();
            throw new ReactiveStreamsCompliance.SignalThrewException("It is illegal to throw exceptions from cancel(), rule 3.15", t);
        }
    }

    private ReactiveStreamsCompliance$() {
        MODULE$ = this;
    }
}

