/*
 * Decompiled with CFR 0.152.
 */
package akka.protobuf;

final class Utf8 {
    public static final int COMPLETE = 0;
    public static final int MALFORMED = -1;

    private Utf8() {
    }

    public static boolean isValidUtf8(byte[] byArray) {
        return Utf8.isValidUtf8(byArray, 0, byArray.length);
    }

    public static boolean isValidUtf8(byte[] byArray, int n, int n2) {
        return Utf8.partialIsValidUtf8(byArray, n, n2) == 0;
    }

    public static int partialIsValidUtf8(int n, byte[] byArray, int n2, int n3) {
        if (n != 0) {
            if (n2 >= n3) {
                return n;
            }
            byte by2 = (byte)n;
            if (by2 < -32) {
                if (by2 < -62 || byArray[n2++] > -65) {
                    return -1;
                }
            } else if (by2 < -16) {
                byte by3 = (byte)(~(n >> 8));
                if (by3 == 0) {
                    by3 = byArray[n2++];
                    if (n2 >= n3) {
                        return Utf8.incompleteStateFor(by2, by3);
                    }
                }
                if (by3 > -65 || by2 == -32 && by3 < -96 || by2 == -19 && by3 >= -96 || byArray[n2++] > -65) {
                    return -1;
                }
            } else {
                byte by4 = (byte)(~(n >> 8));
                byte by5 = 0;
                if (by4 == 0) {
                    by4 = byArray[n2++];
                    if (n2 >= n3) {
                        return Utf8.incompleteStateFor(by2, by4);
                    }
                } else {
                    by5 = (byte)(n >> 16);
                }
                if (by5 == 0) {
                    by5 = byArray[n2++];
                    if (n2 >= n3) {
                        return Utf8.incompleteStateFor(by2, (int)by4, (int)by5);
                    }
                }
                if (by4 > -65 || (by2 << 28) + (by4 - -112) >> 30 != 0 || by5 > -65 || byArray[n2++] > -65) {
                    return -1;
                }
            }
        }
        return Utf8.partialIsValidUtf8(byArray, n2, n3);
    }

    public static int partialIsValidUtf8(byte[] byArray, int n, int n2) {
        while (n < n2 && byArray[n] >= 0) {
            ++n;
        }
        return n >= n2 ? 0 : Utf8.partialIsValidUtf8NonAscii(byArray, n, n2);
    }

    private static int partialIsValidUtf8NonAscii(byte[] byArray, int n, int n2) {
        while (true) {
            byte by2;
            byte by3;
            if (n >= n2) {
                return 0;
            }
            if ((by3 = byArray[n++]) >= 0) continue;
            if (by3 < -32) {
                if (n >= n2) {
                    return by3;
                }
                if (by3 >= -62 && byArray[n++] <= -65) continue;
                return -1;
            }
            if (by3 < -16) {
                if (n >= n2 - 1) {
                    return Utf8.incompleteStateFor(byArray, n, n2);
                }
                if (!((by2 = byArray[n++]) > -65 || by3 == -32 && by2 < -96 || by3 == -19 && by2 >= -96) && byArray[n++] <= -65) continue;
                return -1;
            }
            if (n >= n2 - 2) {
                return Utf8.incompleteStateFor(byArray, n, n2);
            }
            if ((by2 = byArray[n++]) > -65 || (by3 << 28) + (by2 - -112) >> 30 != 0 || byArray[n++] > -65 || byArray[n++] > -65) break;
        }
        return -1;
    }

    private static int incompleteStateFor(int n) {
        return n > -12 ? -1 : n;
    }

    private static int incompleteStateFor(int n, int n2) {
        return n > -12 || n2 > -65 ? -1 : n ^ n2 << 8;
    }

    private static int incompleteStateFor(int n, int n2, int n3) {
        return n > -12 || n2 > -65 || n3 > -65 ? -1 : n ^ n2 << 8 ^ n3 << 16;
    }

    private static int incompleteStateFor(byte[] byArray, int n, int n2) {
        byte by2 = byArray[n - 1];
        switch (n2 - n) {
            case 0: {
                return Utf8.incompleteStateFor(by2);
            }
            case 1: {
                return Utf8.incompleteStateFor(by2, byArray[n]);
            }
            case 2: {
                return Utf8.incompleteStateFor(by2, (int)byArray[n], (int)byArray[n + 1]);
            }
        }
        throw new AssertionError();
    }
}

