/*
 * Decompiled with CFR 0.152.
 */
package akka.protobuf;

import akka.protobuf.ByteString;
import akka.protobuf.ExtensionRegistryLite;
import akka.protobuf.MessageLite;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

class LazyField {
    private final MessageLite defaultInstance;
    private final ExtensionRegistryLite extensionRegistry;
    private ByteString bytes;
    private volatile MessageLite value;
    private volatile boolean isDirty = false;

    public LazyField(MessageLite messageLite, ExtensionRegistryLite extensionRegistryLite, ByteString byteString) {
        this.defaultInstance = messageLite;
        this.extensionRegistry = extensionRegistryLite;
        this.bytes = byteString;
    }

    public MessageLite getValue() {
        this.ensureInitialized();
        return this.value;
    }

    public MessageLite setValue(MessageLite messageLite) {
        MessageLite messageLite2 = this.value;
        this.value = messageLite;
        this.bytes = null;
        this.isDirty = true;
        return messageLite2;
    }

    public int getSerializedSize() {
        if (this.isDirty) {
            return this.value.getSerializedSize();
        }
        return this.bytes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteString toByteString() {
        if (!this.isDirty) {
            return this.bytes;
        }
        LazyField lazyField = this;
        synchronized (lazyField) {
            if (!this.isDirty) {
                return this.bytes;
            }
            this.bytes = this.value.toByteString();
            this.isDirty = false;
            return this.bytes;
        }
    }

    public int hashCode() {
        this.ensureInitialized();
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        this.ensureInitialized();
        return this.value.equals(object);
    }

    public String toString() {
        this.ensureInitialized();
        return this.value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        if (this.value != null) {
            return;
        }
        LazyField lazyField = this;
        synchronized (lazyField) {
            if (this.value != null) {
                return;
            }
            try {
                if (this.bytes != null) {
                    this.value = this.defaultInstance.getParserForType().parseFrom(this.bytes, this.extensionRegistry);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class LazyIterator<K>
    implements Iterator<Map.Entry<K, Object>> {
        private Iterator<Map.Entry<K, Object>> iterator;

        public LazyIterator(Iterator<Map.Entry<K, Object>> iterator2) {
            this.iterator = iterator2;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, Object> next() {
            Map.Entry<K, Object> entry2 = this.iterator.next();
            if (entry2.getValue() instanceof LazyField) {
                return new LazyEntry(entry2);
            }
            return entry2;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    static class LazyEntry<K>
    implements Map.Entry<K, Object> {
        private Map.Entry<K, LazyField> entry;

        private LazyEntry(Map.Entry<K, LazyField> entry2) {
            this.entry = entry2;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public Object getValue() {
            LazyField lazyField = this.entry.getValue();
            if (lazyField == null) {
                return null;
            }
            return lazyField.getValue();
        }

        public LazyField getField() {
            return this.entry.getValue();
        }

        @Override
        public Object setValue(Object object) {
            if (!(object instanceof MessageLite)) {
                throw new IllegalArgumentException("LazyField now only used for MessageSet, and the value of MessageSet must be an instance of MessageLite");
            }
            return this.entry.getValue().setValue((MessageLite)object);
        }
    }
}

