/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.Actor$class;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorLogging$class;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.DnsProtocol$Srv$;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsCache;
import akka.io.dns.internal.AsyncDnsResolver$;
import akka.io.dns.internal.DnsClient;
import akka.pattern.AskableActorRef$;
import akka.util.Helpers$;
import akka.util.Timeout;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$DurationIsOrdered$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\t\u0005h!B\u0001\u0003\u0005\u0019Q!\u0001E!ts:\u001cGI\\:SKN|GN^3s\u0015\t\u0019A!\u0001\u0005j]R,'O\\1m\u0015\t)a!A\u0002e]NT!a\u0002\u0005\u0002\u0005%|'\"A\u0005\u0002\t\u0005\\7.Y\n\u0005\u0001-\tr\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Ui\u0011a\u0005\u0006\u0003)!\tQ!Y2u_JL!AF\n\u0003\u000b\u0005\u001bGo\u001c:\u0011\u0005IA\u0012BA\r\u0014\u00051\t5\r^8s\u0019><w-\u001b8h\u0011!Y\u0002A!A!\u0002\u0013i\u0012\u0001C:fiRLgnZ:\u0004\u0001A\u0011adH\u0007\u0002\t%\u0011\u0001\u0005\u0002\u0002\f\t:\u001c8+\u001a;uS:<7\u000f\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003\u0015\u0019\u0017m\u00195f!\t!S%D\u0001\u0003\u0013\t1#AA\u0007Bgft7\r\u00128t\u0007\u0006\u001c\u0007.\u001a\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005i1\r\\5f]R4\u0015m\u0019;pef\u0004R\u0001\u0004\u0016-_\rK!aK\u0007\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001\n.\u0013\tq3CA\bBGR|'OU3g\r\u0006\u001cGo\u001c:z!\r\u0001\u0004h\u000f\b\u0003cYr!AM\u001b\u000e\u0003MR!\u0001\u000e\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0011BA\u001c\u000e\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u000f\u001e\u0003\t1K7\u000f\u001e\u0006\u0003o5\u0001\"\u0001P!\u000e\u0003uR!AP \u0002\u00079,GOC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$!E%oKR\u001cvnY6fi\u0006#GM]3tgB\u0019\u0001\u0007\u000f#\u0011\u0005I)\u0015B\u0001$\u0014\u0005!\t5\r^8s%\u00164\u0007\"\u0002%\u0001\t\u0003I\u0015A\u0002\u001fj]&$h\b\u0006\u0003K\u00172k\u0005C\u0001\u0013\u0001\u0011\u0015Yr\t1\u0001\u001e\u0011\u0015\u0011s\t1\u0001$\u0011\u0015As\t1\u0001*\u0011\u001dy\u0005A1A\u0005\u0004A\u000b!!Z2\u0016\u0003E\u0003\"AU+\u000e\u0003MS!\u0001V\u0007\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002W'\nAR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:\t\ra\u0003\u0001\u0015!\u0003R\u0003\r)7\r\t\u0005\b5\u0002\u0011\r\u0011b\u0001\\\u0003\u001d!\u0018.\\3pkR,\u0012\u0001\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\"\tA!\u001e;jY&\u0011\u0011M\u0018\u0002\b)&lWm\\;u\u0011\u0019\u0019\u0007\u0001)A\u00059\u0006AA/[7f_V$\b\u0005C\u0004f\u0001\t\u0007I\u0011\u00014\u0002\u00179\fW.Z*feZ,'o]\u000b\u0002_!1\u0001\u000e\u0001Q\u0001\n=\nAB\\1nKN+'O^3sg\u0002BqA\u001b\u0001A\u0002\u0013%1.A\u0005sKF,Xm\u001d;JIV\tA\u000e\u0005\u0002\r[&\u0011a.\u0004\u0002\u0006'\"|'\u000f\u001e\u0005\ba\u0002\u0001\r\u0011\"\u0003r\u00035\u0011X-];fgRLEm\u0018\u0013fcR\u0011!/\u001e\t\u0003\u0019ML!\u0001^\u0007\u0003\tUs\u0017\u000e\u001e\u0005\bm>\f\t\u00111\u0001m\u0003\rAH%\r\u0005\u0007q\u0002\u0001\u000b\u0015\u00027\u0002\u0015I,\u0017/^3ti&#\u0007\u0005C\u0003{\u0001\u0011%10\u0001\u0004oKb$\u0018\n\u001a\u000b\u0002Y\"9Q\u0010\u0001b\u0001\n\u0013q\u0018!\u0003:fg>dg/\u001a:t+\u0005\u0019\u0005bBA\u0001\u0001\u0001\u0006IaQ\u0001\u000be\u0016\u001cx\u000e\u001c<feN\u0004\u0003bBA\u0003\u0001\u0011\u0005\u0013qA\u0001\be\u0016\u001cW-\u001b<f+\t\tI\u0001\u0005\u0003\u0002\f\u00055Q\"\u0001\u0001\n\u0007\u0005=QCA\u0004SK\u000e,\u0017N^3\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016\u0005!\"/Z:pYZ,w+\u001b;i%\u0016\u001cx\u000e\u001c<feN$\u0002\"a\u0006\u0002,\u0005u\u0012Q\u000b\t\u0006%\u0006e\u0011QD\u0005\u0004\u00037\u0019&A\u0002$viV\u0014X\r\u0005\u0003\u0002 \u0005\u0015bb\u0001\u0010\u0002\"%\u0019\u00111\u0005\u0003\u0002\u0017\u0011s7\u000f\u0015:pi>\u001cw\u000e\\\u0005\u0005\u0003O\tIC\u0001\u0005SKN|GN^3e\u0015\r\t\u0019\u0003\u0002\u0005\t\u0003[\t\t\u00021\u0001\u00020\u0005!a.Y7f!\u0011\t\t$a\u000e\u000f\u00071\t\u0019$C\u0002\u000265\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u001d\u0003w\u0011aa\u0015;sS:<'bAA\u001b\u001b!A\u0011qHA\t\u0001\u0004\t\t%A\u0006sKF,Xm\u001d;UsB,\u0007\u0003BA\"\u0003#rA!!\u0012\u0002\"9!\u0011qIA(\u001d\u0011\tI%!\u0014\u000f\u0007I\nY%C\u0001\n\u0013\t9\u0001\"\u0003\u0002\u0006\r%!\u00111KA\u0015\u0005-\u0011V-];fgR$\u0016\u0010]3\t\ru\f\t\u00021\u0001D\u0011\u001d\tI\u0006\u0001C\u0005\u00037\nAb]3oIF+Xm\u001d;j_:$b!!\u0018\u0002r\u0005U\u0004#\u0002*\u0002\u001a\u0005}\u0003\u0003BA1\u0003WrA!a\u0019\u0002h9!\u0011QIA3\u0013\t\u0019A!C\u0002\u0002j\t\t\u0011\u0002\u00128t\u00072LWM\u001c;\n\t\u00055\u0014q\u000e\u0002\u0007\u0003:\u001cx/\u001a:\u000b\u0007\u0005%$\u0001C\u0004\u0002t\u0005]\u0003\u0019\u0001#\u0002\u0011I,7o\u001c7wKJD\u0001\"a\u001e\u0002X\u0001\u0007\u0011\u0011P\u0001\b[\u0016\u001c8/Y4f!\u0011\t\t'a\u001f\n\t\u0005u\u0014q\u000e\u0002\f\t:\u001c\u0018+^3ti&|g\u000eC\u0004\u0002\u0002\u0002!I!a!\u0002#I,7o\u001c7wK^KG\u000f[*fCJ\u001c\u0007\u000e\u0006\u0005\u0002\u0018\u0005\u0015\u0015qQAE\u0011!\ti#a A\u0002\u0005=\u0002\u0002CA \u0003\u007f\u0002\r!!\u0011\t\u000f\u0005M\u0014q\u0010a\u0001\t\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0015\u0001\u0004:fg>dg/\u001a$jeN$H\u0003CA\f\u0003#\u000b9*!'\t\u0011\u0005M\u00151\u0012a\u0001\u0003+\u000b1b]3be\u000eDg*Y7fgB!\u0001\u0007OA\u0018\u0011!\ty$a#A\u0002\u0005\u0005\u0003bBA:\u0003\u0017\u0003\r\u0001\u0012\u0005\b\u0003;\u0003A\u0011BAP\u0003\u001d\u0011Xm]8mm\u0016$\u0002\"a\u0006\u0002\"\u0006\r\u0016Q\u0015\u0005\t\u0003[\tY\n1\u0001\u00020!A\u0011qHAN\u0001\u0004\t\t\u0005C\u0004\u0002t\u0005m\u0005\u0019\u0001#)\u0007\u0001\tI\u000b\u0005\u0003\u0002,\u0006EVBAAW\u0015\r\ty\u000bC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAZ\u0003[\u00131\"\u00138uKJt\u0017\r\\!qS\u001eA\u0011q\u0017\u0002\t\u0002\u0019\tI,\u0001\tBgft7\r\u00128t%\u0016\u001cx\u000e\u001c<feB\u0019A%a/\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0004\u0002>N\u0019\u00111X\u0006\t\u000f!\u000bY\f\"\u0001\u0002BR\u0011\u0011\u0011\u0018\u0005\u000b\u0003\u000b\fYL1A\u0005\n\u0005\u001d\u0017aC5qmR\nE\r\u001a:fgN,\"!!3\u0011\t\u0005-\u00171[\u0007\u0003\u0003\u001bTA!a4\u0002R\u0006AQ.\u0019;dQ&twM\u0003\u0002`\u001b%!\u0011Q[Ag\u0005\u0015\u0011VmZ3y\u0011%\tI.a/!\u0002\u0013\tI-\u0001\u0007jaZ$\u0014\t\u001a3sKN\u001c\b\u0005\u0003\u0006\u0002^\u0006m&\u0019!C\u0005\u0003\u000f\f1\"\u001b9wm\u0005#GM]3tg\"I\u0011\u0011]A^A\u0003%\u0011\u0011Z\u0001\rSB4h'\u00113ee\u0016\u001c8\u000f\t\u0005\t\u0003K\fY\f\"\u0003\u0002h\u0006i\u0011n]%oKR\fE\r\u001a:fgN$B!!;\u0002pB\u0019A\"a;\n\u0007\u00055XBA\u0004C_>dW-\u00198\t\u0011\u00055\u00121\u001da\u0001\u0003_A!\"a=\u0002<\n\u0007I\u0011BA{\u0003\u0015)U\u000e\u001d;z+\t\ti\u0006C\u0005\u0002z\u0006m\u0006\u0015!\u0003\u0002^\u00051Q)\u001c9us\u00022q!!@\u0002<\u0002\u000byP\u0001\fSKN|GN^3GC&dW\rZ#yG\u0016\u0004H/[8o'!\tYP!\u0001\u0003\b\t5\u0001c\u0001\u0019\u0003\u0004%\u0019!Q\u0001\u001e\u0003\u0013\u0015C8-\u001a9uS>t\u0007c\u0001\u0007\u0003\n%\u0019!1B\u0007\u0003\u000fA\u0013x\u000eZ;diB\u0019ABa\u0004\n\u0007\tEQB\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0006\u0003\u0016\u0005m(Q3A\u0005\u0002\t]\u0011aA7tOV\u0011\u0011q\u0006\u0005\f\u00057\tYP!E!\u0002\u0013\ty#\u0001\u0003ng\u001e\u0004\u0003b\u0002%\u0002|\u0012\u0005!q\u0004\u000b\u0005\u0005C\u0011)\u0003\u0005\u0003\u0003$\u0005mXBAA^\u0011!\u0011)B!\bA\u0002\u0005=\u0002B\u0003B\u0015\u0003w\f\t\u0011\"\u0001\u0003,\u0005!1m\u001c9z)\u0011\u0011\tC!\f\t\u0015\tU!q\u0005I\u0001\u0002\u0004\ty\u0003\u0003\u0006\u00032\u0005m\u0018\u0013!C\u0001\u0005g\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00036)\"\u0011q\u0006B\u001cW\t\u0011I\u0004\u0005\u0003\u0003<\t\rSB\u0001B\u001f\u0015\u0011\u0011yD!\u0011\u0002\u0013Ut7\r[3dW\u0016$'bAAX\u001b%!!Q\tB\u001f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005\u0013\nY0!A\u0005B\t-\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003NA!!q\nB+\u001b\t\u0011\tFC\u0002\u0003T}\nA\u0001\\1oO&!\u0011\u0011\bB)\u0011)\u0011I&a?\u0002\u0002\u0013\u0005!1L\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005;\u00022\u0001\u0004B0\u0013\r\u0011\t'\u0004\u0002\u0004\u0013:$\bB\u0003B3\u0003w\f\t\u0011\"\u0001\u0003h\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B5\u0005_\u00022\u0001\u0004B6\u0013\r\u0011i'\u0004\u0002\u0004\u0003:L\b\"\u0003<\u0003d\u0005\u0005\t\u0019\u0001B/\u0011)\u0011\u0019(a?\u0002\u0002\u0013\u0005#QO\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u000f\t\u0007\u0005s\u0012yH!\u001b\u000e\u0005\tm$b\u0001B?\u001b\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u0005%1\u0010\u0002\t\u0013R,'/\u0019;pe\"Q!QQA~\u0003\u0003%\tAa\"\u0002\u0011\r\fg.R9vC2$B!!;\u0003\n\"IaOa!\u0002\u0002\u0003\u0007!\u0011\u000e\u0005\u000b\u0005\u001b\u000bY0!A\u0005B\t=\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\tu\u0003B\u0003BJ\u0003w\f\t\u0011\"\u0011\u0003\u0016\u00061Q-];bYN$B!!;\u0003\u0018\"IaO!%\u0002\u0002\u0003\u0007!\u0011N\u0004\u000b\u00057\u000bY,!A\t\u0002\tu\u0015A\u0006*fg>dg/\u001a$bS2,G-\u0012=dKB$\u0018n\u001c8\u0011\t\t\r\"q\u0014\u0004\u000b\u0003{\fY,!A\t\u0002\t\u00056C\u0002BP\u0005G\u0013i\u0001\u0005\u0005\u0003&\n-\u0016q\u0006B\u0011\u001b\t\u00119KC\u0002\u0003*6\tqA];oi&lW-\u0003\u0003\u0003.\n\u001d&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oc!9\u0001Ja(\u0005\u0002\tEFC\u0001BO\u0011)\u0011)La(\u0002\u0002\u0013\u0015#qW\u0001\ti>\u001cFO]5oOR\u0011!Q\n\u0005\u000b\u0005w\u0013y*!A\u0005\u0002\nu\u0016!B1qa2LH\u0003\u0002B\u0011\u0005\u007fC\u0001B!\u0006\u0003:\u0002\u0007\u0011q\u0006\u0005\u000b\u0005\u0007\u0014y*!A\u0005\u0002\n\u0015\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u000f\u0014i\rE\u0003\r\u0005\u0013\fy#C\u0002\u0003L6\u0011aa\u00149uS>t\u0007B\u0003Bh\u0005\u0003\f\t\u00111\u0001\u0003\"\u0005\u0019\u0001\u0010\n\u0019\t\u0015\tM'qTA\u0001\n\u0013\u0011).A\u0006sK\u0006$'+Z:pYZ,GC\u0001Bl!\u0011\u0011yE!7\n\t\tm'\u0011\u000b\u0002\u0007\u001f\nTWm\u0019;)\t\u0005m\u0016\u0011\u0016\u0015\u0005\u0003k\u000bI\u000b")
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    private final DnsSettings settings;
    public final AsyncDnsCache akka$io$dns$internal$AsyncDnsResolver$$cache;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List<InetSocketAddress> nameServers;
    private short requestId;
    private final List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    @TraitSetter
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public LoggingAdapter log() {
        return ActorLogging$class.log(this);
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    @Override
    public final ActorRef sender() {
        return Actor$class.sender(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor$class.aroundReceive(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor$class.aroundPreStart(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor$class.aroundPostStop(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor$class.aroundPreRestart(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor$class.aroundPostRestart(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor$class.supervisorStrategy(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor$class.preStart(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor$class.postStop(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor$class.preRestart(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor$class.postRestart(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor$class.unhandled(this, message);
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    private short requestId() {
        return this.requestId;
    }

    private void requestId_$eq(short x$1) {
        this.requestId = x$1;
    }

    private short nextId() {
        this.requestId_$eq((short)(this.requestId() + 1));
        return this.requestId();
    }

    public List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers() {
        return this.akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var7_14;
                A1 A1 = x1;
                if (A1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.RequestType mode;
                    DnsProtocol.Resolve resolve2 = (DnsProtocol.Resolve)A1;
                    String name = resolve2.name();
                    Option<DnsProtocol.Resolved> option2 = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.get(new Tuple2<String, DnsProtocol.RequestType>(name, mode = resolve2.requestType()));
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)some2.x();
                        this.$outer.log().debug("{} cached {}", mode, resolved);
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(resolved, this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                        akka.pattern.package$.MODULE$.pipe(this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(name, mode, this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolvers()).map(new Serializable(this, name, mode){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$receive$1 $outer;
                            private final String name$1;
                            private final DnsProtocol.RequestType mode$1;

                            public final DnsProtocol.Resolved apply(DnsProtocol.Resolved resolved) {
                                if (resolved.records().nonEmpty()) {
                                    CachePolicy.Ttl minTtl = resolved.records().minBy(new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final FiniteDuration apply(ResourceRecord x$1) {
                                            return x$1.ttl().value();
                                        }
                                    }, Duration$DurationIsOrdered$.MODULE$).ttl();
                                    this.$outer.akka$io$dns$internal$AsyncDnsResolver$$anonfun$$$outer().akka$io$dns$internal$AsyncDnsResolver$$cache.put(new Tuple2<String, DnsProtocol.RequestType>(this.name$1, this.mode$1), resolved, minTtl);
                                }
                                return resolved;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.name$1 = name$1;
                                this.mode$1 = mode$1;
                            }
                        }, this.$outer.ec()), this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var7_14;
                } else {
                    B1 B1 = function1.apply(x1);
                }
                return var7_14;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DnsProtocol.Resolve;
                return bl;
            }

            public /* synthetic */ AsyncDnsResolver akka$io$dns$internal$AsyncDnsResolver$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        List<ActorRef> list2;
        block6: {
            Future<DnsProtocol.Resolved> future2;
            block3: {
                Future<DnsProtocol.Resolved> future3;
                block5: {
                    block4: {
                        block2: {
                            if (!AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$isInetAddress(name)) break block2;
                            future2 = Future$.MODULE$.fromTry(Try$.MODULE$.apply(new Serializable(this, name){
                                public static final long serialVersionUID = 0L;
                                private final String name$2;

                                public final DnsProtocol.Resolved apply() {
                                    InetAddress inetAddress;
                                    block4: {
                                        ARecord record2;
                                        ResourceRecord resourceRecord;
                                        block3: {
                                            block2: {
                                                InetAddress address = InetAddress.getByName(this.name$2);
                                                inetAddress = address;
                                                if (!(inetAddress instanceof Inet4Address)) break block2;
                                                resourceRecord = new ARecord(this.name$2, CachePolicy$Ttl$.MODULE$.effectivelyForever(), address);
                                                break block3;
                                            }
                                            if (!(inetAddress instanceof Inet6Address)) break block4;
                                            Inet6Address inet6Address = (Inet6Address)inetAddress;
                                            resourceRecord = new AAAARecord(this.name$2, CachePolicy$Ttl$.MODULE$.effectivelyForever(), inet6Address);
                                        }
                                        ARecord aRecord = record2 = resourceRecord;
                                        return DnsProtocol$Resolved$.MODULE$.apply(this.name$2, Nil$.MODULE$.$colon$colon(aRecord));
                                    }
                                    throw new MatchError(inetAddress);
                                }
                                {
                                    this.name$2 = name$2;
                                }
                            }));
                            break block3;
                        }
                        list2 = resolvers;
                        if (!((Object)Nil$.MODULE$).equals(list2)) break block4;
                        future3 = Future$.MODULE$.failed(new ResolveFailedException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to resolve ", " with nameservers: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name, this.nameServers()}))));
                        break block5;
                    }
                    if (!(list2 instanceof $colon$colon)) break block6;
                    $colon$colon $colon$colon = ($colon$colon)list2;
                    ActorRef head2 = (ActorRef)$colon$colon.head();
                    List tail2 = $colon$colon.tl$1();
                    future3 = this.resolveWithSearch(name, requestType, head2).recoverWith(new Serializable(this, name, requestType, tail2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AsyncDnsResolver $outer;
                        private final String name$2;
                        private final DnsProtocol.RequestType requestType$1;
                        private final List tail$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x2;
                            Option<Throwable> option2 = NonFatal$.MODULE$.unapply(A1);
                            if (option2.isEmpty()) {
                                object = function1.apply(x2);
                            } else {
                                Throwable t = option2.get();
                                this.$outer.log().error(t, "Resolve failed. Trying next name server");
                                object = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(this.name$2, this.requestType$1, this.tail$1);
                            }
                            return object;
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable2 = x2;
                            Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable2);
                            boolean bl = !option2.isEmpty();
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.name$2 = name$2;
                            this.requestType$1 = requestType$1;
                            this.tail$1 = tail$1;
                        }
                    }, this.ec());
                }
                future2 = future3;
            }
            return future2;
        }
        throw new MatchError(list2);
    }

    /*
     * WARNING - void declaration
     */
    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        void var3_3;
        Future result2 = AskableActorRef$.MODULE$.$qmark$extension1(akka.pattern.package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).mapTo(ClassTag$.MODULE$.apply(DnsClient.Answer.class));
        result2.failed().foreach(new Serializable(this, resolver, message){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;
            private final ActorRef resolver$1;
            private final DnsClient.DnsQuestion message$1;

            public final void apply(Throwable x$3) {
                package$.MODULE$.actorRef2Scala(this.resolver$1).$bang(new DnsClient.DropRequest(this.message$1.id()), this.$outer.self());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resolver$1 = resolver$1;
                this.message$1 = message$1;
            }
        }, this.ec());
        return var3_3;
    }

    private Future<DnsProtocol.Resolved> resolveWithSearch(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future<DnsProtocol.Resolved> future2;
        if (this.settings.SearchDomains().nonEmpty()) {
            List<String> list2;
            List<?> nameWithSearch = this.settings.SearchDomains().map(new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$3;

                public final String apply(String sd) {
                    return new StringBuilder().append((Object)this.name$3).append((Object)".").append((Object)sd).toString();
                }
                {
                    this.name$3 = name$3;
                }
            }, List$.MODULE$.canBuildFrom());
            if (new StringOps(Predef$.MODULE$.augmentString(name)).count((Function1<Object, Object>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$4) {
                    return x$4 == '.';
                }
            })) >= this.settings.NDots()) {
                String string2 = name;
                list2 = nameWithSearch.$colon$colon(string2);
            } else {
                list2 = nameWithSearch.$colon$plus(name, List$.MODULE$.canBuildFrom());
            }
            List<String> toResolve = list2;
            future2 = this.akka$io$dns$internal$AsyncDnsResolver$$resolveFirst(toResolve, requestType, resolver);
        } else {
            future2 = this.resolve(name, requestType, resolver);
        }
        return future2;
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolveFirst(List<String> searchNames, DnsProtocol.RequestType requestType, ActorRef resolver) {
        List<String> list2;
        block5: {
            Future<DnsProtocol.Resolved> future2;
            block3: {
                block4: {
                    $colon$colon $colon$colon;
                    boolean bl;
                    block2: {
                        bl = false;
                        $colon$colon = null;
                        list2 = searchNames;
                        if (!(list2 instanceof $colon$colon)) break block2;
                        bl = true;
                        $colon$colon = ($colon$colon)list2;
                        String searchName = (String)$colon$colon.head();
                        List list3 = $colon$colon.tl$1();
                        if (!((Object)Nil$.MODULE$).equals(list3)) break block2;
                        future2 = this.resolve(searchName, requestType, resolver);
                        break block3;
                    }
                    if (!bl) break block4;
                    String searchName = (String)$colon$colon.head();
                    List remaining = $colon$colon.tl$1();
                    future2 = this.resolve(searchName, requestType, resolver).flatMap(new Serializable(this, requestType, resolver, remaining){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AsyncDnsResolver $outer;
                        private final DnsProtocol.RequestType requestType$2;
                        private final ActorRef resolver$2;
                        private final List remaining$1;

                        public final Future<DnsProtocol.Resolved> apply(DnsProtocol.Resolved resolved) {
                            return resolved.records().isEmpty() ? this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveFirst(this.remaining$1, this.requestType$2, this.resolver$2) : Future$.MODULE$.successful(resolved);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.requestType$2 = requestType$2;
                            this.resolver$2 = resolver$2;
                            this.remaining$1 = remaining$1;
                        }
                    }, this.ec());
                    break block3;
                }
                if (!((Object)Nil$.MODULE$).equals(list2)) break block5;
                future2 = Future$.MODULE$.failed(new IllegalStateException("Failed to 'resolveFirst': 'searchNames' must not be empty"));
            }
            return future2;
        }
        throw new MatchError(list2);
    }

    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        DnsProtocol.RequestType requestType2;
        block4: {
            Future<DnsProtocol.Resolved> future2;
            block3: {
                String caseFoldedName;
                block2: {
                    this.log().debug("Attempting to resolve {} with {}", name, resolver);
                    caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
                    requestType2 = requestType;
                    if (!(requestType2 instanceof DnsProtocol.Ip)) break block2;
                    DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType2;
                    boolean ipv4 = ip.ipv4();
                    boolean ipv6 = ip.ipv6();
                    Future<DnsClient.Answer> ipv4Recs = ipv4 ? this.sendQuestion(resolver, new DnsClient.Question4(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
                    Future<DnsClient.Answer> ipv6Recs = ipv6 ? this.sendQuestion(resolver, new DnsClient.Question6(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
                    future2 = ipv4Recs.flatMap(new Serializable(this, name, ipv6Recs){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AsyncDnsResolver $outer;
                        public final String name$4;
                        private final Future ipv6Recs$1;

                        public final Future<DnsProtocol.Resolved> apply(DnsClient.Answer ipv4) {
                            return this.ipv6Recs$1.map(new Serializable(this, ipv4){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$resolve$1 $outer;
                                private final DnsClient.Answer ipv4$1;

                                public final DnsProtocol.Resolved apply(DnsClient.Answer ipv6) {
                                    return new DnsProtocol.Resolved(this.$outer.name$4, this.ipv4$1.rrs().$plus$plus(ipv6.rrs(), Seq$.MODULE$.canBuildFrom()), this.ipv4$1.additionalRecs().$plus$plus(ipv6.additionalRecs(), Seq$.MODULE$.canBuildFrom()));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.ipv4$1 = ipv4$1;
                                }
                            }, this.$outer.ec());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.name$4 = name$4;
                            this.ipv6Recs$1 = ipv6Recs$1;
                        }
                    }, this.ec());
                    break block3;
                }
                if (!DnsProtocol$Srv$.MODULE$.equals(requestType2)) break block4;
                future2 = this.sendQuestion(resolver, new DnsClient.SrvQuestion(this.nextId(), caseFoldedName)).map(new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$4;

                    public final DnsProtocol.Resolved apply(DnsClient.Answer answer) {
                        return new DnsProtocol.Resolved(this.name$4, answer.rrs(), answer.additionalRecs());
                    }
                    {
                        this.name$4 = name$4;
                    }
                }, this.ec());
            }
            return future2;
        }
        throw new MatchError(requestType2);
    }

    public AsyncDnsResolver(DnsSettings settings2, AsyncDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        this.settings = settings2;
        this.akka$io$dns$internal$AsyncDnsResolver$$cache = cache;
        Actor$class.$init$(this);
        ActorLogging$class.$init$(this);
        this.ec = this.context().dispatcher();
        this.timeout = new Timeout(settings2.ResolveTimeout());
        this.nameServers = settings2.NameServers();
        this.log().debug("Using name servers [{}] and search domains [{}] with ndots={}", this.nameServers(), settings2.SearchDomains(), BoxesRunTime.boxToInteger(settings2.NDots()));
        this.requestId = 0;
        this.akka$io$dns$internal$AsyncDnsResolver$$resolvers = clientFactory.apply(this.context(), this.nameServers());
    }

    public static class ResolveFailedException
    extends Exception
    implements Product,
    Serializable {
        private final String msg;

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        @Override
        public String productPrefix() {
            return "ResolveFailedException";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
                case 0: 
            }
            return this.msg();
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolveFailedException;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResolveFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResolveFailedException resolveFailedException = (ResolveFailedException)x$1;
            String string2 = this.msg();
            String string3 = resolveFailedException.msg();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (!resolveFailedException.canEqual(this)) return false;
            return true;
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
            Product$class.$init$(this);
        }
    }
}

