/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Hashtable;
import javax.naming.directory.InitialDirContext;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class DnsSettings$ {
    public static final DnsSettings$ MODULE$;
    private final int DnsFallbackPort;
    private final Regex inetSocketAddress;

    static {
        new DnsSettings$();
    }

    private final int DnsFallbackPort() {
        return 53;
    }

    private Regex inetSocketAddress() {
        return this.inetSocketAddress;
    }

    @InternalApi
    public InetSocketAddress parseNameserverAddress(String str) {
        String string2 = str;
        Option<List<String>> option2 = this.inetSocketAddress().unapplySeq(string2);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
            Tuple2<String, String> tuple23;
            String host = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String port = (String)((LinearSeqOptimized)option2.get()).apply(1);
            Tuple2<String, String> tuple24 = tuple23 = new Tuple2<String, String>(host, port);
            String host2 = tuple24._1();
            String port2 = tuple24._2();
            return new InetSocketAddress(host2, BoxesRunTime.unboxToInt(Option$.MODULE$.apply(port2).fold(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return 53;
                }
            }, new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$5) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
                }
            })));
        }
        throw new MatchError((Object)string2);
    }

    public Try<List<InetSocketAddress>> getDefaultNameServers(ExtendedActorSystem system) {
        return this.getNameserversUsingJNDI$1().orElse(new Serializable(system){
            public static final long serialVersionUID = 0L;
            private final ExtendedActorSystem system$1;

            public final Try<List<InetSocketAddress>> apply() {
                return DnsSettings$.MODULE$.akka$io$dns$DnsSettings$$getNameserversUsingReflection$1(this.system$1);
            }
            {
                this.system$1 = system$1;
            }
        });
    }

    public final Try akka$io$dns$DnsSettings$$asInetSocketAddress$1(String server) {
        return Try$.MODULE$.apply(new Serializable(server){
            public static final long serialVersionUID = 0L;
            private final String server$1;

            public final InetSocketAddress apply() {
                int n;
                URI uri = new URI(this.server$1);
                String host = uri.getHost();
                int n2 = uri.getPort();
                switch (n2) {
                    default: {
                        n = n2;
                        break;
                    }
                    case -1: {
                        n = 53;
                    }
                }
                int port = n;
                return new InetSocketAddress(host, port);
            }
            {
                this.server$1 = server$1;
            }
        });
    }

    private final Try getNameserversUsingJNDI$1() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns://");
        return Try$.MODULE$.apply(new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final Hashtable env$1;

            public final List<InetSocketAddress> apply() {
                List list2;
                InitialDirContext ctx = new InitialDirContext(this.env$1);
                String dnsUrls = (String)ctx.getEnvironment().get("java.naming.provider.url");
                if (dnsUrls == null || dnsUrls.isEmpty()) {
                    list2 = Nil$.MODULE$;
                } else {
                    String[] servers = dnsUrls.split(" ");
                    list2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])servers).flatMap(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Iterable<InetSocketAddress> apply(String server) {
                            return Option$.MODULE$.option2Iterable(DnsSettings$.MODULE$.akka$io$dns$DnsSettings$$asInetSocketAddress$1(server).toOption());
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InetSocketAddress.class)))).toList();
                }
                return list2;
            }
            {
                this.env$1 = env$1;
            }
        });
    }

    public final Try akka$io$dns$DnsSettings$$getNameserversUsingReflection$1(ExtendedActorSystem system$1) {
        return system$1.dynamicAccess().getClassFor("sun.net.dns.ResolverConfiguration", ClassTag$.MODULE$.Nothing()).flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Try<List<InetSocketAddress>> apply(Class<? extends Nothing$> c) {
                return Try$.MODULE$.apply(new Serializable(this, c){
                    public static final long serialVersionUID = 0L;
                    private final Class c$1;

                    public final List<InetSocketAddress> apply() {
                        Object instance;
                        Method open = this.c$1.getMethod("open", new Class[0]);
                        Method nameservers = this.c$1.getMethod("nameservers", new Class[0]);
                        java.util.List ns = (java.util.List)nameservers.invoke(instance = open.invoke(null, new Object[0]), new Object[0]);
                        if (ns.isEmpty()) {
                            throw new IllegalStateException("Empty nameservers list discovered using reflection. Consider configuring default nameservers manually!");
                        }
                        List<String> res = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(ns).asScala()).toList();
                        return res.flatMap(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterable<InetSocketAddress> apply(String s2) {
                                return Option$.MODULE$.option2Iterable(DnsSettings$.MODULE$.akka$io$dns$DnsSettings$$asInetSocketAddress$1(s2).toOption());
                            }
                        }, List$.MODULE$.canBuildFrom());
                    }
                    {
                        this.c$1 = c$1;
                    }
                });
            }
        });
    }

    private DnsSettings$() {
        MODULE$ = this;
        this.inetSocketAddress = new StringOps(Predef$.MODULE$.augmentString("(.*?)(?::(\\d+))?")).r();
    }
}

