/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.io.BufferPool;
import akka.io.DirectByteBufferPool$;
import java.nio.ByteBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q3Q!\u0001\u0002\u0001\t\u0019\u0011A\u0003R5sK\u000e$()\u001f;f\u0005V4g-\u001a:Q_>d'BA\u0002\u0005\u0003\tIwNC\u0001\u0006\u0003\u0011\t7n[1\u0014\u0007\u00019Q\u0002\u0005\u0002\t\u00175\t\u0011BC\u0001\u000b\u0003\u0015\u00198-\u00197b\u0013\ta\u0011B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001d=i\u0011AA\u0005\u0003!\t\u0011!BQ;gM\u0016\u0014\bk\\8m\u0011!\u0011\u0002A!A!\u0002\u0013!\u0012!\u00053fM\u0006,H\u000e\u001e\"vM\u001a,'oU5{K\u000e\u0001\u0001C\u0001\u0005\u0016\u0013\t1\u0012BA\u0002J]RD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u000f[\u0006D\bk\\8m\u000b:$(/[3t\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\u0019A$\b\u0010\u0011\u00059\u0001\u0001\"\u0002\n\u001a\u0001\u0004!\u0002\"\u0002\r\u001a\u0001\u0004!\u0002B\u0002\u0011\u0001A\u0003%\u0011%\u0001\u0003q_>d\u0007c\u0001\u0005#I%\u00111%\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003K)j\u0011A\n\u0006\u0003O!\n1A\\5p\u0015\u0005I\u0013\u0001\u00026bm\u0006L!a\u000b\u0014\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f\u0003\u0004.\u0001\u0001\u0006K\u0001F\u0001\u000eEV4g-\u001a:t\u0013:\u0004vn\u001c7\t\u000b=\u0002A\u0011\u0001\u0019\u0002\u000f\u0005\u001c\u0017/^5sKR\tA\u0005C\u00033\u0001\u0011\u00051'A\u0004sK2,\u0017m]3\u0015\u0005Q:\u0004C\u0001\u00056\u0013\t1\u0014B\u0001\u0003V]&$\b\"\u0002\u001d2\u0001\u0004!\u0013a\u00012vM\")!\b\u0001C\u0005w\u0005A\u0011\r\u001c7pG\u0006$X\r\u0006\u0002%y!)Q(\u000fa\u0001)\u0005!1/\u001b>f\u0011\u0015y\u0004\u0001\"\u00041\u0003I!\u0018m[3Ck\u001a4WM\u001d$s_6\u0004vn\u001c7\t\u000b\u0005\u0003AQ\u0002\"\u0002#=4g-\u001a:Ck\u001a4WM\u001d+p!>|G\u000e\u0006\u00025\u0007\")\u0001\b\u0011a\u0001I!)Q\t\u0001C\u0007\r\u0006ABO]=DY\u0016\fg\u000eR5sK\u000e$()\u001f;f\u0005V4g-\u001a:\u0015\u0005Q:\u0005\"\u0002%E\u0001\u0004!\u0013!\u0004;p\u0005\u0016$Um\u001d;s_f,Gm\u0002\u0004K\u0005!\u0005AaS\u0001\u0015\t&\u0014Xm\u0019;CsR,')\u001e4gKJ\u0004vn\u001c7\u0011\u00059aeAB\u0001\u0003\u0011\u0003!Qj\u0005\u0002M\u000f!)!\u0004\u0014C\u0001\u001fR\t1\nC\u0004R\u0019\n\u0007I\u0011\u0002*\u0002#\rcW-\u00198ESJ,7\r\u001e\"vM\u001a,'/F\u0001T!\u0011AA\u000b\n\u001b\n\u0005UK!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u00199F\n)A\u0005'\u0006\u00112\t\\3b]\u0012K'/Z2u\u0005V4g-\u001a:!\u0011\u0015)E\n\"\u0001Z)\t!$\fC\u0003\\1\u0002\u0007A%\u0001\u0006csR,')\u001e4gKJ\u0004")
public class DirectByteBufferPool
implements BufferPool {
    private final int defaultBufferSize;
    private final int maxPoolEntries;
    private final ByteBuffer[] pool;
    private int buffersInPool;

    @Override
    public ByteBuffer acquire() {
        return this.takeBufferFromPool();
    }

    @Override
    public void release(ByteBuffer buf) {
        this.offerBufferToPool(buf);
    }

    private ByteBuffer allocate(int size2) {
        return ByteBuffer.allocateDirect(size2);
    }

    private final ByteBuffer takeBufferFromPool() {
        ByteBuffer[] byteBufferArray = this.pool;
        synchronized (this.pool) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2;
            if (this.buffersInPool > 0) {
                --this.buffersInPool;
                byteBuffer2 = this.pool[this.buffersInPool];
            } else {
                byteBuffer2 = null;
            }
            ByteBuffer byteBuffer3 = byteBuffer2;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ByteBuffer buffer = byteBuffer3;
            if (buffer == null) {
                byteBuffer = this.allocate(this.defaultBufferSize);
            } else {
                buffer.clear();
                byteBuffer = buffer;
            }
            return byteBuffer;
        }
    }

    private final void offerBufferToPool(ByteBuffer buf) {
        ByteBuffer[] byteBufferArray = this.pool;
        synchronized (this.pool) {
            Boolean bl;
            if (this.buffersInPool < this.maxPoolEntries) {
                this.pool[this.buffersInPool] = buf;
                ++this.buffersInPool;
                bl = BoxesRunTime.boxToBoolean(false);
            } else {
                bl = BoxesRunTime.boxToBoolean(true);
            }
            Boolean bl2 = bl;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            boolean clean2 = BoxesRunTime.unboxToBoolean(bl2);
            if (clean2) {
                this.tryCleanDirectByteBuffer(buf);
            }
            return;
        }
    }

    private final void tryCleanDirectByteBuffer(ByteBuffer toBeDestroyed) {
        DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(toBeDestroyed);
    }

    public DirectByteBufferPool(int defaultBufferSize, int maxPoolEntries) {
        this.defaultBufferSize = defaultBufferSize;
        this.maxPoolEntries = maxPoolEntries;
        this.pool = new ByteBuffer[maxPoolEntries];
        this.buffersInPool = 0;
    }
}

