/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch.forkjoin;

import akka.dispatch.forkjoin.ThreadLocalRandom;
import akka.dispatch.forkjoin.TransferQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public class LinkedTransferQueue<E>
extends AbstractQueue<E>
implements TransferQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    private static final boolean MP = Runtime.getRuntime().availableProcessors() > 1;
    private static final int FRONT_SPINS = 128;
    private static final int CHAINED_SPINS = 64;
    static final int SWEEP_THRESHOLD = 32;
    volatile transient Node head;
    private volatile transient Node tail;
    private volatile transient int sweepVotes;
    private static final int NOW = 0;
    private static final int ASYNC = 1;
    private static final int SYNC = 2;
    private static final int TIMED = 3;
    private static final Unsafe UNSAFE;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long sweepVotesOffset;

    private boolean casTail(Node node4, Node node5) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, node4, node5);
    }

    private boolean casHead(Node node4, Node node5) {
        return UNSAFE.compareAndSwapObject(this, headOffset, node4, node5);
    }

    private boolean casSweepVotes(int n, int n2) {
        return UNSAFE.compareAndSwapInt(this, sweepVotesOffset, n, n2);
    }

    static <E> E cast(Object object) {
        return (E)object;
    }

    private E xfer(E e, boolean bl, int n, long l) {
        block8: {
            Node node4;
            if (bl && e == null) {
                throw new NullPointerException();
            }
            Node node5 = null;
            do {
                Node node6 = node4 = this.head;
                while (node6 != null) {
                    Node node7;
                    boolean bl2 = node6.isData;
                    Object object = node6.item;
                    if (object != node6 && object != null == bl2) {
                        if (bl2 == bl) break;
                        if (node6.casItem(object, e)) {
                            node7 = node6;
                            while (node7 != node4) {
                                Node node8 = node7.next;
                                if (this.head == node4 && this.casHead(node4, node8 == null ? node7 : node8)) {
                                    node4.forgetNext();
                                    break;
                                }
                                node4 = this.head;
                                if (node4 != null && (node7 = node4.next) != null && node7.isMatched()) continue;
                                break;
                            }
                            LockSupport.unpark(node6.waiter);
                            return LinkedTransferQueue.cast(object);
                        }
                    }
                    node6 = node6 != (node7 = node6.next) ? node7 : this.head;
                }
                if (n == 0) break block8;
                if (node5 != null) continue;
                node5 = new Node(e, bl);
            } while ((node4 = this.tryAppend(node5, bl)) == null);
            if (n != 1) {
                return this.awaitMatch(node5, node4, e, n == 3, l);
            }
        }
        return e;
    }

    private Node tryAppend(Node node4, boolean bl) {
        Node node5;
        Node node6 = node5 = this.tail;
        while (true) {
            if (node6 == null && (node6 = this.head) == null) {
                if (!this.casHead(null, node4)) continue;
                return node4;
            }
            if (node6.cannotPrecede(bl)) {
                return null;
            }
            Node node7 = node6.next;
            if (node7 != null) {
                Node node8;
                node6 = node6 != node5 && node5 != (node8 = this.tail) ? node8 : (node6 != node7 ? node7 : null);
                continue;
            }
            if (node6.casNext(null, node4)) break;
            node6 = node6.next;
        }
        if (node6 != node5) {
            while (!(this.tail == node5 && this.casTail(node5, node4) || (node5 = this.tail) == null || (node4 = node5.next) == null || (node4 = node4.next) == null || node4 == node5)) {
            }
        }
        return node6;
    }

    private E awaitMatch(Node node4, Node node5, E e, boolean bl, long l) {
        long l2 = bl ? System.nanoTime() : 0L;
        Thread thread = Thread.currentThread();
        int n = -1;
        Random random = null;
        while (true) {
            Object object;
            if ((object = node4.item) != e) {
                node4.forgetContents();
                return LinkedTransferQueue.cast(object);
            }
            if ((thread.isInterrupted() || bl && l <= 0L) && node4.casItem(e, node4)) {
                this.unsplice(node5, node4);
                return e;
            }
            if (n < 0) {
                n = LinkedTransferQueue.spinsFor(node5, node4.isData);
                if (n <= 0) continue;
                random = ThreadLocalRandom.current();
                continue;
            }
            if (n > 0) {
                --n;
                if (random.nextInt(64) != 0) continue;
                Thread.yield();
                continue;
            }
            if (node4.waiter == null) {
                node4.waiter = thread;
                continue;
            }
            if (bl) {
                long l3 = System.nanoTime();
                if ((l -= l3 - l2) > 0L) {
                    LockSupport.parkNanos(this, l);
                }
                l2 = l3;
                continue;
            }
            LockSupport.park(this);
        }
    }

    private static int spinsFor(Node node4, boolean bl) {
        if (MP && node4 != null) {
            if (node4.isData != bl) {
                return 192;
            }
            if (node4.isMatched()) {
                return 128;
            }
            if (node4.waiter == null) {
                return 64;
            }
        }
        return 0;
    }

    final Node succ(Node node4) {
        Node node5 = node4.next;
        return node4 == node5 ? this.head : node5;
    }

    private Node firstOfMode(boolean bl) {
        Node node4 = this.head;
        while (node4 != null) {
            if (!node4.isMatched()) {
                return node4.isData == bl ? node4 : null;
            }
            node4 = this.succ(node4);
        }
        return null;
    }

    private E firstDataItem() {
        Node node4 = this.head;
        while (node4 != null) {
            Object object = node4.item;
            if (node4.isData) {
                if (object != null && object != node4) {
                    return LinkedTransferQueue.cast(object);
                }
            } else if (object == null) {
                return null;
            }
            node4 = this.succ(node4);
        }
        return null;
    }

    private int countOfMode(boolean bl) {
        int n = 0;
        Node node4 = this.head;
        while (node4 != null) {
            Node node5;
            if (!node4.isMatched()) {
                if (node4.isData != bl) {
                    return 0;
                }
                if (++n == Integer.MAX_VALUE) break;
            }
            if ((node5 = node4.next) != node4) {
                node4 = node5;
                continue;
            }
            n = 0;
            node4 = this.head;
        }
        return n;
    }

    final void unsplice(Node node4, Node node5) {
        block6: {
            Node node6;
            node5.forgetContents();
            if (node4 == null || node4 == node5 || node4.next != node5 || (node6 = node5.next) != null && (node6 == node5 || !node4.casNext(node5, node6) || !node4.isMatched())) break block6;
            while (true) {
                Node node7;
                if ((node7 = this.head) == node4 || node7 == node5 || node7 == null) {
                    return;
                }
                if (!node7.isMatched()) break;
                Node node8 = node7.next;
                if (node8 == null) {
                    return;
                }
                if (node8 == node7 || !this.casHead(node7, node8)) continue;
                node7.forgetNext();
            }
            if (node4.next != node4 && node5.next != node5) {
                while (true) {
                    int n;
                    if ((n = this.sweepVotes) < 32) {
                        if (!this.casSweepVotes(n, n + 1)) continue;
                        break block6;
                    }
                    if (this.casSweepVotes(n, 0)) break;
                }
                this.sweep();
            }
        }
    }

    private void sweep() {
        Node node4;
        Node node5 = this.head;
        while (node5 != null && (node4 = node5.next) != null) {
            if (!node4.isMatched()) {
                node5 = node4;
                continue;
            }
            Node node6 = node4.next;
            if (node6 == null) break;
            if (node4 == node6) {
                node5 = this.head;
                continue;
            }
            node5.casNext(node4, node6);
        }
    }

    private boolean findAndRemove(Object object) {
        if (object != null) {
            Node node4 = null;
            Node node5 = this.head;
            while (node5 != null) {
                Object object2 = node5.item;
                if (node5.isData) {
                    if (object2 != null && object2 != node5 && object.equals(object2) && node5.tryMatchData()) {
                        this.unsplice(node4, node5);
                        return true;
                    }
                } else if (object2 == null) break;
                if ((node5 = node5.next) != (node4 = node5)) continue;
                node4 = null;
                node5 = this.head;
            }
        }
        return false;
    }

    public LinkedTransferQueue() {
    }

    public LinkedTransferQueue(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    @Override
    public void put(E e) {
        this.xfer(e, true, 1, 0L);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        this.xfer(e, true, 1, 0L);
        return true;
    }

    @Override
    public boolean offer(E e) {
        this.xfer(e, true, 1, 0L);
        return true;
    }

    @Override
    public boolean add(E e) {
        this.xfer(e, true, 1, 0L);
        return true;
    }

    @Override
    public boolean tryTransfer(E e) {
        return this.xfer(e, true, 0, 0L) == null;
    }

    @Override
    public void transfer(E e) throws InterruptedException {
        if (this.xfer(e, true, 2, 0L) != null) {
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    @Override
    public boolean tryTransfer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        if (this.xfer(e, true, 3, timeUnit.toNanos(l)) == null) {
            return true;
        }
        if (!Thread.interrupted()) {
            return false;
        }
        throw new InterruptedException();
    }

    @Override
    public E take() throws InterruptedException {
        E e = this.xfer(null, false, 2, 0L);
        if (e != null) {
            return e;
        }
        Thread.interrupted();
        throw new InterruptedException();
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        E e = this.xfer(null, false, 3, timeUnit.toNanos(l));
        if (e != null || !Thread.interrupted()) {
            return e;
        }
        throw new InterruptedException();
    }

    @Override
    public E poll() {
        return this.xfer(null, false, 0, 0L);
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        E e;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            collection.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        E e;
        int n2;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        for (n2 = 0; n2 < n && (e = this.poll()) != null; ++n2) {
            collection.add(e);
        }
        return n2;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public E peek() {
        return this.firstDataItem();
    }

    @Override
    public boolean isEmpty() {
        Node node4 = this.head;
        while (node4 != null) {
            if (!node4.isMatched()) {
                return !node4.isData;
            }
            node4 = this.succ(node4);
        }
        return true;
    }

    @Override
    public boolean hasWaitingConsumer() {
        return this.firstOfMode(false) != null;
    }

    @Override
    public int size() {
        return this.countOfMode(true);
    }

    @Override
    public int getWaitingConsumerCount() {
        return this.countOfMode(false);
    }

    @Override
    public boolean remove(Object object) {
        return this.findAndRemove(object);
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Node node4 = this.head;
        while (node4 != null) {
            Object object2 = node4.item;
            if (node4.isData) {
                if (object2 != null && object2 != node4 && object.equals(object2)) {
                    return true;
                }
            } else if (object2 == null) break;
            node4 = this.succ(node4);
        }
        return false;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (E e : this) {
            objectOutputStream.writeObject(e);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            this.offer(object);
        }
    }

    static Unsafe getUnsafe() {
        return akka.util.Unsafe.instance;
    }

    static {
        try {
            UNSAFE = LinkedTransferQueue.getUnsafe();
            Class<LinkedTransferQueue> clazz2 = LinkedTransferQueue.class;
            headOffset = UNSAFE.objectFieldOffset(clazz2.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(clazz2.getDeclaredField("tail"));
            sweepVotesOffset = UNSAFE.objectFieldOffset(clazz2.getDeclaredField("sweepVotes"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    final class Itr
    implements Iterator<E> {
        private Node nextNode;
        private E nextItem;
        private Node lastRet;
        private Node lastPred;

        private void advance(Node node4) {
            Node node5;
            Node node6;
            Node node7 = this.lastRet;
            if (node7 != null && !node7.isMatched()) {
                this.lastPred = node7;
            } else {
                Node node8 = this.lastPred;
                if (node8 == null || node8.isMatched()) {
                    this.lastPred = null;
                } else {
                    while ((node6 = node8.next) != null && node6 != node8 && node6.isMatched() && (node5 = node6.next) != null && node5 != node6) {
                        node8.casNext(node6, node5);
                    }
                }
            }
            this.lastRet = node4;
            node6 = node4;
            while (true) {
                Node node9 = node5 = node6 == null ? LinkedTransferQueue.this.head : node6.next;
                if (node5 == null) break;
                if (node5 == node6) {
                    node6 = null;
                    continue;
                }
                Object object = node5.item;
                if (node5.isData) {
                    if (object != null && object != node5) {
                        this.nextItem = LinkedTransferQueue.cast(object);
                        this.nextNode = node5;
                        return;
                    }
                } else if (object == null) break;
                if (node6 == null) {
                    node6 = node5;
                    continue;
                }
                Node node10 = node5.next;
                if (node10 == null) break;
                if (node5 == node10) {
                    node6 = null;
                    continue;
                }
                node6.casNext(node5, node10);
            }
            this.nextNode = null;
            this.nextItem = null;
        }

        Itr() {
            this.advance(null);
        }

        @Override
        public final boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public final E next() {
            Node node4 = this.nextNode;
            if (node4 == null) {
                throw new NoSuchElementException();
            }
            Object e = this.nextItem;
            this.advance(node4);
            return e;
        }

        @Override
        public final void remove() {
            Node node4 = this.lastRet;
            if (node4 == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            if (node4.tryMatchData()) {
                LinkedTransferQueue.this.unsplice(this.lastPred, node4);
            }
        }
    }

    static final class Node {
        final boolean isData;
        volatile Object item;
        volatile Node next;
        volatile Thread waiter;
        private static final long serialVersionUID = -3375979862319811754L;
        private static final Unsafe UNSAFE;
        private static final long itemOffset;
        private static final long nextOffset;
        private static final long waiterOffset;

        final boolean casNext(Node node4, Node node5) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, node4, node5);
        }

        final boolean casItem(Object object, Object object2) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, object, object2);
        }

        Node(Object object, boolean bl) {
            UNSAFE.putObject(this, itemOffset, object);
            this.isData = bl;
        }

        final void forgetNext() {
            UNSAFE.putObject(this, nextOffset, this);
        }

        final void forgetContents() {
            UNSAFE.putObject(this, itemOffset, this);
            UNSAFE.putObject(this, waiterOffset, null);
        }

        final boolean isMatched() {
            Object object = this.item;
            return object == this || object == null == this.isData;
        }

        final boolean isUnmatchedRequest() {
            return !this.isData && this.item == null;
        }

        final boolean cannotPrecede(boolean bl) {
            Object object;
            boolean bl2 = this.isData;
            return bl2 != bl && (object = this.item) != this && object != null == bl2;
        }

        final boolean tryMatchData() {
            Object object = this.item;
            if (object != null && object != this && this.casItem(object, null)) {
                LockSupport.unpark(this.waiter);
                return true;
            }
            return false;
        }

        static {
            try {
                UNSAFE = LinkedTransferQueue.getUnsafe();
                Class<Node> clazz2 = Node.class;
                itemOffset = UNSAFE.objectFieldOffset(clazz2.getDeclaredField("item"));
                nextOffset = UNSAFE.objectFieldOffset(clazz2.getDeclaredField("next"));
                waiterOffset = UNSAFE.objectFieldOffset(clazz2.getDeclaredField("waiter"));
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }
}

