/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.util.Unsafe;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractNodeQueue<T>
extends AtomicReference<Node<T>> {
    private volatile Node<T> _tailDoNotCallMeDirectly;
    private static final long tailOffset;

    protected AbstractNodeQueue() {
        Node node4 = new Node();
        this._tailDoNotCallMeDirectly = node4;
        this.set(node4);
    }

    protected final Node<T> peekNode() {
        Node node4 = (Node)Unsafe.instance.getObjectVolatile(this, tailOffset);
        Node node5 = node4.next();
        if (node5 == null && this.get() != node4) {
            while ((node5 = node4.next()) == null) {
            }
        }
        return node5;
    }

    public final T peek() {
        Node<T> node4 = this.peekNode();
        return node4 != null ? (T)node4.value : null;
    }

    public final void add(T t) {
        Node<T> node4 = new Node<T>(t);
        this.getAndSet(node4).setNext(node4);
    }

    public final void addNode(Node<T> node4) {
        node4.setNext(null);
        this.getAndSet(node4).setNext(node4);
    }

    public final boolean isEmpty() {
        return Unsafe.instance.getObjectVolatile(this, tailOffset) == this.get();
    }

    public final int count() {
        int n = 0;
        Node node4 = (Node)this.get();
        for (Node node5 = ((Node)Unsafe.instance.getObjectVolatile(this, tailOffset)).next(); node5 != null && n < Integer.MAX_VALUE; ++n, node5 = node5.next()) {
            if (node5 == node4) break;
        }
        return n;
    }

    public final T poll() {
        Node<T> node4 = this.pollNode();
        if (node4 == null) {
            return null;
        }
        Object t = node4.value;
        node4.value = null;
        return t;
    }

    public final Node<T> pollNode() {
        Node node4 = (Node)Unsafe.instance.getObjectVolatile(this, tailOffset);
        Node node5 = node4.next();
        if (node5 == null && this.get() != node4) {
            while ((node5 = node4.next()) == null) {
            }
        }
        if (node5 == null) {
            return null;
        }
        node4.value = node5.value;
        node5.value = null;
        Unsafe.instance.putOrderedObject(this, tailOffset, node5);
        node4.setNext(null);
        return node4;
    }

    static {
        try {
            tailOffset = Unsafe.instance.objectFieldOffset(AbstractNodeQueue.class.getDeclaredField("_tailDoNotCallMeDirectly"));
        }
        catch (Throwable throwable2) {
            throw new ExceptionInInitializerError(throwable2);
        }
    }

    public static class Node<T> {
        public T value;
        private volatile Node<T> _nextDoNotCallMeDirectly;
        private static final long nextOffset;

        public Node() {
            this(null);
        }

        public Node(T t) {
            this.value = t;
        }

        public final Node<T> next() {
            return (Node)Unsafe.instance.getObjectVolatile(this, nextOffset);
        }

        protected final void setNext(Node<T> node4) {
            Unsafe.instance.putOrderedObject(this, nextOffset, node4);
        }

        static {
            try {
                nextOffset = Unsafe.instance.objectFieldOffset(Node.class.getDeclaredField("_nextDoNotCallMeDirectly"));
            }
            catch (Throwable throwable2) {
                throw new ExceptionInInitializerError(throwable2);
            }
        }
    }
}

