/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.Actor;
import akka.actor.ActorCell;
import akka.actor.ActorInitializationException;
import akka.actor.ActorInitializationException$;
import akka.actor.DeadLetter;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.dungeon.AbstractActorCell;
import akka.actor.dungeon.SerializationCheckFailedException$;
import akka.dispatch.Envelope;
import akka.dispatch.Mailbox;
import akka.dispatch.MailboxType;
import akka.dispatch.ProducesMessageQueue;
import akka.dispatch.UnboundedMailbox;
import akka.dispatch.sysmsg.Create;
import akka.dispatch.sysmsg.Recreate;
import akka.dispatch.sysmsg.Resume;
import akka.dispatch.sysmsg.Supervise;
import akka.dispatch.sysmsg.Suspend;
import akka.dispatch.sysmsg.SystemMessage;
import akka.dispatch.sysmsg.Terminate;
import akka.event.Logging;
import akka.serialization.DisabledJavaSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import akka.util.Unsafe;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

public abstract class Dispatch$class {
    public static final Mailbox mailbox(ActorCell $this) {
        return (Mailbox)Unsafe.instance.getObjectVolatile($this, AbstractActorCell.mailboxOffset);
    }

    public static final Mailbox swapMailbox(ActorCell $this, Mailbox newMailbox) {
        while (true) {
            Mailbox oldMailbox;
            if (!Unsafe.instance.compareAndSwapObject($this, AbstractActorCell.mailboxOffset, oldMailbox = $this.mailbox(), newMailbox)) continue;
            return oldMailbox;
        }
    }

    public static final boolean hasMessages(ActorCell $this) {
        return $this.mailbox().hasMessages();
    }

    public static final int numberOfMessages(ActorCell $this) {
        return $this.mailbox().numberOfMessages();
    }

    public static final boolean isTerminated(ActorCell $this) {
        return $this.mailbox().isClosed();
    }

    public static final ActorCell init(ActorCell $this, boolean sendSupervise, MailboxType mailboxType) {
        Create create2;
        Mailbox mbox = $this.dispatcher().createMailbox($this, mailboxType);
        Class<? extends Actor> actorClass = $this.props().actorClass();
        MailboxType mailboxType2 = mailboxType;
        if (mailboxType2 instanceof ProducesMessageQueue && $this.system().mailboxes().hasRequiredType(actorClass)) {
            Create create23;
            Class<?> req = $this.system().mailboxes().getRequiredType(actorClass);
            if (req.isInstance(mbox.messageQueue())) {
                create23 = new Create(None$.MODULE$);
            } else {
                String gotType = mbox.messageQueue() == null ? "null" : mbox.messageQueue().getClass().getName();
                create23 = new Create(new Some<ActorInitializationException>(ActorInitializationException$.MODULE$.apply($this.self(), new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Actor [", "] requires mailbox type [", "] got [", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{$this.self(), req, gotType})), ActorInitializationException$.MODULE$.apply$default$3())));
            }
            create2 = create23;
        } else {
            create2 = new Create(None$.MODULE$);
        }
        Create createMessage = create2;
        $this.swapMailbox(mbox);
        $this.mailbox().setActor($this);
        $this.mailbox().systemEnqueue($this.self(), createMessage);
        if (sendSupervise) {
            $this.parent().sendSystemMessage(new Supervise($this.self(), false));
        }
        return $this;
    }

    public static final ActorCell initWithFailure(ActorCell $this, Throwable failure2) {
        Mailbox mbox = $this.dispatcher().createMailbox($this, new UnboundedMailbox());
        $this.swapMailbox(mbox);
        $this.mailbox().setActor($this);
        Create createMessage = new Create(new Some<ActorInitializationException>(ActorInitializationException$.MODULE$.apply($this.self(), "failure while creating ActorCell", failure2)));
        $this.mailbox().systemEnqueue($this.self(), createMessage);
        return $this;
    }

    public static ActorCell start(ActorCell $this) {
        $this.dispatcher().attach($this);
        return $this;
    }

    private static PartialFunction handleException(ActorCell $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InterruptedException) {
                    InterruptedException interruptedException = (InterruptedException)A1;
                    this.$outer.system().eventStream().publish(new Logging.Error(interruptedException, this.$outer.self().path().toString(), this.$outer.clazz(this.$outer.actor()), "interrupted during message send"));
                    Thread.currentThread().interrupt();
                    object = BoxedUnit.UNIT;
                } else {
                    Option<Throwable> option2 = NonFatal$.MODULE$.unapply(A1);
                    if (option2.isEmpty()) {
                        object = function1.apply(x1);
                    } else {
                        String string2;
                        Throwable e = option2.get();
                        Throwable throwable2 = e;
                        if (throwable2 instanceof NoStackTrace) {
                            NoStackTrace noStackTrace = (NoStackTrace)((Object)throwable2);
                            string2 = new StringBuilder().append((Object)"swallowing exception during message send: ").append((Object)((Throwable)((Object)noStackTrace)).getMessage()).toString();
                        } else {
                            string2 = "swallowing exception during message send";
                        }
                        String message = string2;
                        this.$outer.system().eventStream().publish(new Logging.Error(e, this.$outer.self().path().toString(), this.$outer.clazz(this.$outer.actor()), message));
                        object = BoxedUnit.UNIT;
                    }
                }
                return object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option<Throwable> option2;
                Throwable throwable2 = x1;
                boolean bl = throwable2 instanceof InterruptedException ? true : !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public static final void suspend(ActorCell $this) {
        Throwable throwable22;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Suspend());
            }
            catch (Throwable throwable22) {
                PartialFunction catchExpr$1 = Dispatch$class.handleException($this);
                if (!catchExpr$1.isDefinedAt(throwable22)) break block2;
                catchExpr$1.apply(throwable22);
            }
            return;
        }
        throw throwable22;
    }

    public static final void resume(ActorCell $this, Throwable causedByFailure) {
        Throwable throwable22;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Resume(causedByFailure));
            }
            catch (Throwable throwable22) {
                PartialFunction catchExpr$2 = Dispatch$class.handleException($this);
                if (!catchExpr$2.isDefinedAt(throwable22)) break block2;
                catchExpr$2.apply(throwable22);
            }
            return;
        }
        throw throwable22;
    }

    public static final void restart(ActorCell $this, Throwable cause) {
        Throwable throwable22;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Recreate(cause));
            }
            catch (Throwable throwable22) {
                PartialFunction catchExpr$3 = Dispatch$class.handleException($this);
                if (!catchExpr$3.isDefinedAt(throwable22)) break block2;
                catchExpr$3.apply(throwable22);
            }
            return;
        }
        throw throwable22;
    }

    public static final void stop(ActorCell $this) {
        Throwable throwable22;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Terminate());
            }
            catch (Throwable throwable22) {
                PartialFunction catchExpr$4 = Dispatch$class.handleException($this);
                if (!catchExpr$4.isDefinedAt(throwable22)) break block2;
                catchExpr$4.apply(throwable22);
            }
            return;
        }
        throw throwable22;
    }

    public static void sendMessage(ActorCell $this, Envelope msg) {
        Throwable throwable22;
        block2: {
            try {
                Envelope msgToDispatch = $this.system().settings().SerializeAllMessages() ? Dispatch$class.serializeAndDeserialize($this, msg) : msg;
                $this.dispatcher().dispatch($this, msgToDispatch);
            }
            catch (Throwable throwable22) {
                PartialFunction catchExpr$5 = Dispatch$class.handleException($this);
                if (!catchExpr$5.isDefinedAt(throwable22)) break block2;
                catchExpr$5.apply(throwable22);
            }
            return;
        }
        throw throwable22;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Envelope serializeAndDeserialize(ActorCell $this, Envelope envelope) {
        Envelope envelope3;
        Object object4;
        Object deserializedMsg;
        Object unwrappedMessage;
        Object object;
        Object object2 = envelope.message();
        if (object2 instanceof DeadLetter) {
            Object wrapped;
            DeadLetter deadLetter = (DeadLetter)object2;
            object = wrapped = deadLetter.message();
        } else {
            object = object2;
        }
        Object object3 = unwrappedMessage = object;
        if (object3 instanceof NoSerializationVerificationNeeded) {
            return envelope;
        }
        try {
            deserializedMsg = Dispatch$class.serializeAndDeserializePayload($this, object3);
            object4 = envelope.message();
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable3);
            if (option2.isEmpty()) {
                throw throwable2;
            }
            Throwable e = option2.get();
            throw SerializationCheckFailedException$.MODULE$.apply(object3, e);
        }
        if (object4 instanceof DeadLetter) {
            DeadLetter deadLetter = (DeadLetter)object4;
            envelope3 = envelope.copy(deadLetter.copy(deserializedMsg, deadLetter.copy$default$2(), deadLetter.copy$default$3()), envelope.copy$default$2());
            return envelope3;
        } else {
            envelope3 = envelope.copy(deserializedMsg, envelope.copy$default$2());
        }
        return envelope3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object serializeAndDeserializePayload(ActorCell $this, Object obj) {
        Object object;
        Serialization s2 = (Serialization)SerializationExtension$.MODULE$.apply($this.system());
        Serializer serializer = s2.findSerializerFor(obj);
        if (serializer instanceof DisabledJavaSerializer && !s2.shouldWarnAboutJavaSerializer(obj.getClass(), serializer)) {
            object = obj;
            return object;
        }
        Serialization.Information oldInfo = Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq($this.system().provider().serializationInformation());
            }
            byte[] bytes2 = serializer.toBinary(obj);
            String ms = Serializers$.MODULE$.manifestFor(serializer, obj);
            object = s2.deserialize(bytes2, serializer.identifier(), ms).get();
            Serialization$.MODULE$.currentTransportInformation().value_$eq(oldInfo);
            return object;
        }
        catch (Throwable throwable2) {
            void var4_4;
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Serialization.Information)var4_4);
            throw throwable2;
        }
    }

    public static void sendSystemMessage(ActorCell $this, SystemMessage message) {
        Throwable throwable22;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, message);
            }
            catch (Throwable throwable22) {
                PartialFunction catchExpr$6 = Dispatch$class.handleException($this);
                if (!catchExpr$6.isDefinedAt(throwable22)) break block2;
                catchExpr$6.apply(throwable22);
            }
            return;
        }
        throw throwable22;
    }

    public static void $init$(ActorCell $this) {
    }
}

