/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.hyperdrive.trigger.scheduler.eventProcessor;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import za.co.absa.hyperdrive.trigger.api.rest.services.DagInstanceService;
import za.co.absa.hyperdrive.trigger.models.DagDefinitionJoined;
import za.co.absa.hyperdrive.trigger.models.Event;
import za.co.absa.hyperdrive.trigger.persistance.DagDefinitionRepository;
import za.co.absa.hyperdrive.trigger.persistance.DagInstanceRepository;
import za.co.absa.hyperdrive.trigger.persistance.EventRepository;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001\u0002\u0006\f\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u001d\u0019\u0005A1A\u0005\n\u0011Ca!\u0014\u0001!\u0002\u0013)\u0005\"\u0002\u0007\u0001\t\u0003q\u0005bBA\u0003\u0001\u0011%\u0011q\u0001\u0002\u000f\u000bZ,g\u000e\u001e)s_\u000e,7o]8s\u0015\taQ\"\u0001\bfm\u0016tG\u000f\u0015:pG\u0016\u001c8o\u001c:\u000b\u00059y\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t\u0001\u0012#A\u0004ue&<w-\u001a:\u000b\u0005I\u0019\u0012A\u00035za\u0016\u0014HM]5wK*\u0011A#F\u0001\u0005C\n\u001c\u0018M\u0003\u0002\u0017/\u0005\u00111m\u001c\u0006\u00021\u0005\u0011!0Y\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VMZ\u0001\u0010KZ,g\u000e\u001e*fa>\u001c\u0018\u000e^8ssB\u00111EJ\u0007\u0002I)\u0011QeD\u0001\fa\u0016\u00148/[:uC:\u001cW-\u0003\u0002(I\tyQI^3oiJ+\u0007o\\:ji>\u0014\u00180A\feC\u001e$UMZ5oSRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u00111EK\u0005\u0003W\u0011\u0012q\u0003R1h\t\u00164\u0017N\\5uS>t'+\u001a9pg&$xN]=\u0002+\u0011\fw-\u00138ti\u0006t7-\u001a*fa>\u001c\u0018\u000e^8ssB\u00111EL\u0005\u0003_\u0011\u0012Q\u0003R1h\u0013:\u001cH/\u00198dKJ+\u0007o\\:ji>\u0014\u00180\u0001\neC\u001eLen\u001d;b]\u000e,7+\u001a:wS\u000e,\u0007C\u0001\u001a:\u001b\u0005\u0019$B\u0001\u001b6\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001\u001c8\u0003\u0011\u0011Xm\u001d;\u000b\u0005az\u0011aA1qS&\u0011!h\r\u0002\u0013\t\u0006<\u0017J\\:uC:\u001cWmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0006{}\u0002\u0015I\u0011\t\u0003}\u0001i\u0011a\u0003\u0005\u0006C\u0015\u0001\rA\t\u0005\u0006Q\u0015\u0001\r!\u000b\u0005\u0006Y\u0015\u0001\r!\f\u0005\u0006a\u0015\u0001\r!M\u0001\u0007Y><w-\u001a:\u0016\u0003\u0015\u0003\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u000bMdg\r\u000e6\u000b\u0003)\u000b1a\u001c:h\u0013\tauI\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!)\ty\u0005\u0010F\u0002Q?N$\"!\u0015.\u0011\u0007I+v+D\u0001T\u0015\t!V$\u0001\u0006d_:\u001cWO\u001d:f]RL!AV*\u0003\r\u0019+H/\u001e:f!\ta\u0002,\u0003\u0002Z;\t9!i\\8mK\u0006t\u0007\"B.\t\u0001\ba\u0016AA3d!\t\u0011V,\u0003\u0002_'\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006A\"\u0001\r!Y\u0001\u0007KZ,g\u000e^:\u0011\u0007\tTWN\u0004\u0002dQ:\u0011AmZ\u0007\u0002K*\u0011a-G\u0001\u0007yI|w\u000e\u001e \n\u0003yI!![\u000f\u0002\u000fA\f7m[1hK&\u00111\u000e\u001c\u0002\u0004'\u0016\f(BA5\u001e!\tq\u0017/D\u0001p\u0015\t\u0001x\"\u0001\u0004n_\u0012,Gn]\u0005\u0003e>\u0014Q!\u0012<f]RDQ\u0001\u001e\u0005A\u0002U\f\u0001b]3og>\u0014\u0018\n\u001a\t\u00039YL!a^\u000f\u0003\t1{gn\u001a\u0005\u0006s\"\u0001\rA_\u0001\fiJLwmZ3sK\u0012\u0014\u0015\u0010\u0005\u0002|\u007f:\u0011A0 \t\u0003IvI!A`\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t!a\u0001\u0003\rM#(/\u001b8h\u0015\tqX$A\u0007qe>\u001cWm]:Fm\u0016tGo\u001d\u000b\t\u0003\u0013\ti!a\u0004\u0002\u0012Q\u0019\u0011+a\u0003\t\u000bmK\u00019\u0001/\t\u000b\u0001L\u0001\u0019A1\t\u000bQL\u0001\u0019A;\t\u000beL\u0001\u0019\u0001>)\u0007\u0001\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u0015M$XM]3pif\u0004XMC\u0002\u0002 %\u000bqb\u001d9sS:<gM]1nK^|'o[\u0005\u0005\u0003G\tIBA\u0005D_6\u0004xN\\3oi\u0002")
public class EventProcessor {
    private final EventRepository eventRepository;
    private final DagDefinitionRepository dagDefinitionRepository;
    private final DagInstanceRepository dagInstanceRepository;
    private final DagInstanceService dagInstanceService;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public Future<Object> eventProcessor(String triggeredBy, Seq<Event> events, long sensorId, ExecutionContext ec) {
        Future fut = this.processEvents(events, sensorId, triggeredBy, ec);
        this.logger().debug(new StringBuilder(40).append("Processing events. Sensor id: ").append(sensorId).append(". Events: ").append(events.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)EventProcessor.$anonfun$eventProcessor$1((Event)x$1)), Seq$.MODULE$.canBuildFrom())).toString());
        return fut;
    }

    private Future<Object> processEvents(Seq<Event> events, long sensorId, String triggeredBy, ExecutionContext ec) {
        return this.eventRepository.getExistEvents((Seq)events.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.sensorEventId(), Seq$.MODULE$.canBuildFrom()), ec).flatMap((Function1 & Serializable & scala.Serializable)eventsIdsInDB -> {
            Seq newEvents = (Seq)events.filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)EventProcessor.$anonfun$processEvents$3((Seq)eventsIdsInDB, (Event)e)));
            return newEvents.nonEmpty() ? $this.dagDefinitionRepository.getJoinedDagDefinition(sensorId, ec).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Future future;
                Option option = x0$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DagDefinitionJoined joinedDagDefinition = (DagDefinitionJoined)some.value();
                    future = $this.dagInstanceRepository.hasInQueueDagInstance(joinedDagDefinition.workflowId(), ec).flatMap((Function1 & Serializable & scala.Serializable)hasInQueueDagInstance -> EventProcessor.$anonfun$processEvents$5((EventProcessor)this, (DagDefinitionJoined)joinedDagDefinition, (String)triggeredBy, (ExecutionContext)ec, (Seq)newEvents, (boolean)BoxesRunTime.unboxToBoolean((Object)hasInQueueDagInstance)), ec);
                } else if (None$.MODULE$.equals(option)) {
                    future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
                } else {
                    throw new MatchError((Object)option);
                }
                return future;
            }, ec) : Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, ec);
    }

    public static final /* synthetic */ long $anonfun$eventProcessor$1(Event x$1) {
        return x$1.id();
    }

    public static final /* synthetic */ boolean $anonfun$processEvents$3(Seq eventsIdsInDB$1, Event e) {
        return !eventsIdsInDB$1.contains((Object)e.sensorEventId());
    }

    public static final /* synthetic */ boolean $anonfun$processEvents$9(BoxedUnit _) {
        return true;
    }

    public static final /* synthetic */ Future $anonfun$processEvents$5(EventProcessor $this, DagDefinitionJoined joinedDagDefinition$1, String triggeredBy$1, ExecutionContext ec$1, Seq newEvents$1, boolean hasInQueueDagInstance) {
        return $this.dagInstanceService.createDagInstance(joinedDagDefinition$1, triggeredBy$1, hasInQueueDagInstance, ec$1).map((Function1 & Serializable & scala.Serializable)dagInstanceJoined -> {
            Seq dagInstanceJoinedEvents = (Seq)newEvents$1.map((Function1 & Serializable & scala.Serializable)event -> new Tuple2(dagInstanceJoined, event), Seq$.MODULE$.canBuildFrom());
            return new Tuple2(dagInstanceJoined, (Object)dagInstanceJoinedEvents);
        }, ec$1).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq dagInstanceJoinedEvents = (Seq)tuple2._2();
            Future future = $this.dagInstanceRepository.insertJoinedDagInstancesWithEvents(dagInstanceJoinedEvents, ec$1).map((Function1 & Serializable & scala.Serializable)_ -> BoxesRunTime.boxToBoolean((boolean)EventProcessor.$anonfun$processEvents$9((BoxedUnit)_)), ec$1);
            return future;
        }, ec$1);
    }

    public EventProcessor(EventRepository eventRepository, DagDefinitionRepository dagDefinitionRepository, DagInstanceRepository dagInstanceRepository, DagInstanceService dagInstanceService) {
        this.eventRepository = eventRepository;
        this.dagDefinitionRepository = dagDefinitionRepository;
        this.dagInstanceRepository = dagInstanceRepository;
        this.dagInstanceService = dagInstanceService;
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
    }
}

