/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.commons.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import za.co.absa.commons.io.TempDirectory$;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u001b\tiA+Z7q\t&\u0014Xm\u0019;pefT!a\u0001\u0003\u0002\u0005%|'BA\u0003\u0007\u0003\u001d\u0019w.\\7p]NT!a\u0002\u0005\u0002\t\u0005\u00147/\u0019\u0006\u0003\u0013)\t!aY8\u000b\u0003-\t!A_1\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!\u0011!Q\u0001\nY\ta\u0001\u001d:fM&D\bCA\f\u001b\u001d\ty\u0001$\u0003\u0002\u001a!\u00051\u0001K]3eK\u001aL!a\u0007\u000f\u0003\rM#(/\u001b8h\u0015\tI\u0002\u0003\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003\u0017\u0003\u0019\u0019XO\u001a4jq\"A\u0001\u0005\u0001B\u0001B\u0003%\u0011%\u0001\u0005qCRDwJ\u001c7z!\ty!%\u0003\u0002$!\t9!i\\8mK\u0006t\u0007\"B\u0013\u0001\t\u00131\u0013A\u0002\u001fj]&$h\b\u0006\u0003(S)Z\u0003C\u0001\u0015\u0001\u001b\u0005\u0011\u0001\"B\u000b%\u0001\u00041\u0002\"\u0002\u0010%\u0001\u00041\u0002\"\u0002\u0011%\u0001\u0004\t\u0003bB\u0017\u0001\u0005\u0004%\tAL\u0001\u0005a\u0006$\b.F\u00010!\t\u0001t'D\u00012\u0015\t\u00114'\u0001\u0003gS2,'B\u0001\u001b6\u0003\rq\u0017n\u001c\u0006\u0002m\u0005!!.\u0019<b\u0013\tA\u0014G\u0001\u0003QCRD\u0007B\u0002\u001e\u0001A\u0003%q&A\u0003qCRD\u0007\u0005\u0003\u0005=\u0001!\u0015\r\u0011\"\u0003>\u0003\u0011Awn\\6\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!Q\u001b\u0002\t1\fgnZ\u0005\u0003\u0007\u0002\u0013a\u0001\u00165sK\u0006$\u0007\u0002C#\u0001\u0011\u0003\u0005\u000b\u0015\u0002 \u0002\u000b!|wn\u001b\u0011\t\u000b\u001d\u0003A\u0011\u0001%\u0002\u0019\u0011,G.\u001a;f\u001f:,\u00050\u001b;\u0015\u0003%k\u0011\u0001\u0001\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u0007I\u0016dW\r^3\u0015\u00035\u0003\"a\u0004(\n\u0005=\u0003\"\u0001B+oSRDQ!\u0015\u0001\u0005\u0002I\u000bQ\u0001^8V%&+\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-V\n1A\\3u\u0013\tAVKA\u0002V%&CQA\u0017\u0001\u0005Bm\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002-\u001d)QL\u0001E\u0001=\u0006iA+Z7q\t&\u0014Xm\u0019;pef\u0004\"\u0001K0\u0007\u000b\u0005\u0011\u0001\u0012\u00011\u0014\u0005}s\u0001\"B\u0013`\t\u0003\u0011G#\u00010\t\u000b\u0011|F\u0011A3\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\u001d2w\r\u001b\u0005\b+\r\u0004\n\u00111\u0001\u0017\u0011\u001dq2\r%AA\u0002YAq\u0001I2\u0011\u0002\u0003\u0007\u0011\u0005C\u0004k?F\u0005I\u0011A6\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001c\u0016\u0003-5\\\u0013A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005M\u0004\u0012AC1o]>$\u0018\r^5p]&\u0011Q\u000f\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007bB<`#\u0003%\ta[\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e!9\u0011pXI\u0001\n\u0003Q\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003mT#!I7")
public class TempDirectory {
    private final Path path;
    private Thread hook;
    private volatile boolean bitmap$0;

    public static boolean apply$default$3() {
        return TempDirectory$.MODULE$.apply$default$3();
    }

    public static String apply$default$2() {
        return TempDirectory$.MODULE$.apply$default$2();
    }

    public static String apply$default$1() {
        return TempDirectory$.MODULE$.apply$default$1();
    }

    public static TempDirectory apply(String string, String string2, boolean bl) {
        return TempDirectory$.MODULE$.apply(string, string2, bl);
    }

    private Thread hook$lzycompute() {
        TempDirectory tempDirectory = this;
        synchronized (tempDirectory) {
            if (!this.bitmap$0) {
                this.hook = new Thread(this){
                    private final /* synthetic */ TempDirectory $outer;

                    public void run() {
                        this.$outer.delete();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                this.bitmap$0 = true;
            }
            return this.hook;
        }
    }

    public Path path() {
        return this.path;
    }

    private Thread hook() {
        return this.bitmap$0 ? this.hook : this.hook$lzycompute();
    }

    public synchronized TempDirectory deleteOnExit() {
        Runtime.getRuntime().removeShutdownHook(this.hook());
        Runtime.getRuntime().addShutdownHook(this.hook());
        return this;
    }

    public void delete() {
        TempDirectory tempDirectory = this;
        synchronized (tempDirectory) {
            Object object = Files.exists(this.path(), new LinkOption[0]) ? Files.walkFileTree(this.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    FileUtils.deleteQuietly((File)file.toFile());
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    FileUtils.deleteQuietly((File)dir.toFile());
                    return FileVisitResult.CONTINUE;
                }
            }) : BoxedUnit.UNIT;
            return;
        }
    }

    public URI toURI() {
        return this.path().toFile().toURI();
    }

    public String toString() {
        return ((Object)this.path()).toString().replace("\\", "/");
    }

    public TempDirectory(String prefix, String suffix, boolean pathOnly) {
        this.path = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        Files.delete(this.path());
        Object object = pathOnly ? BoxedUnit.UNIT : Files.createDirectory(this.path(), new FileAttribute[0]);
    }
}

