/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.examples;

import java.util.Properties;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.DataStreamReader;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.SymbolLiteral;
import za.co.absa.abris.avro.functions$;
import za.co.absa.abris.avro.read.confluent.SchemaManager$;
import za.co.absa.abris.examples.utils.ExamplesUtils$;

public final class ConfluentKafkaAvroReaderWithKey$ {
    public static ConfluentKafkaAvroReaderWithKey$ MODULE$;
    private final String PARAM_JOB_NAME;
    private final String PARAM_JOB_MASTER;
    private final String PARAM_PAYLOAD_AVRO_SCHEMA;
    private final String PARAM_KEY_AVRO_SCHEMA;
    private final String PARAM_LOG_LEVEL;
    private final String PARAM_OPTION_SUBSCRIBE;
    private final String PARAM_EXAMPLE_SHOULD_USE_SCHEMA_REGISTRY;
    private final String PARAM_KEY_SCHEMA_NAME;
    private final String PARAM_KEY_SCHEMA_NAMESPACE;
    private final String PARAM_VALUE_SCHEMA_NAME;
    private final String PARAM_VALUE_SCHEMA_NAMESPACE;

    static {
        new ConfluentKafkaAvroReaderWithKey$();
    }

    private String PARAM_JOB_NAME() {
        return this.PARAM_JOB_NAME;
    }

    private String PARAM_JOB_MASTER() {
        return this.PARAM_JOB_MASTER;
    }

    private String PARAM_PAYLOAD_AVRO_SCHEMA() {
        return this.PARAM_PAYLOAD_AVRO_SCHEMA;
    }

    private String PARAM_KEY_AVRO_SCHEMA() {
        return this.PARAM_KEY_AVRO_SCHEMA;
    }

    private String PARAM_LOG_LEVEL() {
        return this.PARAM_LOG_LEVEL;
    }

    private String PARAM_OPTION_SUBSCRIBE() {
        return this.PARAM_OPTION_SUBSCRIBE;
    }

    private String PARAM_EXAMPLE_SHOULD_USE_SCHEMA_REGISTRY() {
        return this.PARAM_EXAMPLE_SHOULD_USE_SCHEMA_REGISTRY;
    }

    private String PARAM_KEY_SCHEMA_NAME() {
        return this.PARAM_KEY_SCHEMA_NAME;
    }

    private String PARAM_KEY_SCHEMA_NAMESPACE() {
        return this.PARAM_KEY_SCHEMA_NAMESPACE;
    }

    private String PARAM_VALUE_SCHEMA_NAME() {
        return this.PARAM_VALUE_SCHEMA_NAME;
    }

    private String PARAM_VALUE_SCHEMA_NAMESPACE() {
        return this.PARAM_VALUE_SCHEMA_NAMESPACE;
    }

    public void main(String[] args) {
        ExamplesUtils$.MODULE$.checkArgs(args);
        Properties properties = ExamplesUtils$.MODULE$.loadProperties(args);
        SparkSession spark = ExamplesUtils$.MODULE$.getSparkSession(properties, this.PARAM_JOB_NAME(), this.PARAM_JOB_MASTER(), this.PARAM_LOG_LEVEL());
        DataStreamReader stream = ExamplesUtils$.MODULE$.ReaderStreamOptions(spark.readStream().format("kafka")).addOptions(properties);
        Dataset<Row> deserialized = this.configureExample((Dataset<Row>)stream.load(), (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala()).toMap(Predef$.MODULE$.$conforms()));
        deserialized.printSchema();
        deserialized.writeStream().format("console").option("truncate", "false").start().awaitTermination();
    }

    private Dataset<Row> configureExample(Dataset<Row> dataFrame, Map<String, String> properties) {
        Dataset dataset;
        Map commonRegistryConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_REGISTRY_TOPIC()), properties.apply((Object)this.PARAM_OPTION_SUBSCRIBE())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_REGISTRY_URL()), properties.apply((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_REGISTRY_URL())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_KEY_SCHEMA_NAME_FOR_RECORD_STRATEGY()), properties.apply((Object)this.PARAM_KEY_SCHEMA_NAME())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_KEY_SCHEMA_NAMESPACE_FOR_RECORD_STRATEGY()), properties.apply((Object)this.PARAM_KEY_SCHEMA_NAMESPACE())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_VALUE_SCHEMA_NAME_FOR_RECORD_STRATEGY()), properties.apply((Object)this.PARAM_VALUE_SCHEMA_NAME())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_VALUE_SCHEMA_NAMESPACE_FOR_RECORD_STRATEGY()), properties.apply((Object)this.PARAM_VALUE_SCHEMA_NAMESPACE()))}));
        Map valueRegistryConfig = commonRegistryConfig.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_VALUE_SCHEMA_NAMING_STRATEGY()), properties.apply((Object)SchemaManager$.MODULE$.PARAM_VALUE_SCHEMA_NAMING_STRATEGY())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_VALUE_SCHEMA_ID()), properties.apply((Object)SchemaManager$.MODULE$.PARAM_VALUE_SCHEMA_ID()))})));
        Map keyRegistryConfig = commonRegistryConfig.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_KEY_SCHEMA_NAMING_STRATEGY()), properties.apply((Object)SchemaManager$.MODULE$.PARAM_KEY_SCHEMA_NAMING_STRATEGY())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_KEY_SCHEMA_ID()), properties.apply((Object)SchemaManager$.MODULE$.PARAM_KEY_SCHEMA_ID()))})));
        if (new StringOps(Predef$.MODULE$.augmentString((String)properties.apply((Object)this.PARAM_EXAMPLE_SHOULD_USE_SCHEMA_REGISTRY()))).toBoolean()) {
            dataset = dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_confluent_avro(org.apache.spark.sql.functions$.MODULE$.col("key"), (Map<String, String>)keyRegistryConfig).as((Symbol)SymbolLiteral.bootstrap("apply", "key")), functions$.MODULE$.from_confluent_avro(org.apache.spark.sql.functions$.MODULE$.col("value"), (Map<String, String>)valueRegistryConfig).as((Symbol)SymbolLiteral.bootstrap("apply", "value"))}));
        } else {
            String valueSchema = this.loadSchemaFromFile((String)properties.apply((Object)this.PARAM_PAYLOAD_AVRO_SCHEMA()));
            String keySchema = this.loadSchemaFromFile((String)properties.apply((Object)this.PARAM_KEY_AVRO_SCHEMA()));
            dataset = dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_confluent_avro(org.apache.spark.sql.functions$.MODULE$.col("key"), keySchema, (Map<String, String>)keyRegistryConfig).as((Symbol)SymbolLiteral.bootstrap("apply", "key")), functions$.MODULE$.from_confluent_avro(org.apache.spark.sql.functions$.MODULE$.col("value"), valueSchema, (Map<String, String>)valueRegistryConfig).as((Symbol)SymbolLiteral.bootstrap("apply", "value"))}));
        }
        return dataset;
    }

    private String loadSchemaFromFile(String path) {
        String string;
        try (BufferedSource source = Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        return string;
    }

    private ConfluentKafkaAvroReaderWithKey$() {
        MODULE$ = this;
        this.PARAM_JOB_NAME = "job.name";
        this.PARAM_JOB_MASTER = "job.master";
        this.PARAM_PAYLOAD_AVRO_SCHEMA = "payload.avro.schema";
        this.PARAM_KEY_AVRO_SCHEMA = "key.avro.schema";
        this.PARAM_LOG_LEVEL = "log.level";
        this.PARAM_OPTION_SUBSCRIBE = "option.subscribe";
        this.PARAM_EXAMPLE_SHOULD_USE_SCHEMA_REGISTRY = "example.should.use.schema.registry";
        this.PARAM_KEY_SCHEMA_NAME = "key.schema.name";
        this.PARAM_KEY_SCHEMA_NAMESPACE = "key.schema.namespace";
        this.PARAM_VALUE_SCHEMA_NAME = "value.schema.name";
        this.PARAM_VALUE_SCHEMA_NAMESPACE = "value.schema.namespace";
    }
}

