/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.examples;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.types.StructType;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.SymbolLiteral;
import za.co.absa.abris.avro.format.SparkAvroConversions$;
import za.co.absa.abris.avro.functions$;
import za.co.absa.abris.avro.parsing.utils.AvroSchemaUtils$;
import za.co.absa.abris.avro.read.confluent.SchemaManager$;
import za.co.absa.abris.examples.data.generation.ComplexRecordsGenerator$;
import za.co.absa.abris.examples.utils.ExamplesUtils$;

public final class ConfluentKafkaAvroWriter$ {
    public static ConfluentKafkaAvroWriter$ MODULE$;
    private final String PARAM_JOB_NAME;
    private final String PARAM_JOB_MASTER;
    private final String PARAM_PAYLOAD_AVRO_SCHEMA;
    private final String PARAM_KEY_AVRO_RECORD_NAME;
    private final String PARAM_KEY_AVRO_RECORD_NAMESPACE;
    private final String PARAM_VALUE_AVRO_RECORD_NAME;
    private final String PARAM_VALUE_AVRO_RECORD_NAMESPACE;
    private final String PARAM_INFER_SCHEMA;
    private final String PARAM_LOG_LEVEL;
    private final String PARAM_TEST_DATA_ENTRIES;
    private final String PARAM_EXECUTION_REPEAT;
    private final String PARAM_NUM_PARTITIONS;
    private final String PARAM_TOPIC;

    static {
        new ConfluentKafkaAvroWriter$();
    }

    private String PARAM_JOB_NAME() {
        return this.PARAM_JOB_NAME;
    }

    private String PARAM_JOB_MASTER() {
        return this.PARAM_JOB_MASTER;
    }

    private String PARAM_PAYLOAD_AVRO_SCHEMA() {
        return this.PARAM_PAYLOAD_AVRO_SCHEMA;
    }

    private String PARAM_KEY_AVRO_RECORD_NAME() {
        return this.PARAM_KEY_AVRO_RECORD_NAME;
    }

    private String PARAM_KEY_AVRO_RECORD_NAMESPACE() {
        return this.PARAM_KEY_AVRO_RECORD_NAMESPACE;
    }

    private String PARAM_VALUE_AVRO_RECORD_NAME() {
        return this.PARAM_VALUE_AVRO_RECORD_NAME;
    }

    private String PARAM_VALUE_AVRO_RECORD_NAMESPACE() {
        return this.PARAM_VALUE_AVRO_RECORD_NAMESPACE;
    }

    private String PARAM_INFER_SCHEMA() {
        return this.PARAM_INFER_SCHEMA;
    }

    private String PARAM_LOG_LEVEL() {
        return this.PARAM_LOG_LEVEL;
    }

    private String PARAM_TEST_DATA_ENTRIES() {
        return this.PARAM_TEST_DATA_ENTRIES;
    }

    private String PARAM_EXECUTION_REPEAT() {
        return this.PARAM_EXECUTION_REPEAT;
    }

    private String PARAM_NUM_PARTITIONS() {
        return this.PARAM_NUM_PARTITIONS;
    }

    private String PARAM_TOPIC() {
        return this.PARAM_TOPIC;
    }

    public void main(String[] args) {
        ExamplesUtils$.MODULE$.checkArgs(args);
        Properties properties = ExamplesUtils$.MODULE$.loadProperties(args);
        SparkSession spark = ExamplesUtils$.MODULE$.getSparkSession(properties, this.PARAM_JOB_NAME(), this.PARAM_JOB_MASTER(), this.PARAM_LOG_LEVEL());
        spark.sparkContext().setLogLevel(properties.getProperty(this.PARAM_LOG_LEVEL()));
        Encoder<Row> encoder = this.getEncoder();
        do {
            List<Row> rows = this.createRows(new StringOps(Predef$.MODULE$.augmentString(properties.getProperty(this.PARAM_TEST_DATA_ENTRIES()).trim())).toInt());
            Dataset dataFrame = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize(rows, new StringOps(Predef$.MODULE$.augmentString(properties.getProperty(this.PARAM_NUM_PARTITIONS()))).toInt(), ClassTag$.MODULE$.apply(Row.class)), encoder).toDF();
            dataFrame.show(false);
            ExamplesUtils$.MODULE$.WriterRowOptions((DataFrameWriter<Row>)this.toAvro((Dataset<Row>)dataFrame, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala()).toMap(Predef$.MODULE$.$conforms())).write().format("kafka")).addOptions(properties).save();
        } while (new StringOps(Predef$.MODULE$.augmentString(properties.getProperty(this.PARAM_EXECUTION_REPEAT()))).toBoolean());
    }

    private Dataset<Row> toAvro(Dataset<Row> dataFrame, Map<String, String> properties) {
        String string;
        Map registryConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_REGISTRY_TOPIC()), properties.apply((Object)this.PARAM_TOPIC())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_REGISTRY_URL()), properties.apply((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_REGISTRY_URL())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_VALUE_SCHEMA_NAMING_STRATEGY()), properties.apply((Object)SchemaManager$.MODULE$.PARAM_VALUE_SCHEMA_NAMING_STRATEGY())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_KEY_SCHEMA_NAME_FOR_RECORD_STRATEGY()), properties.apply((Object)this.PARAM_VALUE_AVRO_RECORD_NAME())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_KEY_SCHEMA_NAMESPACE_FOR_RECORD_STRATEGY()), properties.apply((Object)this.PARAM_VALUE_AVRO_RECORD_NAMESPACE())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_VALUE_SCHEMA_NAME_FOR_RECORD_STRATEGY()), properties.apply((Object)this.PARAM_VALUE_AVRO_RECORD_NAME())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SchemaManager$.MODULE$.PARAM_VALUE_SCHEMA_NAMESPACE_FOR_RECORD_STRATEGY()), properties.apply((Object)this.PARAM_VALUE_AVRO_RECORD_NAMESPACE()))}));
        try (BufferedSource source = Source$.MODULE$.fromFile((String)properties.apply((Object)this.PARAM_PAYLOAD_AVRO_SCHEMA()), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String schemaString = string;
        boolean inferSchema = new StringOps(Predef$.MODULE$.augmentString(((String)properties.apply((Object)this.PARAM_INFER_SCHEMA())).trim())).toBoolean();
        Column allColumns = org.apache.spark.sql.functions$.MODULE$.struct((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFrame.columns())).head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFrame.columns())).tail()));
        return inferSchema ? dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.to_confluent_avro(allColumns, (Map<String, String>)registryConfig).as((Symbol)SymbolLiteral.bootstrap("apply", "value"))})) : dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.to_confluent_avro(allColumns, schemaString, (Map<String, String>)registryConfig).as((Symbol)SymbolLiteral.bootstrap("apply", "value"))}));
    }

    private List<Row> createRows(int howMany) {
        return ComplexRecordsGenerator$.MODULE$.generateUnparsedRows(howMany);
    }

    private Encoder<Row> getEncoder() {
        Schema avroSchema = AvroSchemaUtils$.MODULE$.parse(ComplexRecordsGenerator$.MODULE$.usedAvroSchema());
        StructType sparkSchema = SparkAvroConversions$.MODULE$.toSqlType(avroSchema);
        return RowEncoder$.MODULE$.apply(sparkSchema);
    }

    private ConfluentKafkaAvroWriter$() {
        MODULE$ = this;
        this.PARAM_JOB_NAME = "job.name";
        this.PARAM_JOB_MASTER = "job.master";
        this.PARAM_PAYLOAD_AVRO_SCHEMA = "payload.avro.schema";
        this.PARAM_KEY_AVRO_RECORD_NAME = "avro.key.record.name";
        this.PARAM_KEY_AVRO_RECORD_NAMESPACE = "avro.key.record.namespace";
        this.PARAM_VALUE_AVRO_RECORD_NAME = "avro.value.record.name";
        this.PARAM_VALUE_AVRO_RECORD_NAMESPACE = "avro.value.record.namespace";
        this.PARAM_INFER_SCHEMA = "infer.schema";
        this.PARAM_LOG_LEVEL = "log.level";
        this.PARAM_TEST_DATA_ENTRIES = "test.data.entries";
        this.PARAM_EXECUTION_REPEAT = "execution.repeat";
        this.PARAM_NUM_PARTITIONS = "num.partitions";
        this.PARAM_TOPIC = "option.topic";
    }
}

