/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.examples.deprecated;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.types.StructType;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import za.co.absa.abris.avro.AvroSerDe$;
import za.co.absa.abris.avro.format.SparkAvroConversions$;
import za.co.absa.abris.avro.parsing.utils.AvroSchemaUtils$;
import za.co.absa.abris.examples.data.generation.ComplexRecordsGenerator$;
import za.co.absa.abris.examples.utils.ExamplesUtils$;

public final class KafkaAvroWriter$ {
    public static KafkaAvroWriter$ MODULE$;
    private final String PARAM_JOB_NAME;
    private final String PARAM_JOB_MASTER;
    private final String PARAM_KEY_AVRO_SCHEMA;
    private final String PARAM_PAYLOAD_AVRO_SCHEMA;
    private final String PARAM_AVRO_RECORD_NAME;
    private final String PARAM_AVRO_RECORD_NAMESPACE;
    private final String PARAM_INFER_SCHEMA;
    private final String PARAM_LOG_LEVEL;
    private final String PARAM_TEST_DATA_ENTRIES;
    private final String PARAM_EXECUTION_REPEAT;
    private final String PARAM_NUM_PARTITIONS;

    static {
        new KafkaAvroWriter$();
    }

    private String PARAM_JOB_NAME() {
        return this.PARAM_JOB_NAME;
    }

    private String PARAM_JOB_MASTER() {
        return this.PARAM_JOB_MASTER;
    }

    private String PARAM_KEY_AVRO_SCHEMA() {
        return this.PARAM_KEY_AVRO_SCHEMA;
    }

    private String PARAM_PAYLOAD_AVRO_SCHEMA() {
        return this.PARAM_PAYLOAD_AVRO_SCHEMA;
    }

    private String PARAM_AVRO_RECORD_NAME() {
        return this.PARAM_AVRO_RECORD_NAME;
    }

    private String PARAM_AVRO_RECORD_NAMESPACE() {
        return this.PARAM_AVRO_RECORD_NAMESPACE;
    }

    private String PARAM_INFER_SCHEMA() {
        return this.PARAM_INFER_SCHEMA;
    }

    private String PARAM_LOG_LEVEL() {
        return this.PARAM_LOG_LEVEL;
    }

    private String PARAM_TEST_DATA_ENTRIES() {
        return this.PARAM_TEST_DATA_ENTRIES;
    }

    private String PARAM_EXECUTION_REPEAT() {
        return this.PARAM_EXECUTION_REPEAT;
    }

    private String PARAM_NUM_PARTITIONS() {
        return this.PARAM_NUM_PARTITIONS;
    }

    public void main(String[] args) {
        ExamplesUtils$.MODULE$.checkArgs(args);
        Properties properties = ExamplesUtils$.MODULE$.loadProperties(args);
        SparkSession spark = ExamplesUtils$.MODULE$.getSparkSession(properties, this.PARAM_JOB_NAME(), this.PARAM_JOB_MASTER(), this.PARAM_LOG_LEVEL());
        Encoder<Row> encoder = this.getEncoder();
        do {
            List<Row> rows = this.createRows(new StringOps(Predef$.MODULE$.augmentString(properties.getProperty(this.PARAM_TEST_DATA_ENTRIES()).trim())).toInt());
            Dataset dataframe = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize(rows, new StringOps(Predef$.MODULE$.augmentString(properties.getProperty(this.PARAM_NUM_PARTITIONS()))).toInt(), ClassTag$.MODULE$.apply(Row.class)), encoder).toDF();
            dataframe.show();
            ExamplesUtils$.MODULE$.WriterOptions((DataFrameWriter<byte[]>)this.toAvro((Dataset<Row>)dataframe, properties).write().format("kafka")).addOptions(properties).save();
        } while (new StringOps(Predef$.MODULE$.augmentString(properties.getProperty(this.PARAM_EXECUTION_REPEAT()))).toBoolean());
    }

    private Dataset<byte[]> toAvro(Dataset<Row> dataframe, Properties properties) {
        return new StringOps(Predef$.MODULE$.augmentString(properties.getProperty(this.PARAM_INFER_SCHEMA()).trim())).toBoolean() ? AvroSerDe$.MODULE$.Serializer(dataframe).toAvro(properties.getProperty(this.PARAM_AVRO_RECORD_NAME()), properties.getProperty(this.PARAM_AVRO_RECORD_NAMESPACE())) : AvroSerDe$.MODULE$.Serializer(dataframe).toAvro(properties.getProperty(this.PARAM_PAYLOAD_AVRO_SCHEMA()));
    }

    private List<Row> createRows(int howMany) {
        return ComplexRecordsGenerator$.MODULE$.generateUnparsedRows(howMany);
    }

    private Encoder<Row> getEncoder() {
        Schema avroSchema = AvroSchemaUtils$.MODULE$.parse(ComplexRecordsGenerator$.MODULE$.usedAvroSchema());
        StructType sparkSchema = SparkAvroConversions$.MODULE$.toSqlType(avroSchema);
        return RowEncoder$.MODULE$.apply(sparkSchema);
    }

    private KafkaAvroWriter$() {
        MODULE$ = this;
        this.PARAM_JOB_NAME = "job.name";
        this.PARAM_JOB_MASTER = "job.master";
        this.PARAM_KEY_AVRO_SCHEMA = "key.avro.schema";
        this.PARAM_PAYLOAD_AVRO_SCHEMA = "payload.avro.schema";
        this.PARAM_AVRO_RECORD_NAME = "avro.record.name";
        this.PARAM_AVRO_RECORD_NAMESPACE = "avro.record.namespace";
        this.PARAM_INFER_SCHEMA = "infer.schema";
        this.PARAM_LOG_LEVEL = "log.level";
        this.PARAM_TEST_DATA_ENTRIES = "test.data.entries";
        this.PARAM_EXECUTION_REPEAT = "execution.repeat";
        this.PARAM_NUM_PARTITIONS = "num.partitions";
    }
}

