/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.avro.schemas;

import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import za.co.absa.abris.avro.read.confluent.SchemaManager$;

public final class SchemaLoader$ {
    public static SchemaLoader$ MODULE$;

    static {
        new SchemaLoader$();
    }

    public String loadFromFile(String path) {
        String string;
        if (path == null) {
            throw new IllegalArgumentException("Null path informed. Please make sure you provide a valid path to an existing Avro schema located in some file system.");
        }
        FileSystem hdfs = FileSystem.get((Configuration)new Configuration());
        try (FSDataInputStream stream = hdfs.open(new Path(path));){
            string = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((InputStream)stream)).asScala()).mkString("\n");
        }
        return string;
    }

    public Schema loadFromSchemaRegistryValue(Map<String, String> params) {
        this.configureSchemaManager(params);
        String topic = (String)params.apply((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_REGISTRY_TOPIC());
        String specifiedSchemaId = (String)params.apply((Object)SchemaManager$.MODULE$.PARAM_VALUE_SCHEMA_ID());
        return this.loadFromSchemaRegistry(topic, specifiedSchemaId, false, params);
    }

    public Schema loadFromSchemaRegistryKey(Map<String, String> params) {
        this.configureSchemaManager(params);
        String topic = (String)params.apply((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_REGISTRY_TOPIC());
        String specifiedSchemaId = (String)params.apply((Object)SchemaManager$.MODULE$.PARAM_KEY_SCHEMA_ID());
        return this.loadFromSchemaRegistry(topic, specifiedSchemaId, true, params);
    }

    public SchemaMetadata loadFromSchemaRegistry(int version, Map<String, String> params) {
        this.configureSchemaManager(params);
        String topic = (String)params.apply((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_REGISTRY_TOPIC());
        return this.loadFromSchemaRegistry(topic, false, params, version);
    }

    private Schema loadFromSchemaRegistry(String topic, String schemaSpecifiedId, boolean isKey, Map<String, String> params) {
        String schemaNamespace;
        String schemaName = (String)params.getOrElse((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_NAME_FOR_RECORD_STRATEGY(), (Function0 & Serializable & scala.Serializable)() -> null);
        Option<String> subject = SchemaManager$.MODULE$.getSubjectName(topic, isKey, (Tuple2<String, String>)new Tuple2((Object)schemaName, (Object)(schemaNamespace = (String)params.getOrElse((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_NAMESPACE_FOR_RECORD_STRATEGY(), (Function0 & Serializable & scala.Serializable)() -> null))), params);
        if (subject.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(74).append("Could not load subject for topic = '").append(topic).append("', id = '").append(schemaSpecifiedId).append("', isKey = '").append(isKey).append("' and params = '").append(params).append("'").toString());
        }
        int id = this.getSchemaId(schemaSpecifiedId, (String)subject.get());
        Option<Schema> schema = SchemaManager$.MODULE$.getBySubjectAndId((String)subject.get(), id);
        if (!schema.isDefined()) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Could not load schema for topic = '").append(topic).append("', id = '").append(schemaSpecifiedId).append("', isKey = '").append(isKey).append("' and params = '").append(params).append("'").toString());
        }
        return (Schema)schema.get();
    }

    private SchemaMetadata loadFromSchemaRegistry(String topic, boolean isKey, Map<String, String> params, int version) {
        String schemaNamespace;
        String schemaName = (String)params.getOrElse((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_NAME_FOR_RECORD_STRATEGY(), (Function0 & Serializable & scala.Serializable)() -> null);
        Option<String> subject = SchemaManager$.MODULE$.getSubjectName(topic, isKey, (Tuple2<String, String>)new Tuple2((Object)schemaName, (Object)(schemaNamespace = (String)params.getOrElse((Object)SchemaManager$.MODULE$.PARAM_SCHEMA_NAMESPACE_FOR_RECORD_STRATEGY(), (Function0 & Serializable & scala.Serializable)() -> null))), params);
        if (subject.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(79).append("Could not load subject for topic = '").append(topic).append("', version = '").append(version).append("', isKey = '").append(isKey).append("' and params = '").append(params).append("'").toString());
        }
        return (SchemaMetadata)SchemaManager$.MODULE$.getBySubjectAndVersion((String)subject.get(), version).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(78).append("Could not load schema for topic = '").append(topic).append("', version = '").append(version).append("', isKey = '").append(isKey).append("' and params = '").append(params).append("'").toString());
        });
    }

    private void configureSchemaManager(Map<String, String> params) {
        block0: {
            if (SchemaManager$.MODULE$.isSchemaRegistryConfigured()) break block0;
            SchemaManager$.MODULE$.configureSchemaRegistry(params);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getSchemaId(String paramId, String subject) {
        int n;
        String string = paramId;
        String string2 = SchemaManager$.MODULE$.PARAM_SCHEMA_ID_LATEST_NAME();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Option<Object> latest = SchemaManager$.MODULE$.getLatestVersionId(subject);
            if (!latest.isDefined()) throw new IllegalArgumentException(new StringBuilder(101).append("Could not find schema for subject '").append(subject).append("'. Are you sure Schema Registry is running and the subject exists?").toString());
            n = BoxesRunTime.unboxToInt((Object)latest.get());
            return n;
        } else {
            n = new StringOps(Predef$.MODULE$.augmentString(paramId)).toInt();
        }
        return n;
    }

    private SchemaLoader$() {
        MODULE$ = this;
    }
}

