/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.avro.read.confluent;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerDeConfig;
import io.confluent.kafka.serializers.KafkaAvroDeserializerConfig;
import java.io.Serializable;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import za.co.absa.abris.avro.subject.SubjectNameStrategyAdapter;
import za.co.absa.abris.avro.subject.SubjectNameStrategyAdapterFactory$;

public final class SchemaManager$ {
    public static SchemaManager$ MODULE$;
    private final Logger logger;
    private final String PARAM_SCHEMA_REGISTRY_TOPIC;
    private final String PARAM_SCHEMA_REGISTRY_URL;
    private final String PARAM_VALUE_SCHEMA_ID;
    private final String PARAM_KEY_SCHEMA_ID;
    private final String PARAM_SCHEMA_ID_LATEST_NAME;
    private final String PARAM_KEY_SCHEMA_NAMING_STRATEGY;
    private final String PARAM_VALUE_SCHEMA_NAMING_STRATEGY;
    private final String PARAM_SCHEMA_NAME_FOR_RECORD_STRATEGY;
    private final String PARAM_SCHEMA_NAMESPACE_FOR_RECORD_STRATEGY;
    private SchemaRegistryClient schemaRegistryClient;

    static {
        new SchemaManager$();
    }

    private Logger logger() {
        return this.logger;
    }

    public String PARAM_SCHEMA_REGISTRY_TOPIC() {
        return this.PARAM_SCHEMA_REGISTRY_TOPIC;
    }

    public String PARAM_SCHEMA_REGISTRY_URL() {
        return this.PARAM_SCHEMA_REGISTRY_URL;
    }

    public String PARAM_VALUE_SCHEMA_ID() {
        return this.PARAM_VALUE_SCHEMA_ID;
    }

    public String PARAM_KEY_SCHEMA_ID() {
        return this.PARAM_KEY_SCHEMA_ID;
    }

    public String PARAM_SCHEMA_ID_LATEST_NAME() {
        return this.PARAM_SCHEMA_ID_LATEST_NAME;
    }

    public String PARAM_KEY_SCHEMA_NAMING_STRATEGY() {
        return this.PARAM_KEY_SCHEMA_NAMING_STRATEGY;
    }

    public String PARAM_VALUE_SCHEMA_NAMING_STRATEGY() {
        return this.PARAM_VALUE_SCHEMA_NAMING_STRATEGY;
    }

    public String PARAM_SCHEMA_NAME_FOR_RECORD_STRATEGY() {
        return this.PARAM_SCHEMA_NAME_FOR_RECORD_STRATEGY;
    }

    public String PARAM_SCHEMA_NAMESPACE_FOR_RECORD_STRATEGY() {
        return this.PARAM_SCHEMA_NAMESPACE_FOR_RECORD_STRATEGY;
    }

    private SchemaRegistryClient schemaRegistryClient() {
        return this.schemaRegistryClient;
    }

    private void schemaRegistryClient_$eq(SchemaRegistryClient x$1) {
        this.schemaRegistryClient = x$1;
    }

    public Option<String> getSubjectName(String topic, boolean isKey, Schema schema, Map<String, String> params) {
        None$ none$;
        SubjectNameStrategyAdapter adapter = this.getSubjectNamingStrategyAdapter(isKey, params);
        if (adapter.validate(schema)) {
            String subjectName = adapter.subjectName(topic, isKey, schema);
            this.logger().info(new StringBuilder(26).append("Subject name resolved to: ").append(subjectName).toString());
            none$ = new Some((Object)subjectName);
        } else {
            this.logger().error(new StringBuilder(252).append("Invalid configuration for naming strategy. Are you using RecordName or TopicRecordName? ").append("If yes, are you providing SchemaManager.PARAM_SCHEMA_NAME_FOR_RECORD_STRATEGY and ").append("SchemaManager.PARAM_SCHEMA_NAMESPACE_FOR_RECORD_STRATEGY in the configuration map?").toString());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<String> getSubjectName(String topic, boolean isKey, Tuple2<String, String> schemaNameAndSpace, Map<String, String> params) {
        return this.getSubjectName(topic, isKey, Schema.createRecord((String)((String)schemaNameAndSpace._1()), (String)"", (String)((String)schemaNameAndSpace._2()), (boolean)false), params);
    }

    private SubjectNameStrategyAdapter getSubjectNamingStrategyAdapter(boolean isKey, Map<String, String> params) {
        String strategy = isKey ? (String)params.getOrElse((Object)this.PARAM_KEY_SCHEMA_NAMING_STRATEGY(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(27).append("Parameter not specified: '").append(MODULE$.PARAM_KEY_SCHEMA_NAMING_STRATEGY()).append("'").toString());
        }) : (String)params.getOrElse((Object)this.PARAM_VALUE_SCHEMA_NAMING_STRATEGY(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(27).append("Parameter not specified: '").append(MODULE$.PARAM_VALUE_SCHEMA_NAMING_STRATEGY()).append("'").toString());
        });
        return SubjectNameStrategyAdapterFactory$.MODULE$.build(strategy);
    }

    public void configureSchemaRegistry(Map<String, String> configs) {
        block0: {
            if (!configs.nonEmpty()) break block0;
            this.configureSchemaRegistry((AbstractKafkaAvroSerDeConfig)new KafkaAvroDeserializerConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(configs).asJava()));
        }
    }

    public Option<Schema> getBySubjectAndId(String subject, int id) {
        None$ none$;
        this.logger().debug(new StringBuilder(45).append("Trying to get schema for subject '").append(subject).append("' and id '").append(id).append("'").toString());
        if (this.isSchemaRegistryConfigured()) {
            try {
                none$ = new Some((Object)this.schemaRegistryClient().getBySubjectAndId(subject, id));
            }
            catch (Exception e) {
                e.printStackTrace();
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<SchemaMetadata> getBySubjectAndVersion(String subject, int version) {
        None$ none$;
        this.logger().debug(new StringBuilder(50).append("Trying to get schema for subject '").append(subject).append("' and version '").append(version).append("'").toString());
        if (this.isSchemaRegistryConfigured()) {
            try {
                none$ = new Some((Object)this.schemaRegistryClient().getSchemaMetadata(subject, version));
            }
            catch (Exception e) {
                e.printStackTrace();
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Schema> getById(int id) {
        return this.getBySubjectAndId(null, id);
    }

    public Option<Object> getLatestVersionId(String subject) {
        None$ none$;
        this.logger().info(new StringBuilder(53).append("Trying to get latest schema version id for subject '").append(subject).append("'").toString());
        if (this.isSchemaRegistryConfigured()) {
            try {
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)this.schemaRegistryClient().getLatestSchemaMetadata(subject).getId()));
            }
            catch (Exception e) {
                e.printStackTrace();
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Object> register(Schema schema, String subject) {
        return this.isSchemaRegistryConfigured() ? new Some((Object)BoxesRunTime.boxToInteger((int)this.schemaRegistryClient().register(subject, schema))) : None$.MODULE$;
    }

    public boolean isSchemaRegistryConfigured() {
        return this.schemaRegistryClient() != null;
    }

    private void configureSchemaRegistry(AbstractKafkaAvroSerDeConfig config) {
        try {
            List urls = config.getSchemaRegistryUrls();
            int maxSchemaObject = config.getMaxSchemasPerSubject();
            if (this.schemaRegistryClient() == null) {
                this.schemaRegistryClient_$eq((SchemaRegistryClient)new CachedSchemaRegistryClient(urls, maxSchemaObject));
            }
        }
        catch (io.confluent.common.config.ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    public void setConfiguredSchemaRegistry(SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistryClient_$eq(schemaRegistryClient);
    }

    public boolean isCompatible(Schema newSchema, String subject) {
        return this.schemaRegistryClient().testCompatibility(subject, newSchema);
    }

    public boolean exists(String subject) {
        boolean bl;
        try {
            this.schemaRegistryClient().getLatestSchemaMetadata(subject);
            bl = true;
        }
        catch (Exception e) {
            if (e.getMessage().contains("Subject not found") || e.getMessage().contains("No schema registered")) {
                this.logger().info(new StringBuilder(26).append("Subject not registered: '").append(subject).append("'").toString());
            } else {
                this.logger().error(new StringBuilder(55).append("Problems found while retrieving metadata for subject '").append(subject).append("'").toString(), (Throwable)e);
            }
            bl = false;
        }
        return bl;
    }

    public void reset() {
        this.schemaRegistryClient_$eq(null);
    }

    private SchemaManager$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.PARAM_SCHEMA_REGISTRY_TOPIC = "schema.registry.topic";
        this.PARAM_SCHEMA_REGISTRY_URL = "schema.registry.url";
        this.PARAM_VALUE_SCHEMA_ID = "value.schema.id";
        this.PARAM_KEY_SCHEMA_ID = "key.schema.id";
        this.PARAM_SCHEMA_ID_LATEST_NAME = "latest";
        this.PARAM_KEY_SCHEMA_NAMING_STRATEGY = "key.schema.naming.strategy";
        this.PARAM_VALUE_SCHEMA_NAMING_STRATEGY = "value.schema.naming.strategy";
        this.PARAM_SCHEMA_NAME_FOR_RECORD_STRATEGY = "schema.name";
        this.PARAM_SCHEMA_NAMESPACE_FOR_RECORD_STRATEGY = "schema.namespace";
    }
}

